/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.tools.compatibility.internal;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactDescriptorPolicy;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.DependencyResult;
import org.eclipse.aether.resolution.ResolutionErrorPolicy;
import org.eclipse.aether.supplier.RepositorySystemSupplier;
import org.eclipse.aether.util.repository.SimpleArtifactDescriptorPolicy;
import org.eclipse.aether.util.repository.SimpleResolutionErrorPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DependencyResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(DependencyResolver.class);

    private DependencyResolver() {
    }

    static ClassLoader toClassLoader(String info, Stream<Artifact> artifacts, ClassLoader parentClassLoader) {
        if (parentClassLoader == null) {
            parentClassLoader = ClassLoader.getSystemClassLoader().getParent();
        }
        return DependencyResolver.asIndependentClassLoader(info, DependencyResolver.toUrls(artifacts), parentClassLoader);
    }

    static Stream<URL> toUrls(Stream<Artifact> artifacts) {
        return artifacts.map(Artifact::getFile).map(File::toURI).map(u -> {
            try {
                return u.toURL();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        });
    }

    static ClassLoader asIndependentClassLoader(String info, Stream<URL> classpath, ClassLoader parentClassLoader) {
        return new VersionClassLoader(info, (URL[])classpath.toArray(URL[]::new), parentClassLoader);
    }

    public static Stream<Artifact> resolve(Consumer<CollectRequest> collect) throws DependencyResolutionException {
        RepositorySystem repositorySystem = new RepositorySystemSupplier().get();
        RepositorySystemSession repositorySystemSession = DependencyResolver.newSession(repositorySystem);
        List<RemoteRepository> repositories = Collections.singletonList(new RemoteRepository.Builder("maven-central", "default", "https://repo1.maven.org/maven2/").build());
        CollectRequest collectRequest = new CollectRequest().setRepositories(repositories);
        collect.accept(collectRequest);
        collectRequest.setRequestContext("project");
        DependencyRequest dependencyRequest = new DependencyRequest(collectRequest, null);
        DependencyResult dependencyResult = repositorySystem.resolveDependencies(repositorySystemSession, dependencyRequest);
        List exceptions = dependencyResult.getCollectExceptions();
        if (!exceptions.isEmpty()) {
            RuntimeException e = new RuntimeException("Failed to resolve " + String.valueOf(collectRequest));
            exceptions.forEach(e::addSuppressed);
            throw e;
        }
        LOGGER.debug("Resolved artifact '{}' to {} artifact results", (Object)collectRequest.getRoot().getArtifact(), (Object)dependencyResult.getArtifactResults().size());
        return dependencyResult.getArtifactResults().stream().map(ArtifactResult::getArtifact);
    }

    private static RepositorySystemSession newSession(RepositorySystem system) {
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        String localRepository = System.getProperty("localRepository");
        if (localRepository == null) {
            localRepository = String.format("%s/.m2/repository", System.getProperty("user.home"));
        }
        LocalRepository localRepo = new LocalRepository(localRepository);
        session.setLocalRepositoryManager(system.newLocalRepositoryManager((RepositorySystemSession)session, localRepo));
        session.setArtifactDescriptorPolicy((ArtifactDescriptorPolicy)new SimpleArtifactDescriptorPolicy(0));
        session.setResolutionErrorPolicy((ResolutionErrorPolicy)new SimpleResolutionErrorPolicy(0));
        System.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
            String key = k.toString();
            if (key.startsWith("java.") || key.startsWith("file.") || key.startsWith("os.") || key.endsWith(".separator") || key.endsWith(".encoding") || key.startsWith("sun.") || key.startsWith("user.")) {
                session.setSystemProperty(key, v.toString());
            }
        }));
        return session;
    }

    static final class VersionClassLoader
    extends URLClassLoader {
        private final String info;

        VersionClassLoader(String info, URL[] urls, ClassLoader parent) {
            super(urls, parent);
            this.info = info;
        }

        public String toString() {
            return String.format("VersionClassLoader for %s (%s)", this.info, super.toString());
        }
    }
}

