/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.tools.compatibility.internal;

import java.net.URI;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.projectnessie.client.api.NessieApi;
import org.projectnessie.tools.compatibility.api.Version;
import org.projectnessie.tools.compatibility.internal.CurrentNessieServer;
import org.projectnessie.tools.compatibility.internal.OldNessieServer;
import org.projectnessie.tools.compatibility.internal.ServerKey;
import org.projectnessie.tools.compatibility.internal.Util;

interface NessieServer
extends ExtensionContext.Store.CloseableResource {
    public static NessieServer nessieServerExisting(ExtensionContext context, ServerKey serverKey) {
        return Objects.requireNonNull((NessieServer)Util.extensionStore(context).get((Object)serverKey, NessieServer.class), "No Nessie server for " + String.valueOf(serverKey));
    }

    public static NessieServer nessieServer(ExtensionContext context, ServerKey serverKey, BooleanSupplier initRepo, Consumer<Object> backendConfigConsumer) {
        if (Version.CURRENT.equals(serverKey.getVersion())) {
            return CurrentNessieServer.currentNessieServer(context, serverKey, initRepo, backendConfigConsumer);
        }
        return OldNessieServer.oldNessieServer(context, serverKey, initRepo, backendConfigConsumer);
    }

    public URI getUri(Class<? extends NessieApi> var1);
}

