/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.tools.compatibility.internal;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collections;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.projectnessie.client.api.NessieApi;
import org.projectnessie.tools.compatibility.api.Version;
import org.projectnessie.tools.compatibility.internal.AbstractNessieApiHolder;
import org.projectnessie.tools.compatibility.internal.ClientKey;
import org.projectnessie.tools.compatibility.internal.OldNessie;
import org.projectnessie.tools.compatibility.internal.TranslatingVersionNessieApi;
import org.projectnessie.tools.compatibility.internal.Util;

final class OldNessieApiHolder
extends AbstractNessieApiHolder {
    private final TranslatingVersionNessieApi translatingApiInstance;

    OldNessieApiHolder(ExtensionContext extensionContext, ClientKey clientKey) {
        super(clientKey);
        ClassLoader oldVersionClassLoader = this.nessieVersionClassLoader(extensionContext);
        this.translatingApiInstance = new TranslatingVersionNessieApi(clientKey.getVersion(), OldNessieApiHolder.createNessieClient(oldVersionClassLoader, clientKey), clientKey.getType(), oldVersionClassLoader);
    }

    @Override
    public NessieApi getApiInstance() {
        return this.translatingApiInstance.getNessieApi();
    }

    @VisibleForTesting
    TranslatingVersionNessieApi getTranslatingApiInstance() {
        return this.translatingApiInstance;
    }

    private ClassLoader nessieVersionClassLoader(ExtensionContext context) {
        return (ClassLoader)Util.extensionStore(context.getRoot()).getOrComputeIfAbsent((Object)this.classloaderKey(), k -> this.createClassLoader(), ClassLoader.class);
    }

    private String classloaderKey() {
        return String.format("class-loader-v%s", this.clientKey.getVersion());
    }

    private ClassLoader createClassLoader() {
        if (Version.CURRENT.equals(this.clientKey.getVersion())) {
            return Thread.currentThread().getContextClassLoader();
        }
        try {
            return OldNessie.oldNessieClassLoader(this.clientKey.getVersion(), Collections.singletonList("nessie-client"));
        }
        catch (DependencyResolutionException e) {
            throw new RuntimeException("Failed to resolve dependencies for Nessie client version " + String.valueOf(this.clientKey.getVersion()), e);
        }
    }
}

