/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.tools.compatibility.internal;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.projectnessie.client.api.NessieApi;
import org.projectnessie.tools.compatibility.api.Version;
import org.projectnessie.tools.compatibility.internal.JerseyForOldServerClassLoader;
import org.projectnessie.tools.compatibility.internal.NessieServer;
import org.projectnessie.tools.compatibility.internal.OldNessie;
import org.projectnessie.tools.compatibility.internal.OldServerConnectionProvider;
import org.projectnessie.tools.compatibility.internal.ServerKey;
import org.projectnessie.tools.compatibility.internal.Util;
import org.projectnessie.tools.compatibility.jersey.ServerConfigExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class OldNessieServer
implements NessieServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(OldNessieServer.class);
    private final ServerKey serverKey;
    private final OldServerConnectionProvider connectionProvider;
    private final BooleanSupplier initializeRepository;
    private final ClassLoader classLoader;
    private Exception initError;
    private URI uri;
    private AutoCloseable jerseyServer;

    static OldNessieServer oldNessieServer(ExtensionContext context, ServerKey serverKey, BooleanSupplier initializeRepository, Consumer<Object> backendConfigConsumer) {
        ExtensionContext.Store store = Util.extensionStore(context);
        ClassLoader classLoader = OldNessieServer.classLoader(store, serverKey.getVersion());
        OldServerConnectionProvider connectionProvider = OldNessieServer.oldConnectionProvider(store, classLoader, serverKey, backendConfigConsumer);
        return (OldNessieServer)store.getOrComputeIfAbsent((Object)serverKey, v -> new OldNessieServer(serverKey, connectionProvider, classLoader, initializeRepository), OldNessieServer.class);
    }

    private static OldServerConnectionProvider oldConnectionProvider(ExtensionContext.Store store, ClassLoader classLoader, ServerKey serverKey, Consumer<Object> backendConfigConsumer) {
        return (OldServerConnectionProvider)store.getOrComputeIfAbsent((Object)OldNessieServer.connectionProviderKey(serverKey), v -> new OldServerConnectionProvider(serverKey, classLoader, backendConfigConsumer), OldServerConnectionProvider.class);
    }

    private static String connectionProviderKey(ServerKey serverKey) {
        return "old-nessie-connection-provider-" + String.valueOf(serverKey);
    }

    private static String classLoaderKey(Version version) {
        return "old-nessie-class-loader-" + String.valueOf(version);
    }

    private static ClassLoader classLoader(ExtensionContext.Store store, Version version) {
        return (ClassLoader)store.getOrComputeIfAbsent((Object)OldNessieServer.classLoaderKey(version), x -> {
            ClassLoader appClassLoader = Thread.currentThread().getContextClassLoader();
            ClassLoader classLoader = OldNessieServer.createClassLoader(version);
            return new JerseyForOldServerClassLoader(version, classLoader, appClassLoader);
        }, ClassLoader.class);
    }

    static ClassLoader createClassLoader(Version version) {
        List<String> artifactIds = Arrays.asList("nessie-compatibility-common", "nessie-versioned-storage-mongodb", "nessie-versioned-storage-rocksdb");
        try {
            return OldNessie.oldNessieClassLoader(version, artifactIds);
        }
        catch (DependencyResolutionException e) {
            throw new RuntimeException("Failed to resolve dependencies for Nessie server version " + String.valueOf(version), e);
        }
    }

    private OldNessieServer(ServerKey serverKey, OldServerConnectionProvider connectionProvider, ClassLoader classLoader, BooleanSupplier initializeRepository) {
        this.serverKey = serverKey;
        this.classLoader = classLoader;
        this.connectionProvider = connectionProvider;
        this.initializeRepository = initializeRepository;
    }

    @Override
    public URI getUri(Class<? extends NessieApi> apiType) {
        if (this.uri == null) {
            this.tryStart();
        }
        return Util.resolveNessieUri(this.uri, this.serverKey.getVersion(), apiType);
    }

    private void tryStart() {
        if (this.initError != null) {
            throw new IllegalStateException(String.format("Nessie Server for version %s not initialized", this.serverKey.getVersion()), this.initError);
        }
        try {
            Util.withClassLoader(this.classLoader, () -> {
                Object persist = this.createPersist(this.classLoader);
                Supplier<Object> persistsSupplier = () -> persist;
                Class<?> jerseyServerClass = this.classLoader.loadClass("org.projectnessie.tools.compatibility.jersey.JerseyServer");
                try {
                    this.jerseyServer = (AutoCloseable)jerseyServerClass.getConstructor(Supplier.class, Supplier.class).newInstance(null, persistsSupplier);
                }
                catch (NoSuchMethodException e) {
                    this.jerseyServer = (AutoCloseable)jerseyServerClass.getConstructor(Supplier.class).newInstance(persistsSupplier);
                }
                this.uri = (URI)jerseyServerClass.getMethod("getUri", new Class[0]).invoke((Object)this.jerseyServer, new Object[0]);
                return null;
            });
            LOGGER.info("Nessie Server for version {} with {} started at {} using {}", new Object[]{this.serverKey.getVersion(), this.serverKey.getStorageName(), this.uri, this.serverKey.getConfig()});
        }
        catch (Exception e) {
            this.initError = e;
            throw new RuntimeException(String.format("Failed to setup/start Nessie server for version %s with %s using %s", this.serverKey.getVersion(), this.serverKey.getStorageName(), this.serverKey.getConfig()), e);
        }
    }

    private Object createPersist(ClassLoader classLoader) throws Exception {
        AutoCloseable backend = this.connectionProvider.connectionProvider;
        Class<?> classBackend = classLoader.loadClass("org.projectnessie.versioned.storage.common.persist.Backend");
        Class<?> classPersistFactory = classLoader.loadClass("org.projectnessie.versioned.storage.common.persist.PersistFactory");
        Class<?> classPersist = classLoader.loadClass("org.projectnessie.versioned.storage.common.persist.Persist");
        Class<?> classLogics = classLoader.loadClass("org.projectnessie.versioned.storage.common.logic.Logics");
        Class<?> classStoreConfig = classLoader.loadClass("org.projectnessie.versioned.storage.common.config.StoreConfig");
        Class<?> classStoreConfigAdjustable = classLoader.loadClass("org.projectnessie.versioned.storage.common.config.StoreConfig$Adjustable");
        Class<?> classRepositoryLogic = classLoader.loadClass("org.projectnessie.versioned.storage.common.logic.RepositoryLogic");
        Object persistFactory = classBackend.getMethod("createFactory", new Class[0]).invoke((Object)backend, new Object[0]);
        Object storeConfig = classStoreConfigAdjustable.getMethod("empty", new Class[0]).invoke(null, new Object[0]);
        storeConfig = classStoreConfigAdjustable.getMethod("fromFunction", Function.class).invoke(storeConfig, p -> this.serverKey.getConfig().get("nessie.store." + p));
        Object persist = classPersistFactory.getMethod("newPersist", classStoreConfig).invoke(persistFactory, storeConfig);
        if (this.initializeRepository.getAsBoolean()) {
            classPersist.getMethod("erase", new Class[0]).invoke(persist, new Object[0]);
            Object repositoryLogic = classLogics.getMethod("repositoryLogic", classPersist).invoke(null, persist);
            classRepositoryLogic.getMethod("initialize", String.class).invoke(repositoryLogic, ServerConfigExtension.SERVER_CONFIG.getDefaultBranch());
        }
        return persist;
    }

    public void close() throws Throwable {
        if (this.jerseyServer != null) {
            this.jerseyServer.close();
        }
    }
}

