/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.tools.compatibility.internal;

import java.util.function.Consumer;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.projectnessie.tools.compatibility.internal.Configurations;
import org.projectnessie.tools.compatibility.internal.ServerKey;
import org.projectnessie.tools.compatibility.internal.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OldServerConnectionProvider
implements ExtensionContext.Store.CloseableResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(OldServerConnectionProvider.class);
    private final ServerKey serverKey;
    final AutoCloseable connectionProvider;

    OldServerConnectionProvider(ServerKey serverKey, ClassLoader classLoader, Consumer<Object> backendConfigConsumer) {
        try {
            this.serverKey = serverKey;
            LOGGER.info("Creating connection provider for Nessie version {} with {} using {}", new Object[]{serverKey.getVersion(), serverKey.getStorageName(), serverKey.getConfig()});
            this.connectionProvider = OldServerConnectionProvider.createBackend(classLoader, serverKey, backendConfigConsumer);
        }
        catch (Exception e) {
            throw Util.throwUnchecked(e);
        }
    }

    static AutoCloseable createBackend(ClassLoader classLoader, ServerKey serverKey, Consumer<Object> backendConfigConsumer) {
        try {
            Object backendFactory = Util.withClassLoader(classLoader, () -> classLoader.loadClass("org.projectnessie.versioned.storage.common.persist.PersistLoader").getMethod("findFactoryByName", String.class).invoke(null, serverKey.getStorageName()));
            Object backendConfigBuilder = Util.withClassLoader(classLoader, () -> classLoader.loadClass(backendFactory.getClass().getName().replace("BackendFactory", "BackendConfig")).getDeclaredMethod("builder", new Class[0]).invoke(null, new Object[0]));
            Configurations.backendConfigBuilderApply(backendConfigBuilder.getClass(), backendConfigBuilder, serverKey.getConfig()::get);
            return Util.withClassLoader(classLoader, () -> {
                backendConfigConsumer.accept(backendConfigBuilder);
                Object backendConfig = backendConfigBuilder.getClass().getMethod("build", new Class[0]).invoke(backendConfigBuilder, new Object[0]);
                AutoCloseable backend = (AutoCloseable)backendFactory.getClass().getMethod("buildBackend", Object.class).invoke(backendFactory, backendConfig);
                classLoader.loadClass("org.projectnessie.versioned.storage.common.persist.Backend").getMethod("setupSchema", new Class[0]).invoke((Object)backend, new Object[0]);
                return backend;
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void close() throws Throwable {
        if (this.connectionProvider != null) {
            LOGGER.info("Closing connection provider for Nessie version {} with {} using {}", new Object[]{this.serverKey.getVersion(), this.serverKey.getStorageName(), this.serverKey.getConfig()});
            this.connectionProvider.close();
        }
    }
}

