/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.tools.compatibility.internal;

import java.io.Closeable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.projectnessie.tools.compatibility.api.TargetVersion;
import org.projectnessie.tools.compatibility.api.Version;
import org.projectnessie.tools.compatibility.internal.AbstractMultiVersionExtension;
import org.projectnessie.tools.compatibility.internal.AbstractNessieApiHolder;
import org.projectnessie.tools.compatibility.internal.AnnotatedFields;
import org.projectnessie.tools.compatibility.internal.GlobalForClass;
import org.projectnessie.tools.compatibility.internal.NessieServer;
import org.projectnessie.tools.compatibility.internal.ServerKey;
import org.projectnessie.tools.compatibility.internal.Util;
import org.projectnessie.versioned.storage.mongodbtests.MongoDBBackendTestFactory;

public class RollingUpgradesExtension
extends AbstractMultiVersionExtension {
    public void beforeAll(ExtensionContext context) {
        Version version = this.populateNessieVersionAnnotatedFields(context, null);
        if (version == null) {
            return;
        }
        MongoHolder mongo = RollingUpgradesExtension.getMongoHolder(context);
        mongo.start();
        ServerKey serverKey = this.buildServerKey(version, context);
        Consumer<Object> mongoConfigure = c -> {
            try {
                Method setClient = Arrays.stream(c.getClass().getMethods()).filter(m -> m.getName().equals("client")).findFirst().orElseThrow(() -> new IllegalStateException("No such method client(MongoClient) on " + c.getClass().getName()));
                c.getClass().getMethod("databaseName", String.class).invoke(c, mongo.mongo.getDatabaseName());
                ClassLoader classLoader = setClient.getParameterTypes()[0].getClassLoader();
                Object mongoClient = classLoader.loadClass("com.mongodb.client.MongoClients").getMethod("create", String.class).invoke(null, mongo.mongo.getConnectionString());
                Util.extensionStore(context).put((Object)"mongo-client", () -> ((Closeable)mongoClient).close());
                setClient.invoke(c, mongoClient);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
        NessieServer nessieServer = NessieServer.nessieServer(context, serverKey, () -> true, mongoConfigure);
        this.populateNessieApiFields(context, null, version, TargetVersion.TESTED, ctx -> nessieServer);
        ServerKey serverKeyNext = this.buildServerKey(Version.CURRENT, context);
        NessieServer nessieServerNext = NessieServer.nessieServer(context, serverKeyNext, () -> false, mongoConfigure);
        this.populateNessieApiFields(context, null, Version.CURRENT, TargetVersion.CURRENT, ctx -> nessieServerNext);
    }

    public void beforeEach(ExtensionContext context) {
        Object testInstance = context.getRequiredTestInstance();
        Version version = this.populateNessieVersionAnnotatedFields(context, testInstance);
        if (version == null) {
            return;
        }
        ServerKey serverKey = this.buildServerKey(version, context);
        NessieServer nessieServer = NessieServer.nessieServerExisting(context, serverKey);
        this.populateNessieApiFields(context, testInstance, version, TargetVersion.TESTED, ctx -> nessieServer);
        ServerKey serverKeyNext = this.buildServerKey(Version.CURRENT, context);
        NessieServer nessieServerNext = NessieServer.nessieServerExisting(context, serverKeyNext);
        this.populateNessieApiFields(context, testInstance, Version.CURRENT, TargetVersion.CURRENT, ctx -> nessieServerNext);
    }

    private ServerKey buildServerKey(Version version, ExtensionContext context) {
        MongoHolder mongo = RollingUpgradesExtension.getMongoHolder(context);
        Map configuration = mongo.mongo.getQuarkusConfig();
        return ServerKey.forContext(context, version, "MongoDB", configuration);
    }

    private static MongoHolder getMongoHolder(ExtensionContext context) {
        return GlobalForClass.globalForClass(context).getOrCompute("local-mongo", x -> new MongoHolder(), MongoHolder.class);
    }

    private void populateNessieApiFields(ExtensionContext context, Object instance, Version version, TargetVersion targetVersion, Function<ExtensionContext, NessieServer> nessieServerSupplier) {
        AnnotatedFields.populateNessieApiFields(context, instance, targetVersion, field -> AbstractNessieApiHolder.apiInstanceForField(context, field, version, nessieServerSupplier));
    }

    static class MongoHolder
    implements ExtensionContext.Store.CloseableResource {
        final MongoDBBackendTestFactory mongo = new MongoDBBackendTestFactory();
        boolean started;

        MongoHolder() {
        }

        synchronized void start() {
            if (!this.started) {
                this.mongo.start();
                this.started = true;
            }
        }

        public void close() {
            this.mongo.stop();
        }
    }
}

