/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.tools.compatibility.internal;

import java.lang.reflect.AnnotatedElement;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.support.AnnotationSupport;
import org.projectnessie.tools.compatibility.api.NessieServerProperty;
import org.projectnessie.tools.compatibility.api.Version;
import org.projectnessie.tools.compatibility.internal.Util;

final class ServerKey {
    private final Version version;
    private final String storageName;
    private final Map<String, String> config;

    ServerKey(Version version, String storageName, Map<String, String> config) {
        this.version = Objects.requireNonNull(version, "version");
        this.storageName = Objects.requireNonNull(storageName, "storageName");
        this.config = Objects.requireNonNull(config, "config");
    }

    public static ServerKey forContext(ExtensionContext context, Version version, String storageName, Map<String, String> defaultConfig) {
        HashMap<String, String> config = new HashMap<String, String>(defaultConfig);
        Util.forEachContextFromRoot(context, c -> c.getTestClass().ifPresent(instance -> AnnotationSupport.findRepeatableAnnotations((AnnotatedElement)instance, NessieServerProperty.class).forEach(prop -> config.put(prop.name(), prop.value()))));
        return new ServerKey(version, storageName, config);
    }

    Version getVersion() {
        return this.version;
    }

    String getStorageName() {
        return this.storageName;
    }

    Map<String, String> getConfig() {
        return this.config;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerKey serverKey = (ServerKey)o;
        return Objects.equals(this.version, serverKey.version) && Objects.equals(this.storageName, serverKey.storageName) && Objects.equals(this.config, serverKey.config);
    }

    public int hashCode() {
        return Objects.hash(this.version, this.storageName, this.config);
    }

    public String toString() {
        return String.format("server-%s-%s-%s", this.getVersion(), this.storageName, this.config.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining("_")));
    }
}

