/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.tools.compatibility.internal;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Objects;
import org.junit.jupiter.api.extension.ExtensionContext;

final class TemporaryDirectory
implements ExtensionContext.Store.CloseableResource {
    private Path path;

    TemporaryDirectory() {
    }

    synchronized Path getPath() {
        if (this.path == null) {
            try {
                this.path = Files.createTempDirectory("junit-rocks", new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.path;
    }

    public void close() throws Throwable {
        if (Files.notExists(this.path, new LinkOption[0])) {
            return;
        }
        final ArrayList failures = new ArrayList();
        Files.walkFileTree(this.path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) {
                return this.tryDelete(file);
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                return this.tryDelete(dir);
            }

            private FileVisitResult tryDelete(Path path) {
                try {
                    Files.delete(path);
                }
                catch (NoSuchFileException noSuchFileException) {
                }
                catch (IOException e) {
                    failures.add(e);
                }
                return FileVisitResult.CONTINUE;
            }
        });
        if (!failures.isEmpty()) {
            IOException e = new IOException("Could not delete temp-directory " + String.valueOf(this.path));
            failures.forEach(e::addSuppressed);
            throw e;
        }
    }

    public String toString() {
        return "TemporaryDirectory{path=" + String.valueOf(this.path) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TemporaryDirectory that = (TemporaryDirectory)o;
        return Objects.equals(this.path, that.path);
    }

    public int hashCode() {
        return Objects.hash(this.path);
    }
}

