/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.tools.compatibility.internal;

import com.google.common.annotations.VisibleForTesting;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.projectnessie.client.api.NessieApi;
import org.projectnessie.error.ErrorCode;
import org.projectnessie.error.ImmutableNessieError;
import org.projectnessie.error.NessieError;
import org.projectnessie.model.ser.Views;
import org.projectnessie.tools.compatibility.api.Version;
import org.projectnessie.tools.compatibility.internal.Util;

final class TranslatingVersionNessieApi
implements AutoCloseable {
    private final AutoCloseable oldVersionApiInstance;
    private final IdentityHashMap<ClassLoader, Object> objectMappers = new IdentityHashMap();
    private final ClassLoader oldVersionClassLoader;
    private final NessieApi proxy;
    private final Version version;

    TranslatingVersionNessieApi(Version version, AutoCloseable oldVersionApiInstance, Class<? extends NessieApi> currentVersionApiType, ClassLoader oldVersionClassLoader) {
        this.version = version;
        this.oldVersionApiInstance = oldVersionApiInstance;
        this.oldVersionClassLoader = oldVersionClassLoader;
        this.proxy = (NessieApi)this.createProxy(oldVersionApiInstance, Thread.currentThread().getContextClassLoader(), oldVersionClassLoader, currentVersionApiType);
    }

    @Override
    public void close() throws Exception {
        this.oldVersionApiInstance.close();
    }

    NessieApi getNessieApi() {
        return this.proxy;
    }

    @VisibleForTesting
    AutoCloseable getOldVersionApiInstance() {
        return this.oldVersionApiInstance;
    }

    @VisibleForTesting
    Object[] translateArgs(Object[] args, ClassLoader targetClassLoader, ClassLoader reverseClassLoader) {
        if (args == null) {
            return null;
        }
        Object[] translated = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            translated[i] = this.translateObject(args[i], targetClassLoader, reverseClassLoader);
        }
        return translated;
    }

    @VisibleForTesting
    Throwable translateException(Throwable e) {
        int status = 0;
        String reason = "<unknown>";
        String exceptionClassName = e.getClass().getName();
        if (!exceptionClassName.startsWith("org.projectnessie.error.")) {
            switch (exceptionClassName) {
                case "org.projectnessie.client.rest.NessieBadRequestException": {
                    status = 400;
                    exceptionClassName = "org.projectnessie.error.NessieBadRequestException";
                    break;
                }
                case "org.projectnessie.client.rest.NessieBackendThrottledException": {
                    status = 400;
                    exceptionClassName = "org.projectnessie.error.NessieBackendThrottledException";
                    break;
                }
                case "org.projectnessie.client.rest.NessieForbiddenException": {
                    status = 401;
                    exceptionClassName = "org.projectnessie.error.NessieForbiddenException";
                    break;
                }
                case "org.projectnessie.client.rest.NessieInternalServerException": {
                    status = 500;
                    break;
                }
                case "org.projectnessie.client.rest.NessieNotAuthorizedException": {
                    break;
                }
                default: {
                    return e;
                }
            }
        }
        try {
            Class<Throwable> testExceptionClass = Thread.currentThread().getContextClassLoader().loadClass(exceptionClassName).asSubclass(Throwable.class);
            Class<?> exceptionClass = e.getClass();
            ImmutableNessieError.Builder builder = ImmutableNessieError.builder().message(e.getMessage()).status(status).reason(reason);
            try {
                builder.status(((Integer)exceptionClass.getMethod("getStatus", new Class[0]).invoke((Object)e, new Object[0])).intValue());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                builder.reason((String)exceptionClass.getMethod("getReason", new Class[0]).invoke((Object)e, new Object[0]));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                builder.serverStackTrace((String)exceptionClass.getMethod("getServerStackTrace", new Class[0]).invoke((Object)e, new Object[0]));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                Object oldErrorCode = exceptionClass.getMethod("getErrorCode", new Class[0]).invoke((Object)e, new Object[0]);
                String oldErrorCodeName = ((Enum)oldErrorCode).name();
                builder.errorCode(ErrorCode.valueOf((String)oldErrorCodeName));
            }
            catch (Exception oldErrorCode) {
                // empty catch block
            }
            try {
                Object oldNessieError = exceptionClass.getMethod("getError", new Class[0]).invoke((Object)e, new Object[0]);
                Class<?> oldNessieErrorClass = oldNessieError.getClass();
                builder.status(((Integer)oldNessieErrorClass.getMethod("getStatus", new Class[0]).invoke(oldNessieError, new Object[0])).intValue());
                builder.reason((String)oldNessieErrorClass.getMethod("getReason", new Class[0]).invoke(oldNessieError, new Object[0]));
                builder.message((String)oldNessieErrorClass.getMethod("getMessage", new Class[0]).invoke(oldNessieError, new Object[0]));
                builder.serverStackTrace((String)oldNessieErrorClass.getMethod("getServerStackTrace", new Class[0]).invoke(oldNessieError, new Object[0]));
                Object oldErrorCode = oldNessieErrorClass.getMethod("getErrorCode", new Class[0]).invoke(oldNessieError, new Object[0]);
                String oldErrorCodeName = ((Enum)oldErrorCode).name();
                builder.errorCode(ErrorCode.valueOf((String)oldErrorCodeName));
            }
            catch (Exception oldNessieError) {
                // empty catch block
            }
            try {
                Throwable t = testExceptionClass.getConstructor(NessieError.class).newInstance(builder.build());
                t.setStackTrace(e.getStackTrace());
                return t;
            }
            catch (NoSuchMethodException nse) {
                return testExceptionClass.getConstructor(String.class, Throwable.class).newInstance(e.getMessage(), e);
            }
        }
        catch (Exception ex) {
            return e;
        }
    }

    @VisibleForTesting
    Object translateObject(Object o, ClassLoader classLoader, ClassLoader reverseClassLoader) {
        if (o == null || o.getClass().getName().startsWith("java.lang.")) {
            return o;
        }
        if (o instanceof Map) {
            return ((Map)o).entrySet().stream().collect(Collectors.toMap(e -> this.translateObject(e.getKey(), classLoader, reverseClassLoader), e -> this.translateObject(e.getValue(), classLoader, reverseClassLoader)));
        }
        if (o instanceof List) {
            return ((List)o).stream().map(e -> this.translateObject(e, classLoader, reverseClassLoader)).collect(Collectors.toList());
        }
        if (o instanceof Set) {
            return ((Set)o).stream().map(e -> this.translateObject(e, classLoader, reverseClassLoader)).collect(Collectors.toSet());
        }
        if (o instanceof Stream) {
            return ((Stream)o).map(e -> this.translateObject(e, classLoader, reverseClassLoader));
        }
        if (TranslatingVersionNessieApi.requiresProxy(o)) {
            return this.createProxy(o, classLoader, reverseClassLoader, this.translateTypes(classLoader, TranslatingVersionNessieApi.getAllInterfaces(o.getClass())));
        }
        if (TranslatingVersionNessieApi.requiresReserialization(o)) {
            return this.reserialize(o);
        }
        return o;
    }

    private static Class<?>[] getAllInterfaces(Class<?> clazz) {
        HashSet interfaces = new HashSet();
        Collections.addAll(interfaces, clazz.getInterfaces());
        Class<?> superclass = clazz.getSuperclass();
        if (superclass != null && !superclass.equals(Object.class)) {
            Collections.addAll(interfaces, TranslatingVersionNessieApi.getAllInterfaces(superclass));
        }
        return interfaces.toArray(new Class[0]);
    }

    @VisibleForTesting
    Object reserialize(Object o) {
        try {
            ClassLoader writeClassLoader;
            ClassLoader readClassLoader;
            if (o.getClass().getClassLoader() == this.oldVersionClassLoader) {
                readClassLoader = Thread.currentThread().getContextClassLoader();
                writeClassLoader = this.oldVersionClassLoader;
            } else {
                writeClassLoader = Thread.currentThread().getContextClassLoader();
                readClassLoader = this.oldVersionClassLoader;
            }
            String serialized = this.serializeWith(writeClassLoader, o);
            return this.deserializeWith(readClassLoader, serialized, o.getClass().getName());
        }
        catch (Exception e) {
            throw Util.throwUnchecked(e);
        }
    }

    @VisibleForTesting
    String serializeWith(ClassLoader classLoader, Object o) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(classLoader);
            Object objectMapper = this.jacksonObjectMapper(classLoader);
            try {
                Class<?> jsonViewV1 = classLoader.loadClass(Views.V1.class.getName());
                objectMapper = objectMapper.getClass().getMethod("writerWithView", Class.class).invoke(objectMapper, jsonViewV1);
            }
            catch (ClassNotFoundException jsonViewV1) {
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            String string = (String)objectMapper.getClass().getMethod("writeValueAsString", Object.class).invoke(objectMapper, o);
            return string;
        }
        catch (Exception e) {
            throw Util.throwUnchecked(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    @VisibleForTesting
    Object deserializeWith(ClassLoader classLoader, String str, String typeName) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(classLoader);
            Object objectMapper = this.jacksonObjectMapper(classLoader);
            Object reader = objectMapper.getClass().getMethod("reader", new Class[0]).invoke(objectMapper, new Object[0]);
            Class<?> type = classLoader.loadClass((String)typeName);
            String simpleName = type.getSimpleName();
            if (simpleName.startsWith("Immutable")) {
                Class<?>[] ifaces = type.getInterfaces();
                typeName = ifaces.length == 1 ? ifaces[0].getName() : (type.getSuperclass() != Object.class ? type.getSuperclass().getName() : ((String)typeName).substring(0, ((String)typeName).lastIndexOf(46) + 1) + simpleName.substring("Immutable".length()));
            }
            type = classLoader.loadClass((String)typeName);
            Object object = reader.getClass().getMethod("readValue", String.class, Class.class).invoke(reader, str, type);
            return object;
        }
        catch (Exception e) {
            throw Util.throwUnchecked(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    private Object jacksonObjectMapper(ClassLoader classLoader) {
        return this.objectMappers.computeIfAbsent(classLoader, cl -> {
            try {
                Class<?> classObjectMapper = classLoader.loadClass("com.fasterxml.jackson.databind.ObjectMapper");
                return classObjectMapper.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw Util.throwUnchecked(e);
            }
        });
    }

    @VisibleForTesting
    Class<?>[] translateTypes(ClassLoader classLoader, Class<?>[] types) {
        if (types == null) {
            return null;
        }
        Class[] result = new Class[types.length];
        for (int i = 0; i < types.length; ++i) {
            Class<?> type = types[i];
            if (type.getName().startsWith("org.projectnessie.")) {
                try {
                    result[i] = classLoader.loadClass(type.getName());
                    continue;
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
            result[i] = type;
        }
        return result;
    }

    @VisibleForTesting
    static boolean requiresProxy(Object o) {
        if (o == null) {
            return false;
        }
        return o.getClass().getName().startsWith("org.projectnessie.client.");
    }

    @VisibleForTesting
    static boolean requiresReserialization(Object o) {
        if (o == null) {
            return false;
        }
        return o.getClass().getName().startsWith("org.projectnessie.model.");
    }

    private <T> T createProxy(Object o, ClassLoader classLoader, ClassLoader reverseClassLoader, Class<?> ... interfaces) {
        Object proxy;
        if (o == null) {
            return null;
        }
        Object target = proxy = Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), interfaces, (proxyInstance, method, args) -> {
            Method targetMethod;
            try {
                targetMethod = o.getClass().getMethod(method.getName(), this.translateTypes(reverseClassLoader, method.getParameterTypes()));
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(String.format("Method '%s.%s(%s)' does not exist for Nessie version %s.", method.getDeclaringClass().getName(), method.getName(), Arrays.stream(method.getParameterTypes()).map(Object::toString).collect(Collectors.joining(",")), this.version));
            }
            targetMethod.setAccessible(true);
            try {
                Object result = targetMethod.invoke(o, this.translateArgs(args, classLoader, reverseClassLoader));
                return this.translateObject(result, classLoader, reverseClassLoader);
            }
            catch (InvocationTargetException e) {
                throw this.translateException(e.getTargetException());
            }
        });
        return (T)target;
    }

    static <T extends NessieApi> T unsupportedApiInterfaceProxy(Class<T> declaredType, Version runtimeVersion) {
        NessieApi r = (NessieApi)Proxy.newProxyInstance(declaredType.getClassLoader(), TranslatingVersionNessieApi.getAllInterfaces(declaredType), (proxyInstance, method, args) -> {
            if ("close".equals(method.getName())) {
                return null;
            }
            throw new UnsupportedOperationException(String.format("Nessie API %s is not supported in version %s", declaredType.getSimpleName(), runtimeVersion));
        });
        return (T)r;
    }
}

