/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.tools.compatibility.internal;

import com.google.common.base.Throwables;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.engine.UniqueId;
import org.projectnessie.client.api.NessieApi;
import org.projectnessie.client.api.NessieApiV2;
import org.projectnessie.tools.compatibility.api.Version;

final class Util {
    static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{Util.class});

    private Util() {
    }

    static ExtensionContext.Store extensionStore(ExtensionContext context) {
        return context.getStore(NAMESPACE);
    }

    static RuntimeException throwUnchecked(Throwable e) {
        Throwables.throwIfUnchecked((Throwable)e);
        return new RuntimeException(e);
    }

    static ExtensionContext classContext(ExtensionContext context) {
        ExtensionContext c = Objects.requireNonNull(context, "context must not be null");
        while (!"class".equals(UniqueId.parse((String)c.getUniqueId()).getLastSegment().getType())) {
            Optional parent = c.getParent();
            if (parent.isEmpty()) {
                throw new IllegalArgumentException(String.format("Context %s has no class part", context.getUniqueId()));
            }
            c = (ExtensionContext)parent.get();
        }
        return c;
    }

    static void forEachContextFromRoot(ExtensionContext current, Consumer<ExtensionContext> action) {
        current.getParent().ifPresent(p -> Util.forEachContextFromRoot(p, action));
        action.accept(current);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T> T withClassLoader(ClassLoader classLoader, Callable<T> callable) throws Exception {
        ClassLoader appClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(classLoader);
        try {
            T t = callable.call();
            return t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(appClassLoader);
        }
    }

    static URI resolveNessieUri(URI base, Version version, Class<? extends NessieApi> apiType) {
        Object suffix;
        Object object = suffix = NessieApiV2.class.isAssignableFrom(apiType) ? "v2" : "v1";
        if (version.isGreaterThanOrEqual(Version.NESSIE_URL_API_SUFFIX)) {
            suffix = "api/" + (String)suffix;
        }
        return base.resolve((String)suffix);
    }
}

