/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.tools.compatibility.jersey;

import jakarta.enterprise.inject.spi.Extension;
import jakarta.ws.rs.core.Application;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.glassfish.jersey.message.DeflateEncoder;
import org.glassfish.jersey.message.GZipEncoder;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.filter.EncodingFilter;
import org.glassfish.jersey.test.JerseyTest;
import org.jboss.weld.environment.se.Weld;
import org.projectnessie.services.authz.AbstractBatchAccessChecker;
import org.projectnessie.services.authz.AccessContext;
import org.projectnessie.services.authz.BatchAccessChecker;
import org.projectnessie.services.impl.ConfigApiImpl;
import org.projectnessie.services.impl.TreeApiImpl;
import org.projectnessie.services.rest.RestConfigResource;
import org.projectnessie.services.rest.RestContentResource;
import org.projectnessie.services.rest.RestTreeResource;
import org.projectnessie.tools.compatibility.jersey.AuthorizerExtension;
import org.projectnessie.tools.compatibility.jersey.PrincipalExtension;
import org.projectnessie.tools.compatibility.jersey.ServerConfigExtension;
import org.projectnessie.tools.compatibility.jersey.VersionStoreImplExtension;
import org.projectnessie.versioned.storage.common.persist.Persist;

public class JerseyServer
implements AutoCloseable {
    private final Weld weld = new Weld();
    private final JerseyTest jerseyTest;

    public JerseyServer(Supplier<Persist> persistSupplier) throws Exception {
        this.weld.addPackages(true, new Class[]{RestConfigResource.class});
        this.weld.addPackages(true, new Class[]{TreeApiImpl.class});
        this.weld.addExtension((Extension)new PrincipalExtension());
        this.weld.addExtension((Extension)new ServerConfigExtension());
        this.weld.addExtension((Extension)VersionStoreImplExtension.forPersist(persistSupplier));
        this.weld.addExtension(this.authzExtension());
        this.weld.property("org.jboss.weld.se.shutdownHook", (Object)"false");
        this.weld.initialize();
        this.jerseyTest = new JerseyTest(){

            protected Application configure() {
                ResourceConfig config = new ResourceConfig();
                JerseyServer.withClass("org.projectnessie.services.rest.RestV2ConfigResource", arg_0 -> ((ResourceConfig)config).register(arg_0));
                JerseyServer.withClass("org.projectnessie.services.rest.RestV2TreeResource", arg_0 -> ((ResourceConfig)config).register(arg_0));
                config.register(RestConfigResource.class);
                config.register(RestTreeResource.class);
                config.register(RestContentResource.class);
                JerseyServer.withClass("org.projectnessie.services.rest.RestDiffResource", arg_0 -> ((ResourceConfig)config).register(arg_0));
                JerseyServer.withClass("org.projectnessie.services.rest.RestRefLogResource", arg_0 -> ((ResourceConfig)config).register(arg_0));
                JerseyServer.withClass("org.projectnessie.services.rest.RestNamespaceResource", arg_0 -> ((ResourceConfig)config).register(arg_0));
                config.register(ConfigApiImpl.class);
                JerseyServer.withEEClass("org.projectnessie.services.restjavax.ContentKeyParamConverterProvider", arg_0 -> ((ResourceConfig)config).register(arg_0), true);
                JerseyServer.withEEClass("org.projectnessie.services.restjavax.ReferenceTypeParamConverterProvider", arg_0 -> ((ResourceConfig)config).register(arg_0), false);
                JerseyServer.withEEClass("org.projectnessie.services.restjavax.ValidationExceptionMapper", c -> config.register(c, 10), true);
                JerseyServer.withEEClass("org.projectnessie.services.restjavax.ConstraintViolationExceptionMapper", c -> config.register(c, 10), false);
                JerseyServer.withEEClass("org.projectnessie.services.restjavax.NamespaceParamConverterProvider", arg_0 -> ((ResourceConfig)config).register(arg_0), false);
                JerseyServer.withEEClass("org.projectnessie.services.restjavax.NessieExceptionMapper", arg_0 -> ((ResourceConfig)config).register(arg_0), true);
                JerseyServer.withEEClass("org.projectnessie.services.restjakarta.AccessCheckExceptionMapper", c -> config.register(c, 10), false);
                JerseyServer.withEEClass("org.projectnessie.services.restjakarta.BackendLimitExceededExceptionMapper", c -> config.register(c, 10), false);
                JerseyServer.withEEClass("org.projectnessie.services.rest.exceptions.NotSupportedExceptionMapper", c -> config.register(c, 10), false);
                JerseyServer.withEEClass("org.projectnessie.services.restjavax.NessieJaxRsJsonParseExceptionMapper", c -> config.register(c, 10), true);
                JerseyServer.withEEClass("org.projectnessie.services.restjavax.NessieJaxRsJsonMappingExceptionMapper", c -> config.register(c, 10), true);
                config.register(EncodingFilter.class);
                config.register(GZipEncoder.class);
                config.register(DeflateEncoder.class);
                this.set("jersey.config.test.container.port", "0");
                return config;
            }
        };
        this.jerseyTest.setUp();
    }

    private Extension authzExtension() {
        try {
            return new AuthorizerExtension().setAccessCheckerSupplier(this::createNewChecker);
        }
        catch (NoClassDefFoundError e) {
            try {
                return Class.forName("org.projectnessie.services.authz.AccessCheckerExtension").asSubclass(Extension.class).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public URI getUri() {
        return this.jerseyTest.target().getUri();
    }

    private static void withClass(String className, Consumer<Class<?>> whenClassExists) {
        try {
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
            whenClassExists.accept(clazz);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private static void withEEClass(String eeClassName, Consumer<Class<?>> whenClassExists, boolean mandatory) {
        Iterator<String> classNames = List.of(eeClassName.replace("restjavax.", "rest.converters."), eeClassName.replace("restjavax.", "rest.exceptions."), eeClassName.replace("restjavax.", "rest."), eeClassName).iterator();
        while (classNames.hasNext()) {
            String className = classNames.next();
            try {
                Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
                whenClassExists.accept(clazz);
                break;
            }
            catch (ClassNotFoundException | NoClassDefFoundError e) {
                if (classNames.hasNext()) continue;
                if (mandatory) {
                    throw new RuntimeException(e);
                }
                return;
            }
        }
    }

    private BatchAccessChecker createNewChecker(AccessContext context) {
        return AbstractBatchAccessChecker.NOOP_ACCESS_CHECKER;
    }

    @Override
    public void close() throws Exception {
        this.jerseyTest.tearDown();
        this.weld.shutdown();
    }
}

