/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.gc.contents.inmem;

import com.google.common.base.Preconditions;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.NotNull;
import java.net.URI;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import org.projectnessie.gc.contents.ContentReference;
import org.projectnessie.gc.contents.ImmutableLiveContentSet;
import org.projectnessie.gc.contents.LiveContentSet;
import org.projectnessie.gc.contents.LiveContentSetNotFoundException;
import org.projectnessie.gc.contents.spi.PersistenceSpi;
import org.projectnessie.gc.files.FileReference;

public class InMemoryPersistenceSpi
implements PersistenceSpi {
    private final Map<UUID, InMemoryLiveContentSet> liveContentSets = new ConcurrentHashMap<UUID, InMemoryLiveContentSet>();

    @Override
    public long addIdentifiedLiveContent(@NotNull UUID liveSetId, @NotNull Stream<ContentReference> contentReference) {
        return contentReference.mapToLong(ref -> this.get((UUID)liveSetId).contents.computeIfAbsent(ref.contentId(), x -> Collections.synchronizedSet(new HashSet())).add(ref) ? 1L : 0L).sum();
    }

    @Override
    public void startIdentifyLiveContents(@NotNull UUID liveSetId, @NotNull Instant created) {
        Preconditions.checkState((this.liveContentSets.putIfAbsent(liveSetId, new InMemoryLiveContentSet(LiveContentSet.builder().persistenceSpi(this).id(liveSetId).created(created).status(LiveContentSet.Status.IDENTIFY_IN_PROGRESS).build())) == null ? 1 : 0) != 0, (Object)("Duplicate liveSetId " + liveSetId));
    }

    @Override
    public void finishedIdentifyLiveContents(@NotNull UUID liveSetId, @NotNull Instant finished, @Nullable Throwable failure) {
        this.get((UUID)liveSetId).liveContentSet.getAndUpdate(current -> {
            ImmutableLiveContentSet.Builder b = InMemoryPersistenceSpi.assertStatus(current, LiveContentSet.Status.IDENTIFY_IN_PROGRESS).unbuild().identifyCompleted(finished);
            if (failure != null) {
                b.status(LiveContentSet.Status.IDENTIFY_FAILED).errorMessage(failure.toString());
            } else {
                b.status(LiveContentSet.Status.IDENTIFY_SUCCESS);
            }
            return b.build();
        });
    }

    @Override
    public LiveContentSet startExpireContents(@NotNull UUID liveSetId, @NotNull Instant started) {
        return this.get((UUID)liveSetId).liveContentSet.getAndUpdate(current -> InMemoryPersistenceSpi.assertStatus(current, LiveContentSet.Status.IDENTIFY_SUCCESS).unbuild().expiryStarted(started).status(LiveContentSet.Status.EXPIRY_IN_PROGRESS).build());
    }

    @Override
    public LiveContentSet finishedExpireContents(@NotNull UUID liveSetId, @NotNull Instant finished, @Nullable Throwable failure) {
        return this.get((UUID)liveSetId).liveContentSet.getAndUpdate(current -> {
            ImmutableLiveContentSet.Builder b = InMemoryPersistenceSpi.assertStatus(current, LiveContentSet.Status.EXPIRY_IN_PROGRESS).unbuild().expiryCompleted(finished);
            if (failure != null) {
                b.status(LiveContentSet.Status.EXPIRY_FAILED).errorMessage(failure.toString());
            } else {
                b.status(LiveContentSet.Status.EXPIRY_SUCCESS);
            }
            return b.build();
        });
    }

    @Override
    public LiveContentSet getLiveContentSet(@NotNull UUID liveSetId) throws LiveContentSetNotFoundException {
        try {
            return this.get((UUID)liveSetId).liveContentSet.get();
        }
        catch (IllegalStateException e) {
            if (e.getCause() instanceof LiveContentSetNotFoundException) {
                throw (LiveContentSetNotFoundException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public long fetchDistinctContentIdCount(@NotNull UUID liveSetId) {
        return this.getOptional(liveSetId).map(lcs -> lcs.contents.size()).orElse(0L);
    }

    @Override
    public Stream<String> fetchContentIds(@NotNull UUID liveSetId) {
        return this.getOptional(liveSetId).map(lcs -> lcs.contents.keySet().stream()).orElse(Stream.empty());
    }

    @Override
    public Stream<ContentReference> fetchContentReferences(@NotNull UUID liveSetId, @NotNull String contentId) {
        return this.getOptional(liveSetId).map(lcs -> lcs.contents.getOrDefault(contentId, Collections.emptySet()).stream()).orElse(Stream.empty());
    }

    @Override
    public void associateBaseLocations(UUID liveSetId, String contentId, Collection<URI> baseLocations) {
        InMemoryPersistenceSpi.assertStatus((InMemoryLiveContentSet)this.get((UUID)liveSetId), (LiveContentSet.Status)LiveContentSet.Status.EXPIRY_IN_PROGRESS).baseLocations.computeIfAbsent(contentId, x -> new HashSet()).addAll(baseLocations);
    }

    @Override
    public Stream<URI> fetchBaseLocations(UUID liveSetId, String contentId) {
        return ((Collection)this.get((UUID)liveSetId).baseLocations.getOrDefault(contentId, Collections.emptySet())).stream();
    }

    @Override
    public Stream<URI> fetchAllBaseLocations(UUID liveSetId) {
        return this.liveContentSets.values().stream().flatMap(lcs -> lcs.baseLocations.values().stream()).flatMap(Collection::stream);
    }

    private InMemoryLiveContentSet get(UUID liveSetId) {
        InMemoryLiveContentSet lcs = this.liveContentSets.get(liveSetId);
        if (lcs == null) {
            throw new IllegalStateException(new LiveContentSetNotFoundException(liveSetId));
        }
        return lcs;
    }

    private Optional<InMemoryLiveContentSet> getOptional(UUID liveSetId) {
        return Optional.ofNullable(this.liveContentSets.get(liveSetId));
    }

    @Override
    public void deleteLiveContentSet(UUID liveSetId) {
        Preconditions.checkState((this.liveContentSets.remove(liveSetId) != null ? 1 : 0) != 0, (String)"Live content set not found %s", (Object)liveSetId);
    }

    @Override
    public Stream<LiveContentSet> getAllLiveContents() {
        return this.liveContentSets.values().stream().map(mock -> mock.liveContentSet.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long addFileDeletions(UUID liveSetId, Stream<FileReference> files) {
        InMemoryLiveContentSet lcs = InMemoryPersistenceSpi.assertStatus(this.get(liveSetId), LiveContentSet.Status.EXPIRY_IN_PROGRESS);
        Set<FileReference> set = lcs.fileDeletions;
        synchronized (set) {
            long count = 0L;
            Iterator iter = files.iterator();
            while (iter.hasNext()) {
                if (!lcs.fileDeletions.add((FileReference)iter.next())) continue;
                ++count;
            }
            return count;
        }
    }

    @Override
    public Stream<FileReference> fetchFileDeletions(UUID liveSetId) {
        InMemoryLiveContentSet lcs = InMemoryPersistenceSpi.assertStatus(this.get(liveSetId), LiveContentSet.Status.EXPIRY_SUCCESS);
        return lcs.fileDeletions.stream().sorted(Comparator.comparing(FileReference::base).thenComparing(FileReference::path));
    }

    private static InMemoryLiveContentSet assertStatus(InMemoryLiveContentSet current, LiveContentSet.Status valid) {
        InMemoryPersistenceSpi.assertStatus(current.liveContentSet.get(), valid);
        return current;
    }

    private static LiveContentSet assertStatus(LiveContentSet current, LiveContentSet.Status valid) {
        Preconditions.checkState((current.status() == valid ? 1 : 0) != 0, (Object)("Expected current status of " + (Object)((Object)valid) + ", but is " + (Object)((Object)current.status())));
        return current;
    }

    static final class InMemoryLiveContentSet {
        final Map<String, Set<ContentReference>> contents = new ConcurrentHashMap<String, Set<ContentReference>>();
        final Map<String, Collection<URI>> baseLocations = new ConcurrentHashMap<String, Collection<URI>>();
        final AtomicReference<LiveContentSet> liveContentSet;
        final Set<FileReference> fileDeletions = new HashSet<FileReference>();

        InMemoryLiveContentSet(LiveContentSet liveContentSet) {
            this.liveContentSet = new AtomicReference<LiveContentSet>(liveContentSet);
        }
    }
}

