/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.gc.contents.spi;

import com.google.errorprone.annotations.MustBeClosed;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.NotNull;
import java.net.URI;
import java.time.Instant;
import java.util.Collection;
import java.util.UUID;
import java.util.stream.Stream;
import org.projectnessie.gc.contents.ContentReference;
import org.projectnessie.gc.contents.LiveContentSet;
import org.projectnessie.gc.contents.LiveContentSetNotFoundException;
import org.projectnessie.gc.files.FileReference;

public interface PersistenceSpi {
    public void deleteLiveContentSet(UUID var1);

    @MustBeClosed
    public Stream<LiveContentSet> getAllLiveContents();

    public void startIdentifyLiveContents(@NotNull UUID var1, @NotNull Instant var2);

    public long addIdentifiedLiveContent(@NotNull UUID var1, @NotNull Stream<ContentReference> var2);

    public void finishedIdentifyLiveContents(@NotNull UUID var1, @NotNull Instant var2, @Nullable Throwable var3);

    public LiveContentSet startExpireContents(@NotNull UUID var1, @NotNull Instant var2);

    public LiveContentSet finishedExpireContents(@NotNull UUID var1, @NotNull Instant var2, @Nullable Throwable var3);

    public LiveContentSet getLiveContentSet(@NotNull UUID var1) throws LiveContentSetNotFoundException;

    public long fetchDistinctContentIdCount(@NotNull UUID var1);

    @MustBeClosed
    public Stream<String> fetchContentIds(@NotNull UUID var1);

    public Stream<ContentReference> fetchContentReferences(@NotNull UUID var1, @NotNull String var2);

    public void associateBaseLocations(@NotNull UUID var1, @NotNull String var2, @NotNull Collection<URI> var3);

    @MustBeClosed
    public Stream<URI> fetchBaseLocations(@NotNull UUID var1, @NotNull String var2);

    @MustBeClosed
    public Stream<URI> fetchAllBaseLocations(@NotNull UUID var1);

    public long addFileDeletions(@NotNull UUID var1, @NotNull Stream<FileReference> var2);

    @MustBeClosed
    public Stream<FileReference> fetchFileDeletions(@NotNull UUID var1);
}

