/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.gc.expire;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.gc.contents.LiveContentSet;
import org.projectnessie.gc.expire.ContentToFiles;
import org.projectnessie.gc.expire.ExpireParameters;
import org.projectnessie.gc.files.FileDeleter;
import org.projectnessie.gc.files.FilesLister;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ExpireParameters", generator="Immutables")
@Immutable
public final class ImmutableExpireParameters
implements ExpireParameters {
    private final long expectedFileCount;
    private final double falsePositiveProbability;
    private final double allowedFalsePositiveProbability;
    private final FilesLister filesLister;
    private final ContentToFiles contentToFiles;
    private final LiveContentSet liveContentSet;
    private final Instant maxFileModificationTime;
    private final FileDeleter fileDeleter;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableExpireParameters(Builder builder) {
        this.filesLister = builder.filesLister;
        this.contentToFiles = builder.contentToFiles;
        this.liveContentSet = builder.liveContentSet;
        this.maxFileModificationTime = builder.maxFileModificationTime;
        this.fileDeleter = builder.fileDeleter;
        if (builder.expectedFileCountIsSet()) {
            this.initShim.expectedFileCount(builder.expectedFileCount);
        }
        if (builder.falsePositiveProbabilityIsSet()) {
            this.initShim.falsePositiveProbability(builder.falsePositiveProbability);
        }
        if (builder.allowedFalsePositiveProbabilityIsSet()) {
            this.initShim.allowedFalsePositiveProbability(builder.allowedFalsePositiveProbability);
        }
        this.expectedFileCount = this.initShim.expectedFileCount();
        this.falsePositiveProbability = this.initShim.falsePositiveProbability();
        this.allowedFalsePositiveProbability = this.initShim.allowedFalsePositiveProbability();
        this.initShim = null;
    }

    private ImmutableExpireParameters(long expectedFileCount, double falsePositiveProbability, double allowedFalsePositiveProbability, FilesLister filesLister, ContentToFiles contentToFiles, LiveContentSet liveContentSet, Instant maxFileModificationTime, FileDeleter fileDeleter) {
        this.expectedFileCount = expectedFileCount;
        this.falsePositiveProbability = falsePositiveProbability;
        this.allowedFalsePositiveProbability = allowedFalsePositiveProbability;
        this.filesLister = filesLister;
        this.contentToFiles = contentToFiles;
        this.liveContentSet = liveContentSet;
        this.maxFileModificationTime = maxFileModificationTime;
        this.fileDeleter = fileDeleter;
        this.initShim = null;
    }

    private long expectedFileCountInitialize() {
        return ExpireParameters.super.expectedFileCount();
    }

    private double falsePositiveProbabilityInitialize() {
        return ExpireParameters.super.falsePositiveProbability();
    }

    private double allowedFalsePositiveProbabilityInitialize() {
        return ExpireParameters.super.allowedFalsePositiveProbability();
    }

    @Override
    public long expectedFileCount() {
        InitShim shim = this.initShim;
        return shim != null ? shim.expectedFileCount() : this.expectedFileCount;
    }

    @Override
    public double falsePositiveProbability() {
        InitShim shim = this.initShim;
        return shim != null ? shim.falsePositiveProbability() : this.falsePositiveProbability;
    }

    @Override
    public double allowedFalsePositiveProbability() {
        InitShim shim = this.initShim;
        return shim != null ? shim.allowedFalsePositiveProbability() : this.allowedFalsePositiveProbability;
    }

    @Override
    public FilesLister filesLister() {
        return this.filesLister;
    }

    @Override
    public ContentToFiles contentToFiles() {
        return this.contentToFiles;
    }

    @Override
    public LiveContentSet liveContentSet() {
        return this.liveContentSet;
    }

    @Override
    public Instant maxFileModificationTime() {
        return this.maxFileModificationTime;
    }

    @Override
    public FileDeleter fileDeleter() {
        return this.fileDeleter;
    }

    public final ImmutableExpireParameters withExpectedFileCount(long value) {
        if (this.expectedFileCount == value) {
            return this;
        }
        return new ImmutableExpireParameters(value, this.falsePositiveProbability, this.allowedFalsePositiveProbability, this.filesLister, this.contentToFiles, this.liveContentSet, this.maxFileModificationTime, this.fileDeleter);
    }

    public final ImmutableExpireParameters withFalsePositiveProbability(double value) {
        if (Double.doubleToLongBits(this.falsePositiveProbability) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableExpireParameters(this.expectedFileCount, value, this.allowedFalsePositiveProbability, this.filesLister, this.contentToFiles, this.liveContentSet, this.maxFileModificationTime, this.fileDeleter);
    }

    public final ImmutableExpireParameters withAllowedFalsePositiveProbability(double value) {
        if (Double.doubleToLongBits(this.allowedFalsePositiveProbability) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableExpireParameters(this.expectedFileCount, this.falsePositiveProbability, value, this.filesLister, this.contentToFiles, this.liveContentSet, this.maxFileModificationTime, this.fileDeleter);
    }

    public final ImmutableExpireParameters withFilesLister(FilesLister value) {
        if (this.filesLister == value) {
            return this;
        }
        FilesLister newValue = Objects.requireNonNull(value, "filesLister");
        return new ImmutableExpireParameters(this.expectedFileCount, this.falsePositiveProbability, this.allowedFalsePositiveProbability, newValue, this.contentToFiles, this.liveContentSet, this.maxFileModificationTime, this.fileDeleter);
    }

    public final ImmutableExpireParameters withContentToFiles(ContentToFiles value) {
        if (this.contentToFiles == value) {
            return this;
        }
        ContentToFiles newValue = Objects.requireNonNull(value, "contentToFiles");
        return new ImmutableExpireParameters(this.expectedFileCount, this.falsePositiveProbability, this.allowedFalsePositiveProbability, this.filesLister, newValue, this.liveContentSet, this.maxFileModificationTime, this.fileDeleter);
    }

    public final ImmutableExpireParameters withLiveContentSet(LiveContentSet value) {
        if (this.liveContentSet == value) {
            return this;
        }
        LiveContentSet newValue = Objects.requireNonNull(value, "liveContentSet");
        return new ImmutableExpireParameters(this.expectedFileCount, this.falsePositiveProbability, this.allowedFalsePositiveProbability, this.filesLister, this.contentToFiles, newValue, this.maxFileModificationTime, this.fileDeleter);
    }

    public final ImmutableExpireParameters withMaxFileModificationTime(Instant value) {
        if (this.maxFileModificationTime == value) {
            return this;
        }
        Instant newValue = Objects.requireNonNull(value, "maxFileModificationTime");
        return new ImmutableExpireParameters(this.expectedFileCount, this.falsePositiveProbability, this.allowedFalsePositiveProbability, this.filesLister, this.contentToFiles, this.liveContentSet, newValue, this.fileDeleter);
    }

    public final ImmutableExpireParameters withFileDeleter(FileDeleter value) {
        if (this.fileDeleter == value) {
            return this;
        }
        FileDeleter newValue = Objects.requireNonNull(value, "fileDeleter");
        return new ImmutableExpireParameters(this.expectedFileCount, this.falsePositiveProbability, this.allowedFalsePositiveProbability, this.filesLister, this.contentToFiles, this.liveContentSet, this.maxFileModificationTime, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableExpireParameters && this.equalTo(0, (ImmutableExpireParameters)another);
    }

    private boolean equalTo(int synthetic, ImmutableExpireParameters another) {
        return this.expectedFileCount == another.expectedFileCount && Double.doubleToLongBits(this.falsePositiveProbability) == Double.doubleToLongBits(another.falsePositiveProbability) && Double.doubleToLongBits(this.allowedFalsePositiveProbability) == Double.doubleToLongBits(another.allowedFalsePositiveProbability) && this.filesLister.equals(another.filesLister) && this.contentToFiles.equals(another.contentToFiles) && this.liveContentSet.equals(another.liveContentSet) && this.maxFileModificationTime.equals(another.maxFileModificationTime) && this.fileDeleter.equals(another.fileDeleter);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Longs.hashCode((long)this.expectedFileCount);
        h += (h << 5) + Doubles.hashCode((double)this.falsePositiveProbability);
        h += (h << 5) + Doubles.hashCode((double)this.allowedFalsePositiveProbability);
        h += (h << 5) + this.filesLister.hashCode();
        h += (h << 5) + this.contentToFiles.hashCode();
        h += (h << 5) + this.liveContentSet.hashCode();
        h += (h << 5) + this.maxFileModificationTime.hashCode();
        h += (h << 5) + this.fileDeleter.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ExpireParameters").omitNullValues().add("expectedFileCount", this.expectedFileCount).add("falsePositiveProbability", this.falsePositiveProbability).add("allowedFalsePositiveProbability", this.allowedFalsePositiveProbability).add("filesLister", (Object)this.filesLister).add("contentToFiles", (Object)this.contentToFiles).add("liveContentSet", (Object)this.liveContentSet).add("maxFileModificationTime", (Object)this.maxFileModificationTime).add("fileDeleter", (Object)this.fileDeleter).toString();
    }

    public static ImmutableExpireParameters copyOf(ExpireParameters instance) {
        if (instance instanceof ImmutableExpireParameters) {
            return (ImmutableExpireParameters)instance;
        }
        return ImmutableExpireParameters.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ExpireParameters", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    implements ExpireParameters.Builder {
        private static final long INIT_BIT_FILES_LISTER = 1L;
        private static final long INIT_BIT_CONTENT_TO_FILES = 2L;
        private static final long INIT_BIT_LIVE_CONTENT_SET = 4L;
        private static final long INIT_BIT_MAX_FILE_MODIFICATION_TIME = 8L;
        private static final long INIT_BIT_FILE_DELETER = 16L;
        private static final long OPT_BIT_EXPECTED_FILE_COUNT = 1L;
        private static final long OPT_BIT_FALSE_POSITIVE_PROBABILITY = 2L;
        private static final long OPT_BIT_ALLOWED_FALSE_POSITIVE_PROBABILITY = 4L;
        private long initBits = 31L;
        private long optBits;
        private long expectedFileCount;
        private double falsePositiveProbability;
        private double allowedFalsePositiveProbability;
        @Nullable
        private FilesLister filesLister;
        @Nullable
        private ContentToFiles contentToFiles;
        @Nullable
        private LiveContentSet liveContentSet;
        @Nullable
        private Instant maxFileModificationTime;
        @Nullable
        private FileDeleter fileDeleter;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ExpireParameters instance) {
            Objects.requireNonNull(instance, "instance");
            this.expectedFileCount(instance.expectedFileCount());
            this.falsePositiveProbability(instance.falsePositiveProbability());
            this.allowedFalsePositiveProbability(instance.allowedFalsePositiveProbability());
            this.filesLister(instance.filesLister());
            this.contentToFiles(instance.contentToFiles());
            this.liveContentSet(instance.liveContentSet());
            this.maxFileModificationTime(instance.maxFileModificationTime());
            this.fileDeleter(instance.fileDeleter());
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder expectedFileCount(long expectedFileCount) {
            this.expectedFileCount = expectedFileCount;
            this.optBits |= 1L;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder falsePositiveProbability(double falsePositiveProbability) {
            this.falsePositiveProbability = falsePositiveProbability;
            this.optBits |= 2L;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder allowedFalsePositiveProbability(double allowedFalsePositiveProbability) {
            this.allowedFalsePositiveProbability = allowedFalsePositiveProbability;
            this.optBits |= 4L;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder filesLister(FilesLister filesLister) {
            this.filesLister = Objects.requireNonNull(filesLister, "filesLister");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder contentToFiles(ContentToFiles contentToFiles) {
            this.contentToFiles = Objects.requireNonNull(contentToFiles, "contentToFiles");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder liveContentSet(LiveContentSet liveContentSet) {
            this.liveContentSet = Objects.requireNonNull(liveContentSet, "liveContentSet");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder maxFileModificationTime(Instant maxFileModificationTime) {
            this.maxFileModificationTime = Objects.requireNonNull(maxFileModificationTime, "maxFileModificationTime");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder fileDeleter(FileDeleter fileDeleter) {
            this.fileDeleter = Objects.requireNonNull(fileDeleter, "fileDeleter");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @Override
        public ImmutableExpireParameters build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableExpireParameters(this);
        }

        private boolean expectedFileCountIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean falsePositiveProbabilityIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean allowedFalsePositiveProbabilityIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("filesLister");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("contentToFiles");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("liveContentSet");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("maxFileModificationTime");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("fileDeleter");
            }
            return "Cannot build ExpireParameters, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="ExpireParameters", generator="Immutables")
    private final class InitShim {
        private byte expectedFileCountBuildStage = 0;
        private long expectedFileCount;
        private byte falsePositiveProbabilityBuildStage = 0;
        private double falsePositiveProbability;
        private byte allowedFalsePositiveProbabilityBuildStage = 0;
        private double allowedFalsePositiveProbability;

        private InitShim() {
        }

        long expectedFileCount() {
            if (this.expectedFileCountBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.expectedFileCountBuildStage == 0) {
                this.expectedFileCountBuildStage = (byte)-1;
                this.expectedFileCount = ImmutableExpireParameters.this.expectedFileCountInitialize();
                this.expectedFileCountBuildStage = 1;
            }
            return this.expectedFileCount;
        }

        void expectedFileCount(long expectedFileCount) {
            this.expectedFileCount = expectedFileCount;
            this.expectedFileCountBuildStage = 1;
        }

        double falsePositiveProbability() {
            if (this.falsePositiveProbabilityBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.falsePositiveProbabilityBuildStage == 0) {
                this.falsePositiveProbabilityBuildStage = (byte)-1;
                this.falsePositiveProbability = ImmutableExpireParameters.this.falsePositiveProbabilityInitialize();
                this.falsePositiveProbabilityBuildStage = 1;
            }
            return this.falsePositiveProbability;
        }

        void falsePositiveProbability(double falsePositiveProbability) {
            this.falsePositiveProbability = falsePositiveProbability;
            this.falsePositiveProbabilityBuildStage = 1;
        }

        double allowedFalsePositiveProbability() {
            if (this.allowedFalsePositiveProbabilityBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.allowedFalsePositiveProbabilityBuildStage == 0) {
                this.allowedFalsePositiveProbabilityBuildStage = (byte)-1;
                this.allowedFalsePositiveProbability = ImmutableExpireParameters.this.allowedFalsePositiveProbabilityInitialize();
                this.allowedFalsePositiveProbabilityBuildStage = 1;
            }
            return this.allowedFalsePositiveProbability;
        }

        void allowedFalsePositiveProbability(double allowedFalsePositiveProbability) {
            this.allowedFalsePositiveProbability = allowedFalsePositiveProbability;
            this.allowedFalsePositiveProbabilityBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.expectedFileCountBuildStage == -1) {
                attributes.add("expectedFileCount");
            }
            if (this.falsePositiveProbabilityBuildStage == -1) {
                attributes.add("falsePositiveProbability");
            }
            if (this.allowedFalsePositiveProbabilityBuildStage == -1) {
                attributes.add("allowedFalsePositiveProbability");
            }
            return "Cannot build ExpireParameters, attribute initializers form cycle " + attributes;
        }
    }
}

