/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.gc.files;

import java.net.URI;
import org.immutables.value.Value;
import org.projectnessie.gc.files.ImmutableFileReference;

@Value.Immutable
public interface FileReference {
    @Value.Parameter(order=1)
    public URI path();

    @Value.Parameter(order=2)
    public URI base();

    @Value.Parameter(order=3)
    @Value.Auxiliary
    public long modificationTimeMillisEpoch();

    @Value.NonAttribute
    default public URI absolutePath() {
        return this.base().resolve(this.path());
    }

    public static ImmutableFileReference.Builder builder() {
        return ImmutableFileReference.builder();
    }

    public static FileReference of(URI path, URI base, long modificationTimeMillisEpoch) {
        return ImmutableFileReference.of(path, base, modificationTimeMillisEpoch);
    }
}

