/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.gc.files;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.net.URI;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.gc.files.FileReference;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="FileReference", generator="Immutables")
@Immutable
public final class ImmutableFileReference
implements FileReference {
    private final URI path;
    private final URI base;
    private final long modificationTimeMillisEpoch;

    private ImmutableFileReference(URI path, URI base, long modificationTimeMillisEpoch) {
        this.path = Objects.requireNonNull(path, "path");
        this.base = Objects.requireNonNull(base, "base");
        this.modificationTimeMillisEpoch = modificationTimeMillisEpoch;
    }

    private ImmutableFileReference(ImmutableFileReference original, URI path, URI base, long modificationTimeMillisEpoch) {
        this.path = path;
        this.base = base;
        this.modificationTimeMillisEpoch = modificationTimeMillisEpoch;
    }

    @Override
    public URI path() {
        return this.path;
    }

    @Override
    public URI base() {
        return this.base;
    }

    @Override
    public long modificationTimeMillisEpoch() {
        return this.modificationTimeMillisEpoch;
    }

    public final ImmutableFileReference withPath(URI value) {
        if (this.path == value) {
            return this;
        }
        URI newValue = Objects.requireNonNull(value, "path");
        return new ImmutableFileReference(this, newValue, this.base, this.modificationTimeMillisEpoch);
    }

    public final ImmutableFileReference withBase(URI value) {
        if (this.base == value) {
            return this;
        }
        URI newValue = Objects.requireNonNull(value, "base");
        return new ImmutableFileReference(this, this.path, newValue, this.modificationTimeMillisEpoch);
    }

    public final ImmutableFileReference withModificationTimeMillisEpoch(long value) {
        if (this.modificationTimeMillisEpoch == value) {
            return this;
        }
        return new ImmutableFileReference(this, this.path, this.base, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFileReference && this.equalTo(0, (ImmutableFileReference)another);
    }

    private boolean equalTo(int synthetic, ImmutableFileReference another) {
        return this.path.equals(another.path) && this.base.equals(another.base);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.path.hashCode();
        h += (h << 5) + this.base.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"FileReference").omitNullValues().add("path", (Object)this.path).add("base", (Object)this.base).toString();
    }

    public static ImmutableFileReference of(URI path, URI base, long modificationTimeMillisEpoch) {
        return new ImmutableFileReference(path, base, modificationTimeMillisEpoch);
    }

    public static ImmutableFileReference copyOf(FileReference instance) {
        if (instance instanceof ImmutableFileReference) {
            return (ImmutableFileReference)instance;
        }
        return ImmutableFileReference.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="FileReference", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_PATH = 1L;
        private static final long INIT_BIT_BASE = 2L;
        private static final long INIT_BIT_MODIFICATION_TIME_MILLIS_EPOCH = 4L;
        private long initBits = 7L;
        @Nullable
        private URI path;
        @Nullable
        private URI base;
        private long modificationTimeMillisEpoch;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(FileReference instance) {
            Objects.requireNonNull(instance, "instance");
            this.path(instance.path());
            this.base(instance.base());
            this.modificationTimeMillisEpoch(instance.modificationTimeMillisEpoch());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder path(URI path) {
            this.path = Objects.requireNonNull(path, "path");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder base(URI base) {
            this.base = Objects.requireNonNull(base, "base");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder modificationTimeMillisEpoch(long modificationTimeMillisEpoch) {
            this.modificationTimeMillisEpoch = modificationTimeMillisEpoch;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableFileReference build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableFileReference(null, this.path, this.base, this.modificationTimeMillisEpoch);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("path");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("base");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("modificationTimeMillisEpoch");
            }
            return "Cannot build FileReference, some of required attributes are not set " + attributes;
        }
    }
}

