/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.gc.files.local;

import com.google.errorprone.annotations.MustBeClosed;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.AbstractMap;
import java.util.stream.Stream;
import org.projectnessie.gc.files.DeleteResult;
import org.projectnessie.gc.files.FileDeleter;
import org.projectnessie.gc.files.FileReference;
import org.projectnessie.gc.files.FilesLister;
import org.projectnessie.gc.files.NessieFileIOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalFiles
implements FilesLister,
FileDeleter {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalFiles.class);

    @Override
    @MustBeClosed
    public Stream<FileReference> listRecursively(URI path) throws NessieFileIOException {
        URI basePath = LocalFiles.ensureTrailingSlash(path);
        try {
            Path start = Paths.get(basePath);
            return Files.walk(start, new FileVisitOption[0]).filter(p -> !p.equals(start)).map(p -> {
                try {
                    return new AbstractMap.SimpleEntry<URI, BasicFileAttributes>(p.toUri(), Files.getFileAttributeView(p, BasicFileAttributeView.class, new LinkOption[0]).readAttributes());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }).filter(e -> ((BasicFileAttributes)e.getValue()).isRegularFile()).map(e -> FileReference.of(basePath.relativize((URI)e.getKey()), basePath, ((BasicFileAttributes)e.getValue()).lastModifiedTime().toMillis()));
        }
        catch (IOException e2) {
            throw new NessieFileIOException(e2);
        }
    }

    @Override
    public DeleteResult delete(FileReference fileReference) {
        try {
            Files.delete(Paths.get(fileReference.absolutePath()));
            return DeleteResult.SUCCESS;
        }
        catch (NoSuchFileException e) {
            return DeleteResult.SUCCESS;
        }
        catch (IOException e) {
            LOGGER.debug("Failed to delete {}", (Object)fileReference, (Object)e);
            return DeleteResult.FAILURE;
        }
    }

    static URI ensureTrailingSlash(URI uri) {
        if (uri.getPath().endsWith("/")) {
            return uri;
        }
        return URI.create(uri + "/");
    }
}

