/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.gc.identify;

import jakarta.annotation.Nonnull;
import java.time.DateTimeException;
import java.time.Duration;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.Locale;
import org.projectnessie.gc.identify.NoneCutoffPolicy;
import org.projectnessie.gc.identify.NumCommitsCutoffPolicy;
import org.projectnessie.gc.identify.TimestampCutoffPolicy;

@FunctionalInterface
public interface CutoffPolicy {
    public static final Instant NO_TIMESTAMP = Instant.MAX;
    public static final CutoffPolicy NONE = new NoneCutoffPolicy();

    default public Instant timestamp() {
        return NO_TIMESTAMP;
    }

    public boolean isCutoff(@Nonnull Instant var1, int var2);

    public static CutoffPolicy atTimestamp(@Nonnull Instant cutoffTimestamp) {
        return new TimestampCutoffPolicy(cutoffTimestamp);
    }

    public static CutoffPolicy numCommits(int commits) {
        return new NumCommitsCutoffPolicy(commits);
    }

    public static CutoffPolicy parseStringToCutoffPolicy(String value, ZonedDateTime cutoffPolicyRefTime) throws Exception {
        if ("NONE".equals(value = value.toUpperCase(Locale.ROOT))) {
            return NONE;
        }
        try {
            return CutoffPolicy.numCommits(Integer.parseInt(value));
        }
        catch (NumberFormatException f) {
            NumberFormatException ex = f;
            try {
                return CutoffPolicy.atTimestamp(cutoffPolicyRefTime.minus(Duration.parse(value)).toInstant());
            }
            catch (DateTimeException f2) {
                ex.addSuppressed(f2);
                try {
                    return CutoffPolicy.atTimestamp(ZonedDateTime.parse(value).toInstant());
                }
                catch (DateTimeException f3) {
                    ex.addSuppressed(f3);
                    throw ex;
                }
            }
        }
    }
}

