/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.gc.identify;

import jakarta.annotation.Nonnull;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.agrona.collections.ObjectHashSet;
import org.projectnessie.gc.identify.CutoffPolicy;
import org.projectnessie.gc.identify.VisitedDeduplicator;

public final class DefaultVisitedDeduplicator
implements VisitedDeduplicator {
    private final Map<Instant, Set<String>> alreadyVisited = new HashMap<Instant, Set<String>>();

    @Override
    public synchronized boolean alreadyVisited(@Nonnull Instant cutoffTimestamp, @Nonnull String commitId) {
        if (cutoffTimestamp.equals(CutoffPolicy.NO_TIMESTAMP)) {
            return false;
        }
        for (Map.Entry<Instant, Set<String>> instantSetEntry : this.alreadyVisited.entrySet()) {
            if (instantSetEntry.getKey().isAfter(cutoffTimestamp) || !instantSetEntry.getValue().contains(commitId)) continue;
            return true;
        }
        Set commits = this.alreadyVisited.computeIfAbsent(cutoffTimestamp, x -> new ObjectHashSet());
        return !commits.add(commitId);
    }
}

