/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.gc.contents;

import jakarta.annotation.Nullable;
import jakarta.validation.constraints.NotNull;
import org.immutables.value.Value;
import org.projectnessie.gc.contents.ImmutableContentReference;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.IcebergContent;

@Value.Immutable
public interface ContentReference {
    @Value.Parameter(order=1)
    public String contentId();

    @Value.Auxiliary
    @Value.Parameter(order=2)
    public String commitId();

    @Value.Auxiliary
    @Value.Parameter(order=3)
    public ContentKey contentKey();

    @Value.Parameter(order=4)
    public Content.Type contentType();

    @Nullable
    @Value.Parameter(order=5)
    public String metadataLocation();

    @Nullable
    @Value.Parameter(order=6)
    public Long snapshotId();

    public static ContentReference icebergContent(@NotNull Content.Type contentType, @NotNull String contentId, @NotNull String commitId, @NotNull ContentKey contentKey, @NotNull String metadataLocation, long versionId) {
        if (contentType.equals((Object)Content.Type.ICEBERG_VIEW) || contentType.equals((Object)Content.Type.ICEBERG_TABLE)) {
            return ImmutableContentReference.of(contentId, commitId, contentKey, contentType, metadataLocation, versionId);
        }
        throw new IllegalArgumentException("Unexpected content type " + contentType);
    }

    public static ContentReference icebergContent(@NotNull String commitId, @NotNull ContentKey contentKey, @NotNull Content content) {
        Content.Type contentType = content.getType();
        if (contentType.equals((Object)Content.Type.ICEBERG_VIEW) || contentType.equals((Object)Content.Type.ICEBERG_TABLE)) {
            IcebergContent icebergContent = (IcebergContent)content;
            return ContentReference.icebergContent(contentType, content.getId(), commitId, contentKey, icebergContent.getMetadataLocation(), icebergContent.getVersionId());
        }
        throw new IllegalArgumentException("Unexpected content type " + contentType);
    }
}

