/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.gc.contents;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.gc.contents.LiveContentSet;
import org.projectnessie.gc.contents.spi.PersistenceSpi;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="LiveContentSet", generator="Immutables")
@Immutable
public final class ImmutableLiveContentSet
extends LiveContentSet {
    private final PersistenceSpi persistenceSpi;
    private final UUID id;
    private final Instant created;
    @jakarta.annotation.Nullable
    private final Instant identifyCompleted;
    @jakarta.annotation.Nullable
    private final Instant expiryStarted;
    @jakarta.annotation.Nullable
    private final Instant expiryCompleted;
    private final LiveContentSet.Status status;
    @jakarta.annotation.Nullable
    private final String errorMessage;

    private ImmutableLiveContentSet(PersistenceSpi persistenceSpi, UUID id, Instant created, @jakarta.annotation.Nullable Instant identifyCompleted, @jakarta.annotation.Nullable Instant expiryStarted, @jakarta.annotation.Nullable Instant expiryCompleted, LiveContentSet.Status status, @jakarta.annotation.Nullable String errorMessage) {
        this.persistenceSpi = persistenceSpi;
        this.id = id;
        this.created = created;
        this.identifyCompleted = identifyCompleted;
        this.expiryStarted = expiryStarted;
        this.expiryCompleted = expiryCompleted;
        this.status = status;
        this.errorMessage = errorMessage;
    }

    @Override
    PersistenceSpi persistenceSpi() {
        return this.persistenceSpi;
    }

    @Override
    public UUID id() {
        return this.id;
    }

    @Override
    public Instant created() {
        return this.created;
    }

    @Override
    @jakarta.annotation.Nullable
    public Instant identifyCompleted() {
        return this.identifyCompleted;
    }

    @Override
    @jakarta.annotation.Nullable
    public Instant expiryStarted() {
        return this.expiryStarted;
    }

    @Override
    @jakarta.annotation.Nullable
    public Instant expiryCompleted() {
        return this.expiryCompleted;
    }

    @Override
    public LiveContentSet.Status status() {
        return this.status;
    }

    @Override
    @jakarta.annotation.Nullable
    public String errorMessage() {
        return this.errorMessage;
    }

    public final ImmutableLiveContentSet withPersistenceSpi(PersistenceSpi value) {
        if (this.persistenceSpi == value) {
            return this;
        }
        PersistenceSpi newValue = Objects.requireNonNull(value, "persistenceSpi");
        return new ImmutableLiveContentSet(newValue, this.id, this.created, this.identifyCompleted, this.expiryStarted, this.expiryCompleted, this.status, this.errorMessage);
    }

    public final ImmutableLiveContentSet withId(UUID value) {
        if (this.id == value) {
            return this;
        }
        UUID newValue = Objects.requireNonNull(value, "id");
        return new ImmutableLiveContentSet(this.persistenceSpi, newValue, this.created, this.identifyCompleted, this.expiryStarted, this.expiryCompleted, this.status, this.errorMessage);
    }

    public final ImmutableLiveContentSet withCreated(Instant value) {
        if (this.created == value) {
            return this;
        }
        Instant newValue = Objects.requireNonNull(value, "created");
        return new ImmutableLiveContentSet(this.persistenceSpi, this.id, newValue, this.identifyCompleted, this.expiryStarted, this.expiryCompleted, this.status, this.errorMessage);
    }

    public final ImmutableLiveContentSet withIdentifyCompleted(@jakarta.annotation.Nullable Instant value) {
        if (this.identifyCompleted == value) {
            return this;
        }
        return new ImmutableLiveContentSet(this.persistenceSpi, this.id, this.created, value, this.expiryStarted, this.expiryCompleted, this.status, this.errorMessage);
    }

    public final ImmutableLiveContentSet withExpiryStarted(@jakarta.annotation.Nullable Instant value) {
        if (this.expiryStarted == value) {
            return this;
        }
        return new ImmutableLiveContentSet(this.persistenceSpi, this.id, this.created, this.identifyCompleted, value, this.expiryCompleted, this.status, this.errorMessage);
    }

    public final ImmutableLiveContentSet withExpiryCompleted(@jakarta.annotation.Nullable Instant value) {
        if (this.expiryCompleted == value) {
            return this;
        }
        return new ImmutableLiveContentSet(this.persistenceSpi, this.id, this.created, this.identifyCompleted, this.expiryStarted, value, this.status, this.errorMessage);
    }

    public final ImmutableLiveContentSet withStatus(LiveContentSet.Status value) {
        LiveContentSet.Status newValue = Objects.requireNonNull(value, "status");
        if (this.status == newValue) {
            return this;
        }
        return new ImmutableLiveContentSet(this.persistenceSpi, this.id, this.created, this.identifyCompleted, this.expiryStarted, this.expiryCompleted, newValue, this.errorMessage);
    }

    public final ImmutableLiveContentSet withErrorMessage(@jakarta.annotation.Nullable String value) {
        if (Objects.equals(this.errorMessage, value)) {
            return this;
        }
        return new ImmutableLiveContentSet(this.persistenceSpi, this.id, this.created, this.identifyCompleted, this.expiryStarted, this.expiryCompleted, this.status, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLiveContentSet && this.equalTo(0, (ImmutableLiveContentSet)another);
    }

    private boolean equalTo(int synthetic, ImmutableLiveContentSet another) {
        return this.persistenceSpi.equals(another.persistenceSpi) && this.id.equals(another.id) && this.created.equals(another.created) && Objects.equals(this.identifyCompleted, another.identifyCompleted) && Objects.equals(this.expiryStarted, another.expiryStarted) && Objects.equals(this.expiryCompleted, another.expiryCompleted) && this.status.equals((Object)another.status) && Objects.equals(this.errorMessage, another.errorMessage);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.persistenceSpi.hashCode();
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.created.hashCode();
        h += (h << 5) + Objects.hashCode(this.identifyCompleted);
        h += (h << 5) + Objects.hashCode(this.expiryStarted);
        h += (h << 5) + Objects.hashCode(this.expiryCompleted);
        h += (h << 5) + this.status.hashCode();
        h += (h << 5) + Objects.hashCode(this.errorMessage);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"LiveContentSet").omitNullValues().add("persistenceSpi", (Object)this.persistenceSpi).add("id", (Object)this.id).add("created", (Object)this.created).add("identifyCompleted", (Object)this.identifyCompleted).add("expiryStarted", (Object)this.expiryStarted).add("expiryCompleted", (Object)this.expiryCompleted).add("status", (Object)this.status).add("errorMessage", (Object)this.errorMessage).toString();
    }

    public static ImmutableLiveContentSet copyOf(LiveContentSet instance) {
        if (instance instanceof ImmutableLiveContentSet) {
            return (ImmutableLiveContentSet)instance;
        }
        return ImmutableLiveContentSet.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="LiveContentSet", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_PERSISTENCE_SPI = 1L;
        private static final long INIT_BIT_ID = 2L;
        private static final long INIT_BIT_CREATED = 4L;
        private static final long INIT_BIT_STATUS = 8L;
        private long initBits = 15L;
        @Nullable
        private PersistenceSpi persistenceSpi;
        @Nullable
        private UUID id;
        @Nullable
        private Instant created;
        @Nullable
        private Instant identifyCompleted;
        @Nullable
        private Instant expiryStarted;
        @Nullable
        private Instant expiryCompleted;
        @Nullable
        private LiveContentSet.Status status;
        @Nullable
        private String errorMessage;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(LiveContentSet instance) {
            Instant expiryCompletedValue;
            Instant expiryStartedValue;
            Objects.requireNonNull(instance, "instance");
            this.persistenceSpi(instance.persistenceSpi());
            this.id(instance.id());
            this.created(instance.created());
            Instant identifyCompletedValue = instance.identifyCompleted();
            if (identifyCompletedValue != null) {
                this.identifyCompleted(identifyCompletedValue);
            }
            if ((expiryStartedValue = instance.expiryStarted()) != null) {
                this.expiryStarted(expiryStartedValue);
            }
            if ((expiryCompletedValue = instance.expiryCompleted()) != null) {
                this.expiryCompleted(expiryCompletedValue);
            }
            this.status(instance.status());
            String errorMessageValue = instance.errorMessage();
            if (errorMessageValue != null) {
                this.errorMessage(errorMessageValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder persistenceSpi(PersistenceSpi persistenceSpi) {
            this.persistenceSpi = Objects.requireNonNull(persistenceSpi, "persistenceSpi");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder id(UUID id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder created(Instant created) {
            this.created = Objects.requireNonNull(created, "created");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder identifyCompleted(@jakarta.annotation.Nullable Instant identifyCompleted) {
            this.identifyCompleted = identifyCompleted;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder expiryStarted(@jakarta.annotation.Nullable Instant expiryStarted) {
            this.expiryStarted = expiryStarted;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder expiryCompleted(@jakarta.annotation.Nullable Instant expiryCompleted) {
            this.expiryCompleted = expiryCompleted;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder status(LiveContentSet.Status status) {
            this.status = Objects.requireNonNull(status, "status");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder errorMessage(@jakarta.annotation.Nullable String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public ImmutableLiveContentSet build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableLiveContentSet(this.persistenceSpi, this.id, this.created, this.identifyCompleted, this.expiryStarted, this.expiryCompleted, this.status, this.errorMessage);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("persistenceSpi");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("created");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("status");
            }
            return "Cannot build LiveContentSet, some of required attributes are not set " + attributes;
        }
    }
}

