/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.gc.expire.local;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.gc.expire.ExpireParameters;
import org.projectnessie.gc.expire.local.DefaultLocalExpire;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="DefaultLocalExpire", generator="Immutables")
@Immutable
public final class ImmutableDefaultLocalExpire
extends DefaultLocalExpire {
    private final ExpireParameters expireParameters;
    private final int parallelism;
    private final Clock clock;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableDefaultLocalExpire(Builder builder) {
        this.expireParameters = builder.expireParameters;
        if (builder.parallelismIsSet()) {
            this.initShim.parallelism(builder.parallelism);
        }
        if (builder.clock != null) {
            this.initShim.clock(builder.clock);
        }
        this.parallelism = this.initShim.parallelism();
        this.clock = this.initShim.clock();
        this.initShim = null;
    }

    private ImmutableDefaultLocalExpire(ExpireParameters expireParameters, int parallelism, Clock clock) {
        this.expireParameters = expireParameters;
        this.parallelism = parallelism;
        this.clock = clock;
        this.initShim = null;
    }

    @Override
    ExpireParameters expireParameters() {
        return this.expireParameters;
    }

    @Override
    int parallelism() {
        InitShim shim = this.initShim;
        return shim != null ? shim.parallelism() : this.parallelism;
    }

    @Override
    Clock clock() {
        InitShim shim = this.initShim;
        return shim != null ? shim.clock() : this.clock;
    }

    public final ImmutableDefaultLocalExpire withExpireParameters(ExpireParameters value) {
        if (this.expireParameters == value) {
            return this;
        }
        ExpireParameters newValue = Objects.requireNonNull(value, "expireParameters");
        return ImmutableDefaultLocalExpire.validate(new ImmutableDefaultLocalExpire(newValue, this.parallelism, this.clock));
    }

    public final ImmutableDefaultLocalExpire withParallelism(int value) {
        if (this.parallelism == value) {
            return this;
        }
        return ImmutableDefaultLocalExpire.validate(new ImmutableDefaultLocalExpire(this.expireParameters, value, this.clock));
    }

    public final ImmutableDefaultLocalExpire withClock(Clock value) {
        if (this.clock == value) {
            return this;
        }
        Clock newValue = Objects.requireNonNull(value, "clock");
        return ImmutableDefaultLocalExpire.validate(new ImmutableDefaultLocalExpire(this.expireParameters, this.parallelism, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDefaultLocalExpire && this.equalTo(0, (ImmutableDefaultLocalExpire)another);
    }

    private boolean equalTo(int synthetic, ImmutableDefaultLocalExpire another) {
        return this.expireParameters.equals(another.expireParameters) && this.parallelism == another.parallelism && this.clock.equals(another.clock);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.expireParameters.hashCode();
        h += (h << 5) + this.parallelism;
        h += (h << 5) + this.clock.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"DefaultLocalExpire").omitNullValues().add("expireParameters", (Object)this.expireParameters).add("parallelism", this.parallelism).add("clock", (Object)this.clock).toString();
    }

    private static ImmutableDefaultLocalExpire validate(ImmutableDefaultLocalExpire instance) {
        instance.verify();
        return instance;
    }

    public static ImmutableDefaultLocalExpire copyOf(DefaultLocalExpire instance) {
        if (instance instanceof ImmutableDefaultLocalExpire) {
            return (ImmutableDefaultLocalExpire)instance;
        }
        return ImmutableDefaultLocalExpire.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DefaultLocalExpire", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    implements DefaultLocalExpire.Builder {
        private static final long INIT_BIT_EXPIRE_PARAMETERS = 1L;
        private static final long OPT_BIT_PARALLELISM = 1L;
        private long initBits = 1L;
        private long optBits;
        @Nullable
        private ExpireParameters expireParameters;
        private int parallelism;
        @Nullable
        private Clock clock;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(DefaultLocalExpire instance) {
            Objects.requireNonNull(instance, "instance");
            this.expireParameters(instance.expireParameters());
            this.parallelism(instance.parallelism());
            this.clock(instance.clock());
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder expireParameters(ExpireParameters expireParameters) {
            this.expireParameters = Objects.requireNonNull(expireParameters, "expireParameters");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder parallelism(int parallelism) {
            this.parallelism = parallelism;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder clock(Clock clock) {
            this.clock = Objects.requireNonNull(clock, "clock");
            return this;
        }

        @Override
        public ImmutableDefaultLocalExpire build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableDefaultLocalExpire.validate(new ImmutableDefaultLocalExpire(this));
        }

        private boolean parallelismIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("expireParameters");
            }
            return "Cannot build DefaultLocalExpire, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="DefaultLocalExpire", generator="Immutables")
    private final class InitShim {
        private byte parallelismBuildStage = 0;
        private int parallelism;
        private byte clockBuildStage = 0;
        private Clock clock;

        private InitShim() {
        }

        int parallelism() {
            if (this.parallelismBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.parallelismBuildStage == 0) {
                this.parallelismBuildStage = (byte)-1;
                this.parallelism = ImmutableDefaultLocalExpire.super.parallelism();
                this.parallelismBuildStage = 1;
            }
            return this.parallelism;
        }

        void parallelism(int parallelism) {
            this.parallelism = parallelism;
            this.parallelismBuildStage = 1;
        }

        Clock clock() {
            if (this.clockBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.clockBuildStage == 0) {
                this.clockBuildStage = (byte)-1;
                this.clock = Objects.requireNonNull(ImmutableDefaultLocalExpire.super.clock(), "clock");
                this.clockBuildStage = 1;
            }
            return this.clock;
        }

        void clock(Clock clock) {
            this.clock = clock;
            this.clockBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.parallelismBuildStage == -1) {
                attributes.add("parallelism");
            }
            if (this.clockBuildStage == -1) {
                attributes.add("clock");
            }
            return "Cannot build DefaultLocalExpire, attribute initializers form cycle " + attributes;
        }
    }
}

