/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.gc.files;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Value;
import org.projectnessie.gc.files.DeleteResult;
import org.projectnessie.gc.files.ImmutableDeleteSummary;

@Value.Immutable
public interface DeleteSummary {
    public static final DeleteSummary EMPTY = DeleteSummary.of(0L, 0L);

    public static DeleteSummary of(long deleted, long failures) {
        return ImmutableDeleteSummary.of(deleted, failures);
    }

    @CanIgnoreReturnValue
    default public DeleteSummary add(DeleteResult deleteResult) {
        switch (deleteResult) {
            case SUCCESS: {
                return DeleteSummary.of(this.deleted() + 1L, this.failures());
            }
            case FAILURE: {
                return DeleteSummary.of(this.deleted(), this.failures() + 1L);
            }
        }
        throw new IllegalArgumentException("" + (Object)((Object)deleteResult));
    }

    @CanIgnoreReturnValue
    default public DeleteSummary add(DeleteSummary b) {
        return DeleteSummary.of(this.deleted() + b.deleted(), this.failures() + b.failures());
    }

    @Value.Parameter(order=1)
    public long deleted();

    @Value.Parameter(order=2)
    public long failures();
}

