/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.gc.files;

import com.google.common.base.Preconditions;
import org.immutables.value.Value;
import org.projectnessie.gc.files.ImmutableFileReference;
import org.projectnessie.storage.uri.StorageUri;

@Value.Immutable
public interface FileReference {
    @Value.Parameter(order=1)
    public StorageUri path();

    @Value.Parameter(order=2)
    public StorageUri base();

    @Value.Parameter(order=3)
    @Value.Auxiliary
    public long modificationTimeMillisEpoch();

    @Value.Lazy
    default public StorageUri absolutePath() {
        return this.base().resolve(this.path());
    }

    @Value.Check
    default public void check() {
        Preconditions.checkArgument((boolean)this.base().isAbsolute(), (String)"Base location must be absolute: %s", (Object)this.base());
        Preconditions.checkArgument((!this.path().isAbsolute() ? 1 : 0) != 0, (String)"Path must be relative: %s", (Object)this.path());
    }

    public static ImmutableFileReference.Builder builder() {
        return ImmutableFileReference.builder();
    }

    public static FileReference of(StorageUri path, StorageUri base, long modificationTimeMillisEpoch) {
        return ImmutableFileReference.of(path, base, modificationTimeMillisEpoch);
    }
}

