/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.gc.files.local;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.MustBeClosed;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.AbstractMap;
import java.util.Objects;
import java.util.stream.Stream;
import org.projectnessie.gc.files.DeleteResult;
import org.projectnessie.gc.files.FileDeleter;
import org.projectnessie.gc.files.FileReference;
import org.projectnessie.gc.files.FilesLister;
import org.projectnessie.gc.files.NessieFileIOException;
import org.projectnessie.storage.uri.StorageUri;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalFiles
implements FilesLister,
FileDeleter {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalFiles.class);

    private Path toLocalPath(StorageUri uri) {
        Preconditions.checkArgument((boolean)"file".equals(uri.scheme()), (String)"Not a local file: %s", (Object)uri);
        return Paths.get(URI.create(Objects.requireNonNull(uri.location())));
    }

    @Override
    @MustBeClosed
    public Stream<FileReference> listRecursively(StorageUri path) throws NessieFileIOException {
        StorageUri basePath = path.withTrailingSeparator();
        try {
            Path start = this.toLocalPath(basePath);
            return Files.walk(start, new FileVisitOption[0]).filter(p -> !p.equals(start)).map(p -> {
                try {
                    return new AbstractMap.SimpleEntry<URI, BasicFileAttributes>(p.toUri(), Files.getFileAttributeView(p, BasicFileAttributeView.class, new LinkOption[0]).readAttributes());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }).filter(e -> ((BasicFileAttributes)e.getValue()).isRegularFile()).map(e -> FileReference.of(basePath.relativize(StorageUri.of((URI)((URI)e.getKey()))), basePath, ((BasicFileAttributes)e.getValue()).lastModifiedTime().toMillis()));
        }
        catch (IOException e2) {
            throw new NessieFileIOException("Failed to list files in " + path, e2);
        }
    }

    @Override
    public DeleteResult delete(FileReference fileReference) {
        try {
            Files.delete(this.toLocalPath(fileReference.absolutePath()));
            return DeleteResult.SUCCESS;
        }
        catch (NoSuchFileException e) {
            return DeleteResult.SUCCESS;
        }
        catch (IOException e) {
            LOGGER.debug("Failed to delete {}", (Object)fileReference, (Object)e);
            return DeleteResult.FAILURE;
        }
    }
}

