/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.gc.identify;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.annotation.Nullable;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.gc.contents.LiveContentSetsRepository;
import org.projectnessie.gc.identify.ContentToContentReference;
import org.projectnessie.gc.identify.ContentTypeFilter;
import org.projectnessie.gc.identify.IdentifyLiveContents;
import org.projectnessie.gc.identify.PerRefCutoffPolicySupplier;
import org.projectnessie.gc.identify.ReferenceComparator;
import org.projectnessie.gc.identify.VisitedDeduplicator;
import org.projectnessie.gc.repository.RepositoryConnector;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="IdentifyLiveContents", generator="Immutables")
@Immutable
public final class ImmutableIdentifyLiveContents
extends IdentifyLiveContents {
    private final PerRefCutoffPolicySupplier cutOffPolicySupplier;
    private final ContentTypeFilter contentTypeFilter;
    private final LiveContentSetsRepository liveContentSetsRepository;
    private final ContentToContentReference contentToContentReference;
    private final RepositoryConnector repositoryConnector;
    private final Clock clock;
    private final VisitedDeduplicator visitedDeduplicator;
    @Nullable
    private final ReferenceComparator referenceComparator;
    private final int parallelism;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableIdentifyLiveContents(Builder builder) {
        this.cutOffPolicySupplier = builder.cutOffPolicySupplier;
        this.contentTypeFilter = builder.contentTypeFilter;
        this.liveContentSetsRepository = builder.liveContentSetsRepository;
        this.contentToContentReference = builder.contentToContentReference;
        this.repositoryConnector = builder.repositoryConnector;
        this.referenceComparator = builder.referenceComparator;
        if (builder.clock != null) {
            this.initShim.clock(builder.clock);
        }
        if (builder.visitedDeduplicator != null) {
            this.initShim.visitedDeduplicator(builder.visitedDeduplicator);
        }
        if (builder.parallelismIsSet()) {
            this.initShim.parallelism(builder.parallelism);
        }
        this.clock = this.initShim.clock();
        this.visitedDeduplicator = this.initShim.visitedDeduplicator();
        this.parallelism = this.initShim.parallelism();
        this.initShim = null;
    }

    private ImmutableIdentifyLiveContents(PerRefCutoffPolicySupplier cutOffPolicySupplier, ContentTypeFilter contentTypeFilter, LiveContentSetsRepository liveContentSetsRepository, ContentToContentReference contentToContentReference, RepositoryConnector repositoryConnector, Clock clock, VisitedDeduplicator visitedDeduplicator, @Nullable ReferenceComparator referenceComparator, int parallelism) {
        this.cutOffPolicySupplier = cutOffPolicySupplier;
        this.contentTypeFilter = contentTypeFilter;
        this.liveContentSetsRepository = liveContentSetsRepository;
        this.contentToContentReference = contentToContentReference;
        this.repositoryConnector = repositoryConnector;
        this.clock = clock;
        this.visitedDeduplicator = visitedDeduplicator;
        this.referenceComparator = referenceComparator;
        this.parallelism = parallelism;
        this.initShim = null;
    }

    @Override
    PerRefCutoffPolicySupplier cutOffPolicySupplier() {
        return this.cutOffPolicySupplier;
    }

    @Override
    ContentTypeFilter contentTypeFilter() {
        return this.contentTypeFilter;
    }

    @Override
    LiveContentSetsRepository liveContentSetsRepository() {
        return this.liveContentSetsRepository;
    }

    @Override
    ContentToContentReference contentToContentReference() {
        return this.contentToContentReference;
    }

    @Override
    RepositoryConnector repositoryConnector() {
        return this.repositoryConnector;
    }

    @Override
    Clock clock() {
        InitShim shim = this.initShim;
        return shim != null ? shim.clock() : this.clock;
    }

    @Override
    VisitedDeduplicator visitedDeduplicator() {
        InitShim shim = this.initShim;
        return shim != null ? shim.visitedDeduplicator() : this.visitedDeduplicator;
    }

    @Override
    @Nullable
    ReferenceComparator referenceComparator() {
        return this.referenceComparator;
    }

    @Override
    int parallelism() {
        InitShim shim = this.initShim;
        return shim != null ? shim.parallelism() : this.parallelism;
    }

    public final ImmutableIdentifyLiveContents withCutOffPolicySupplier(PerRefCutoffPolicySupplier value) {
        if (this.cutOffPolicySupplier == value) {
            return this;
        }
        PerRefCutoffPolicySupplier newValue = Objects.requireNonNull(value, "cutOffPolicySupplier");
        return ImmutableIdentifyLiveContents.validate(new ImmutableIdentifyLiveContents(newValue, this.contentTypeFilter, this.liveContentSetsRepository, this.contentToContentReference, this.repositoryConnector, this.clock, this.visitedDeduplicator, this.referenceComparator, this.parallelism));
    }

    public final ImmutableIdentifyLiveContents withContentTypeFilter(ContentTypeFilter value) {
        if (this.contentTypeFilter == value) {
            return this;
        }
        ContentTypeFilter newValue = Objects.requireNonNull(value, "contentTypeFilter");
        return ImmutableIdentifyLiveContents.validate(new ImmutableIdentifyLiveContents(this.cutOffPolicySupplier, newValue, this.liveContentSetsRepository, this.contentToContentReference, this.repositoryConnector, this.clock, this.visitedDeduplicator, this.referenceComparator, this.parallelism));
    }

    public final ImmutableIdentifyLiveContents withLiveContentSetsRepository(LiveContentSetsRepository value) {
        if (this.liveContentSetsRepository == value) {
            return this;
        }
        LiveContentSetsRepository newValue = Objects.requireNonNull(value, "liveContentSetsRepository");
        return ImmutableIdentifyLiveContents.validate(new ImmutableIdentifyLiveContents(this.cutOffPolicySupplier, this.contentTypeFilter, newValue, this.contentToContentReference, this.repositoryConnector, this.clock, this.visitedDeduplicator, this.referenceComparator, this.parallelism));
    }

    public final ImmutableIdentifyLiveContents withContentToContentReference(ContentToContentReference value) {
        if (this.contentToContentReference == value) {
            return this;
        }
        ContentToContentReference newValue = Objects.requireNonNull(value, "contentToContentReference");
        return ImmutableIdentifyLiveContents.validate(new ImmutableIdentifyLiveContents(this.cutOffPolicySupplier, this.contentTypeFilter, this.liveContentSetsRepository, newValue, this.repositoryConnector, this.clock, this.visitedDeduplicator, this.referenceComparator, this.parallelism));
    }

    public final ImmutableIdentifyLiveContents withRepositoryConnector(RepositoryConnector value) {
        if (this.repositoryConnector == value) {
            return this;
        }
        RepositoryConnector newValue = Objects.requireNonNull(value, "repositoryConnector");
        return ImmutableIdentifyLiveContents.validate(new ImmutableIdentifyLiveContents(this.cutOffPolicySupplier, this.contentTypeFilter, this.liveContentSetsRepository, this.contentToContentReference, newValue, this.clock, this.visitedDeduplicator, this.referenceComparator, this.parallelism));
    }

    public final ImmutableIdentifyLiveContents withClock(Clock value) {
        if (this.clock == value) {
            return this;
        }
        Clock newValue = Objects.requireNonNull(value, "clock");
        return ImmutableIdentifyLiveContents.validate(new ImmutableIdentifyLiveContents(this.cutOffPolicySupplier, this.contentTypeFilter, this.liveContentSetsRepository, this.contentToContentReference, this.repositoryConnector, newValue, this.visitedDeduplicator, this.referenceComparator, this.parallelism));
    }

    public final ImmutableIdentifyLiveContents withVisitedDeduplicator(VisitedDeduplicator value) {
        if (this.visitedDeduplicator == value) {
            return this;
        }
        VisitedDeduplicator newValue = Objects.requireNonNull(value, "visitedDeduplicator");
        return ImmutableIdentifyLiveContents.validate(new ImmutableIdentifyLiveContents(this.cutOffPolicySupplier, this.contentTypeFilter, this.liveContentSetsRepository, this.contentToContentReference, this.repositoryConnector, this.clock, newValue, this.referenceComparator, this.parallelism));
    }

    public final ImmutableIdentifyLiveContents withReferenceComparator(@Nullable ReferenceComparator value) {
        if (this.referenceComparator == value) {
            return this;
        }
        return ImmutableIdentifyLiveContents.validate(new ImmutableIdentifyLiveContents(this.cutOffPolicySupplier, this.contentTypeFilter, this.liveContentSetsRepository, this.contentToContentReference, this.repositoryConnector, this.clock, this.visitedDeduplicator, value, this.parallelism));
    }

    public final ImmutableIdentifyLiveContents withParallelism(int value) {
        if (this.parallelism == value) {
            return this;
        }
        return ImmutableIdentifyLiveContents.validate(new ImmutableIdentifyLiveContents(this.cutOffPolicySupplier, this.contentTypeFilter, this.liveContentSetsRepository, this.contentToContentReference, this.repositoryConnector, this.clock, this.visitedDeduplicator, this.referenceComparator, value));
    }

    public boolean equals(@javax.annotation.Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableIdentifyLiveContents && this.equalTo(0, (ImmutableIdentifyLiveContents)another);
    }

    private boolean equalTo(int synthetic, ImmutableIdentifyLiveContents another) {
        return this.cutOffPolicySupplier.equals(another.cutOffPolicySupplier) && this.contentTypeFilter.equals(another.contentTypeFilter) && this.liveContentSetsRepository.equals(another.liveContentSetsRepository) && this.contentToContentReference.equals(another.contentToContentReference) && this.repositoryConnector.equals(another.repositoryConnector) && this.clock.equals(another.clock) && this.visitedDeduplicator.equals(another.visitedDeduplicator) && Objects.equals(this.referenceComparator, another.referenceComparator) && this.parallelism == another.parallelism;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.cutOffPolicySupplier.hashCode();
        h += (h << 5) + this.contentTypeFilter.hashCode();
        h += (h << 5) + this.liveContentSetsRepository.hashCode();
        h += (h << 5) + this.contentToContentReference.hashCode();
        h += (h << 5) + this.repositoryConnector.hashCode();
        h += (h << 5) + this.clock.hashCode();
        h += (h << 5) + this.visitedDeduplicator.hashCode();
        h += (h << 5) + Objects.hashCode(this.referenceComparator);
        h += (h << 5) + this.parallelism;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"IdentifyLiveContents").omitNullValues().add("cutOffPolicySupplier", (Object)this.cutOffPolicySupplier).add("contentTypeFilter", (Object)this.contentTypeFilter).add("liveContentSetsRepository", (Object)this.liveContentSetsRepository).add("contentToContentReference", (Object)this.contentToContentReference).add("repositoryConnector", (Object)this.repositoryConnector).add("clock", (Object)this.clock).add("visitedDeduplicator", (Object)this.visitedDeduplicator).add("referenceComparator", (Object)this.referenceComparator).add("parallelism", this.parallelism).toString();
    }

    private static ImmutableIdentifyLiveContents validate(ImmutableIdentifyLiveContents instance) {
        instance.verify();
        return instance;
    }

    public static ImmutableIdentifyLiveContents copyOf(IdentifyLiveContents instance) {
        if (instance instanceof ImmutableIdentifyLiveContents) {
            return (ImmutableIdentifyLiveContents)instance;
        }
        return ImmutableIdentifyLiveContents.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="IdentifyLiveContents", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    implements IdentifyLiveContents.Builder {
        private static final long INIT_BIT_CUT_OFF_POLICY_SUPPLIER = 1L;
        private static final long INIT_BIT_CONTENT_TYPE_FILTER = 2L;
        private static final long INIT_BIT_LIVE_CONTENT_SETS_REPOSITORY = 4L;
        private static final long INIT_BIT_CONTENT_TO_CONTENT_REFERENCE = 8L;
        private static final long INIT_BIT_REPOSITORY_CONNECTOR = 16L;
        private static final long OPT_BIT_PARALLELISM = 1L;
        private long initBits = 31L;
        private long optBits;
        @javax.annotation.Nullable
        private PerRefCutoffPolicySupplier cutOffPolicySupplier;
        @javax.annotation.Nullable
        private ContentTypeFilter contentTypeFilter;
        @javax.annotation.Nullable
        private LiveContentSetsRepository liveContentSetsRepository;
        @javax.annotation.Nullable
        private ContentToContentReference contentToContentReference;
        @javax.annotation.Nullable
        private RepositoryConnector repositoryConnector;
        @javax.annotation.Nullable
        private Clock clock;
        @javax.annotation.Nullable
        private VisitedDeduplicator visitedDeduplicator;
        @javax.annotation.Nullable
        private ReferenceComparator referenceComparator;
        private int parallelism;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(IdentifyLiveContents instance) {
            Objects.requireNonNull(instance, "instance");
            this.cutOffPolicySupplier(instance.cutOffPolicySupplier());
            this.contentTypeFilter(instance.contentTypeFilter());
            this.liveContentSetsRepository(instance.liveContentSetsRepository());
            this.contentToContentReference(instance.contentToContentReference());
            this.repositoryConnector(instance.repositoryConnector());
            this.clock(instance.clock());
            this.visitedDeduplicator(instance.visitedDeduplicator());
            ReferenceComparator referenceComparatorValue = instance.referenceComparator();
            if (referenceComparatorValue != null) {
                this.referenceComparator(referenceComparatorValue);
            }
            this.parallelism(instance.parallelism());
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder cutOffPolicySupplier(PerRefCutoffPolicySupplier cutOffPolicySupplier) {
            this.cutOffPolicySupplier = Objects.requireNonNull(cutOffPolicySupplier, "cutOffPolicySupplier");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder contentTypeFilter(ContentTypeFilter contentTypeFilter) {
            this.contentTypeFilter = Objects.requireNonNull(contentTypeFilter, "contentTypeFilter");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder liveContentSetsRepository(LiveContentSetsRepository liveContentSetsRepository) {
            this.liveContentSetsRepository = Objects.requireNonNull(liveContentSetsRepository, "liveContentSetsRepository");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder contentToContentReference(ContentToContentReference contentToContentReference) {
            this.contentToContentReference = Objects.requireNonNull(contentToContentReference, "contentToContentReference");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder repositoryConnector(RepositoryConnector repositoryConnector) {
            this.repositoryConnector = Objects.requireNonNull(repositoryConnector, "repositoryConnector");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder clock(Clock clock) {
            this.clock = Objects.requireNonNull(clock, "clock");
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder visitedDeduplicator(VisitedDeduplicator visitedDeduplicator) {
            this.visitedDeduplicator = Objects.requireNonNull(visitedDeduplicator, "visitedDeduplicator");
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder referenceComparator(@Nullable ReferenceComparator referenceComparator) {
            this.referenceComparator = referenceComparator;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder parallelism(int parallelism) {
            this.parallelism = parallelism;
            this.optBits |= 1L;
            return this;
        }

        @Override
        public ImmutableIdentifyLiveContents build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableIdentifyLiveContents.validate(new ImmutableIdentifyLiveContents(this));
        }

        private boolean parallelismIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("cutOffPolicySupplier");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("contentTypeFilter");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("liveContentSetsRepository");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("contentToContentReference");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("repositoryConnector");
            }
            return "Cannot build IdentifyLiveContents, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="IdentifyLiveContents", generator="Immutables")
    private final class InitShim {
        private byte clockBuildStage = 0;
        private Clock clock;
        private byte visitedDeduplicatorBuildStage = 0;
        private VisitedDeduplicator visitedDeduplicator;
        private byte parallelismBuildStage = 0;
        private int parallelism;

        private InitShim() {
        }

        Clock clock() {
            if (this.clockBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.clockBuildStage == 0) {
                this.clockBuildStage = (byte)-1;
                this.clock = Objects.requireNonNull(ImmutableIdentifyLiveContents.super.clock(), "clock");
                this.clockBuildStage = 1;
            }
            return this.clock;
        }

        void clock(Clock clock) {
            this.clock = clock;
            this.clockBuildStage = 1;
        }

        VisitedDeduplicator visitedDeduplicator() {
            if (this.visitedDeduplicatorBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.visitedDeduplicatorBuildStage == 0) {
                this.visitedDeduplicatorBuildStage = (byte)-1;
                this.visitedDeduplicator = Objects.requireNonNull(ImmutableIdentifyLiveContents.super.visitedDeduplicator(), "visitedDeduplicator");
                this.visitedDeduplicatorBuildStage = 1;
            }
            return this.visitedDeduplicator;
        }

        void visitedDeduplicator(VisitedDeduplicator visitedDeduplicator) {
            this.visitedDeduplicator = visitedDeduplicator;
            this.visitedDeduplicatorBuildStage = 1;
        }

        int parallelism() {
            if (this.parallelismBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.parallelismBuildStage == 0) {
                this.parallelismBuildStage = (byte)-1;
                this.parallelism = ImmutableIdentifyLiveContents.super.parallelism();
                this.parallelismBuildStage = 1;
            }
            return this.parallelism;
        }

        void parallelism(int parallelism) {
            this.parallelism = parallelism;
            this.parallelismBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.clockBuildStage == -1) {
                attributes.add("clock");
            }
            if (this.visitedDeduplicatorBuildStage == -1) {
                attributes.add("visitedDeduplicator");
            }
            if (this.parallelismBuildStage == -1) {
                attributes.add("parallelism");
            }
            return "Cannot build IdentifyLiveContents, attribute initializers form cycle " + attributes;
        }
    }
}

