/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.jaxrs.ext;

import java.net.URI;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.enterprise.inject.spi.Extension;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.SecurityContext;
import org.glassfish.jersey.message.DeflateEncoder;
import org.glassfish.jersey.message.GZipEncoder;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.filter.EncodingFilter;
import org.glassfish.jersey.test.JerseyTest;
import org.jboss.weld.environment.se.Weld;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.projectnessie.client.ext.NessieClientResolver;
import org.projectnessie.jaxrs.ext.ContextPrincipalExtension;
import org.projectnessie.jaxrs.ext.NessieAccessChecker;
import org.projectnessie.jaxrs.ext.NessieSecurityContext;
import org.projectnessie.services.authz.AbstractBatchAccessChecker;
import org.projectnessie.services.authz.AccessContext;
import org.projectnessie.services.authz.AuthorizerExtension;
import org.projectnessie.services.authz.BatchAccessChecker;
import org.projectnessie.services.config.ServerConfigExtension;
import org.projectnessie.services.impl.ConfigApiImpl;
import org.projectnessie.services.impl.TreeApiImpl;
import org.projectnessie.services.rest.RestConfigResource;
import org.projectnessie.services.rest.RestContentResource;
import org.projectnessie.services.rest.RestDiffResource;
import org.projectnessie.services.rest.RestNamespaceResource;
import org.projectnessie.services.rest.RestTreeResource;
import org.projectnessie.services.rest.RestV2ConfigResource;
import org.projectnessie.services.rest.RestV2TreeResource;
import org.projectnessie.services.restjavax.ConstraintViolationExceptionMapper;
import org.projectnessie.services.restjavax.ContentKeyParamConverterProvider;
import org.projectnessie.services.restjavax.NamespaceParamConverterProvider;
import org.projectnessie.services.restjavax.NessieExceptionMapper;
import org.projectnessie.services.restjavax.NessieJaxRsJsonMappingExceptionMapper;
import org.projectnessie.services.restjavax.NessieJaxRsJsonParseExceptionMapper;
import org.projectnessie.services.restjavax.ReferenceTypeParamConverterProvider;
import org.projectnessie.services.restjavax.ValidationExceptionMapper;
import org.projectnessie.versioned.PersistVersionStoreExtension;
import org.projectnessie.versioned.VersionStoreImplExtension;
import org.projectnessie.versioned.persist.adapter.DatabaseAdapter;
import org.projectnessie.versioned.storage.common.logic.Logics;
import org.projectnessie.versioned.storage.common.logic.RepositoryLogic;
import org.projectnessie.versioned.storage.common.persist.Persist;

public class NessieJaxRsExtension
extends NessieClientResolver
implements BeforeAllCallback,
BeforeEachCallback,
AfterEachCallback,
AfterTestExecutionCallback,
ParameterResolver {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{NessieJaxRsExtension.class});
    private final Supplier<DatabaseAdapter> databaseAdapterSupplier;
    private final Supplier<Persist> persistSupplier;

    public NessieJaxRsExtension() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public NessieJaxRsExtension(Supplier<DatabaseAdapter> databaseAdapterSupplier) {
        this(databaseAdapterSupplier, null);
    }

    private NessieJaxRsExtension(Supplier<DatabaseAdapter> databaseAdapterSupplier, Supplier<Persist> persistSupplier) {
        this.databaseAdapterSupplier = databaseAdapterSupplier;
        this.persistSupplier = persistSupplier;
    }

    public static NessieJaxRsExtension jaxRsExtensionForDatabaseAdapter(Supplier<DatabaseAdapter> databaseAdapterSupplier) {
        return new NessieJaxRsExtension(databaseAdapterSupplier, null);
    }

    public static NessieJaxRsExtension jaxRsExtension(Supplier<Persist> persistSupplier) {
        return new NessieJaxRsExtension(null, persistSupplier);
    }

    private EnvHolder getEnv(ExtensionContext extensionContext) {
        EnvHolder env = (EnvHolder)extensionContext.getStore(NAMESPACE).get(EnvHolder.class, EnvHolder.class);
        if (env == null) {
            throw new ParameterResolutionException("Nessie JaxRs env. is not initialized in " + extensionContext.getUniqueId());
        }
        return env;
    }

    public void beforeAll(ExtensionContext extensionContext) {
        extensionContext.getStore(NAMESPACE).getOrComputeIfAbsent(EnvHolder.class, key -> {
            try {
                PersistVersionStoreExtension versionStoreExtension = this.databaseAdapterSupplier != null ? PersistVersionStoreExtension.forDatabaseAdapter(() -> {
                    DatabaseAdapter databaseAdapter = this.databaseAdapterSupplier.get();
                    databaseAdapter.eraseRepo();
                    databaseAdapter.initializeRepo(ServerConfigExtension.SERVER_CONFIG.getDefaultBranch());
                    return databaseAdapter;
                }) : VersionStoreImplExtension.forPersist(() -> {
                    Persist persist = this.persistSupplier.get();
                    persist.erase();
                    RepositoryLogic repositoryLogic = Logics.repositoryLogic((Persist)persist);
                    repositoryLogic.initialize("main");
                    return persist;
                });
                return new EnvHolder((Extension)versionStoreExtension);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        });
    }

    public void afterEach(ExtensionContext extensionContext) {
        this.getEnv(extensionContext).reset();
    }

    public void afterTestExecution(ExtensionContext extensionContext) {
        this.getEnv(extensionContext).reset();
    }

    public void beforeEach(ExtensionContext extensionContext) {
        this.getEnv(extensionContext).reset();
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return super.supportsParameter(parameterContext, extensionContext) || parameterContext.isAnnotated(NessieSecurityContext.class) || parameterContext.isAnnotated(NessieAccessChecker.class);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        if (super.supportsParameter(parameterContext, extensionContext)) {
            return super.resolveParameter(parameterContext, extensionContext);
        }
        EnvHolder env = this.getEnv(extensionContext);
        if (parameterContext.isAnnotated(NessieSecurityContext.class)) {
            return env::setSecurityContext;
        }
        if (parameterContext.isAnnotated(NessieAccessChecker.class)) {
            return env::setAccessChecker;
        }
        throw new ParameterResolutionException("Unsupported annotation on parameter " + parameterContext.getParameter() + " on " + parameterContext.getTarget());
    }

    protected URI getBaseUri(ExtensionContext extensionContext) {
        return this.getEnv((ExtensionContext)extensionContext).jerseyTest.target().getUri();
    }

    private static class EnvHolder
    implements ExtensionContext.Store.CloseableResource {
        private final Weld weld = new Weld();
        private final JerseyTest jerseyTest;
        private SecurityContext securityContext;
        private Function<AccessContext, BatchAccessChecker> accessChecker;

        void reset() {
            this.securityContext = null;
            this.accessChecker = null;
        }

        void setSecurityContext(SecurityContext securityContext) {
            this.securityContext = securityContext;
        }

        void setAccessChecker(Function<AccessContext, BatchAccessChecker> accessChecker) {
            this.accessChecker = accessChecker;
        }

        public EnvHolder(Extension versionStoreExtension) throws Exception {
            this.weld.addPackages(true, new Class[]{RestConfigResource.class});
            this.weld.addPackages(true, new Class[]{TreeApiImpl.class});
            this.weld.addExtension((Extension)new ContextPrincipalExtension(() -> this.securityContext));
            this.weld.addExtension((Extension)new ServerConfigExtension());
            this.weld.addExtension(versionStoreExtension);
            this.weld.addExtension((Extension)new AuthorizerExtension().setAccessCheckerSupplier(this::createNewChecker));
            this.weld.property("org.jboss.weld.se.shutdownHook", (Object)"false");
            this.weld.initialize();
            this.jerseyTest = new JerseyTest(){

                protected Application configure() {
                    ResourceConfig config = new ResourceConfig();
                    config.register(RestV2ConfigResource.class);
                    config.register(RestV2TreeResource.class);
                    config.register(RestConfigResource.class);
                    config.register(RestTreeResource.class);
                    config.register(RestContentResource.class);
                    config.register(RestDiffResource.class);
                    config.register(RestNamespaceResource.class);
                    config.register(ConfigApiImpl.class);
                    config.register(ContentKeyParamConverterProvider.class);
                    config.register(NamespaceParamConverterProvider.class);
                    config.register(ReferenceTypeParamConverterProvider.class);
                    config.register(ValidationExceptionMapper.class, 10);
                    config.register(ConstraintViolationExceptionMapper.class, 10);
                    config.register(NessieExceptionMapper.class);
                    config.register(NessieJaxRsJsonParseExceptionMapper.class, 10);
                    config.register(NessieJaxRsJsonMappingExceptionMapper.class, 10);
                    config.register(EncodingFilter.class);
                    config.register(GZipEncoder.class);
                    config.register(DeflateEncoder.class);
                    this.set("jersey.config.test.container.port", "0");
                    return config;
                }
            };
            this.jerseyTest.setUp();
        }

        private BatchAccessChecker createNewChecker(AccessContext context) {
            if (this.accessChecker == null) {
                return AbstractBatchAccessChecker.NOOP_ACCESS_CHECKER;
            }
            return this.accessChecker.apply(context);
        }

        public void close() throws Throwable {
            this.jerseyTest.tearDown();
            this.weld.shutdown();
        }
    }
}

