/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.jaxrs.ext;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.Extension;
import java.lang.annotation.Annotation;
import java.util.function.Function;
import org.projectnessie.services.authz.AbstractBatchAccessChecker;
import org.projectnessie.services.authz.AccessContext;
import org.projectnessie.services.authz.Authorizer;
import org.projectnessie.services.authz.BatchAccessChecker;

public class AuthorizerExtension
implements Extension {
    private volatile Function<AccessContext, BatchAccessChecker> accessCheckerSupplier;
    private final Authorizer authorizer = new Authorizer(){

        public BatchAccessChecker startAccessCheck(AccessContext context) {
            if (AuthorizerExtension.this.accessCheckerSupplier == null) {
                return AbstractBatchAccessChecker.NOOP_ACCESS_CHECKER;
            }
            return AuthorizerExtension.this.accessCheckerSupplier.apply(context);
        }
    };

    public AuthorizerExtension setAccessCheckerSupplier(Function<AccessContext, BatchAccessChecker> accessCheckerSupplier) {
        this.accessCheckerSupplier = accessCheckerSupplier;
        return this;
    }

    public void afterBeanDiscovery(@Observes AfterBeanDiscovery abd, BeanManager bm) {
        abd.addBean().addType(Authorizer.class).addQualifier((Annotation)Default.Literal.INSTANCE).scope(ApplicationScoped.class).produceWith(i -> this.authorizer);
    }
}

