/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.jaxrs.tests;

import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.lang.invoke.CallSite;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.projectnessie.client.ext.NessieApiVersion;
import org.projectnessie.client.ext.NessieApiVersions;
import org.projectnessie.error.ErrorCode;
import org.projectnessie.error.NessieError;
import org.projectnessie.jaxrs.tests.BaseTestNessieRest;
import org.projectnessie.model.Branch;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.CommitResponse;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.ContentResponse;
import org.projectnessie.model.Detached;
import org.projectnessie.model.DiffResponse;
import org.projectnessie.model.EntriesResponse;
import org.projectnessie.model.GetMultipleContentsRequest;
import org.projectnessie.model.GetMultipleContentsResponse;
import org.projectnessie.model.IcebergTable;
import org.projectnessie.model.LogResponse;
import org.projectnessie.model.MergeResponse;
import org.projectnessie.model.Reference;
import org.projectnessie.model.SingleReferenceResponse;
import org.projectnessie.model.Tag;

public abstract class AbstractRelativeReferences {
    private final BaseTestNessieRest outer;
    private final ContentKey key1 = ContentKey.of((String[])new String[]{"key1"});
    private final ContentKey key2 = ContentKey.of((String[])new String[]{"key2"});
    private final ContentKey key3 = ContentKey.of((String[])new String[]{"key3"});
    private final ContentKey key4 = ContentKey.of((String[])new String[]{"key4"});
    private final ContentKey key5 = ContentKey.of((String[])new String[]{"key5"});
    private final IcebergTable table1 = IcebergTable.of((String)"1", (long)1L, (int)1, (int)1, (int)1);
    private final IcebergTable table2 = IcebergTable.of((String)"2", (long)2L, (int)2, (int)2, (int)2);
    private final IcebergTable table3 = IcebergTable.of((String)"3", (long)3L, (int)3, (int)3, (int)3);
    private final IcebergTable table4 = IcebergTable.of((String)"4", (long)4L, (int)4, (int)4, (int)4);
    private final IcebergTable table5 = IcebergTable.of((String)"5", (long)5L, (int)5, (int)5, (int)5);
    private String c1;
    private String c2;
    private String c3;
    private String c4;
    private String c5;
    private Branch etl1;

    protected AbstractRelativeReferences(BaseTestNessieRest outer) {
        this.outer = outer;
    }

    @BeforeEach
    @NessieApiVersions(versions={NessieApiVersion.V2})
    void createFixtures() {
        Assumptions.assumeTrue((boolean)this.outer.isNewModel());
        Branch base = this.outer.createBranchV2("base");
        base = this.outer.commitV2(base, this.key1, this.table1);
        this.c1 = base.getHash();
        base = this.outer.commitV2(base, this.key2, this.table2);
        this.c2 = base.getHash();
        this.etl1 = this.outer.createBranchV2("etl1", (Reference)base);
        this.etl1 = this.outer.commitV2(this.etl1, this.key3, this.table3);
        this.c3 = this.etl1.getHash();
        Branch etl2 = this.outer.createBranchV2("etl2", (Reference)this.etl1);
        etl2 = this.outer.commitV2(etl2, this.key4, this.table4);
        this.c4 = etl2.getHash();
        this.outer.createTagV2("tag1", (Reference)etl2);
        etl2 = this.outer.commitV2(etl2, this.key5, this.table5);
        this.c5 = etl2.getHash();
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    public void createReferenceFromBranchUnambiguous() {
        Branch reference = AbstractRelativeReferences.expectBranch((Response)BaseTestNessieRest.rest().queryParam("name", new Object[]{"branch1"}).queryParam("type", new Object[]{"branch"}).body((Object)Branch.of((String)"base", (String)(this.c2 + "~1"))).post("trees", new Object[0]));
        Assertions.assertThat((String)reference.getName()).isEqualTo("branch1");
        Assertions.assertThat((String)reference.getHash()).isEqualTo(this.c1);
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    public void createReferenceFromBranchAmbiguous() {
        NessieError error = AbstractRelativeReferences.expectError((Response)BaseTestNessieRest.rest().queryParam("name", new Object[]{"branch1"}).queryParam("type", new Object[]{"branch"}).body((Object)Branch.of((String)"base", (String)"~1")).post("trees", new Object[0]), 400);
        this.checkError(error, ErrorCode.BAD_REQUEST, "Target hash must contain a starting commit ID.");
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    public void createReferenceFromBranchHead() {
        NessieError error = AbstractRelativeReferences.expectError((Response)BaseTestNessieRest.rest().queryParam("name", new Object[]{"branch1"}).queryParam("type", new Object[]{"branch"}).body((Object)Branch.of((String)"etl2", null)).post("trees", new Object[0]), 400);
        this.checkError(error, ErrorCode.BAD_REQUEST, "Target hash must be provided.");
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    public void createReferenceFromTagUnambiguous() {
        Branch reference = AbstractRelativeReferences.expectBranch((Response)BaseTestNessieRest.rest().queryParam("name", new Object[]{"branch1"}).queryParam("type", new Object[]{"branch"}).body((Object)Tag.of((String)"tag1", (String)(this.c4 + "~1"))).post("trees", new Object[0]));
        Assertions.assertThat((String)reference.getName()).isEqualTo("branch1");
        Assertions.assertThat((String)reference.getHash()).isEqualTo(this.c3);
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    public void createReferenceFromTagAmbiguous() {
        NessieError error = AbstractRelativeReferences.expectError((Response)BaseTestNessieRest.rest().queryParam("name", new Object[]{"branch1"}).queryParam("type", new Object[]{"branch"}).body((Object)Tag.of((String)"tag1", (String)"~1")).post("trees", new Object[0]), 400);
        this.checkError(error, ErrorCode.BAD_REQUEST, "Target hash must contain a starting commit ID.");
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    public void createReferenceFromTagHead() {
        NessieError error = AbstractRelativeReferences.expectError((Response)BaseTestNessieRest.rest().queryParam("name", new Object[]{"branch1"}).queryParam("type", new Object[]{"branch"}).body((Object)Tag.of((String)"tag1", null)).post("trees", new Object[0]), 400);
        this.checkError(error, ErrorCode.BAD_REQUEST, "Target hash must be provided.");
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    public void createReferenceFromDetachedUnambiguous() {
        Branch reference = AbstractRelativeReferences.expectBranch((Response)BaseTestNessieRest.rest().queryParam("name", new Object[]{"branch1"}).queryParam("type", new Object[]{"branch"}).body((Object)Detached.of((String)(this.c2 + "~1"))).post("trees", new Object[0]));
        Assertions.assertThat((String)reference.getName()).isEqualTo("branch1");
        Assertions.assertThat((String)reference.getHash()).isEqualTo(this.c1);
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    public void createReferenceFromDetachedAmbiguous() {
        NessieError error = AbstractRelativeReferences.expectError((Response)BaseTestNessieRest.rest().queryParam("name", new Object[]{"branch1"}).queryParam("type", new Object[]{"branch"}).body((Object)Detached.of((String)"~1")).post("trees", new Object[0]), 400);
        this.checkError(error, ErrorCode.BAD_REQUEST, "Target hash must contain a starting commit ID.");
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    public void assignReferenceFromBranchUnambiguous() {
        Branch base = AbstractRelativeReferences.expectBranch((Response)BaseTestNessieRest.rest().body((Object)this.etl1).put("trees/base@{hash}", new Object[]{this.c3 + "~1"}));
        this.outer.soft.assertThat(base.getHash()).isEqualTo(this.c3);
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    public void assignReferenceFromBranchUnambiguousNotAtExpectedHash() {
        NessieError error = AbstractRelativeReferences.expectError((Response)BaseTestNessieRest.rest().body((Object)this.etl1).put("trees/base@{hash}", new Object[]{this.c3 + "~2"}), 409);
        this.checkError(error, ErrorCode.REFERENCE_CONFLICT, "Named-reference 'base' is not at expected hash");
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    public void assignReferenceFromBranchUnambiguousExpectedHashUnreachable() {
        NessieError error = AbstractRelativeReferences.expectError((Response)BaseTestNessieRest.rest().body((Object)this.etl1).put("trees/base@{hash}", new Object[]{this.c5 + "~1"}), 409);
        this.checkError(error, ErrorCode.REFERENCE_CONFLICT, "Named-reference 'base' is not at expected hash");
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    public void assignReferenceFromBranchUnambiguousExpectedHashNonExistent() {
        NessieError error = AbstractRelativeReferences.expectError((Response)BaseTestNessieRest.rest().body((Object)this.etl1).put("trees/base@cafebabe~1", new Object[0]), 404);
        this.checkError(error, ErrorCode.REFERENCE_NOT_FOUND, "Commit 'cafebabe' not found");
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    public void assignReferenceFromBranchAmbiguous() {
        NessieError error = AbstractRelativeReferences.expectError((Response)BaseTestNessieRest.rest().body((Object)this.etl1).put("trees/base@{hash}", new Object[]{"^1"}), 400);
        this.checkError(error, ErrorCode.BAD_REQUEST, "Expected hash must contain a starting commit ID.");
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    public void assignReferenceFromBranchHead() {
        NessieError error = AbstractRelativeReferences.expectError((Response)BaseTestNessieRest.rest().body((Object)this.etl1).put("trees/base", new Object[0]), 400);
        this.checkError(error, ErrorCode.BAD_REQUEST, "Expected hash must be provided.");
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    public void assignReferenceFromTagUnambiguous() {
        Tag base = AbstractRelativeReferences.expectTag((Response)BaseTestNessieRest.rest().body((Object)this.etl1).put("trees/tag1@{hash}", new Object[]{this.c5 + "~1"}));
        this.outer.soft.assertThat(base.getHash()).isEqualTo(this.c3);
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    public void assignReferenceFromTagUnambiguousNotAtExpectedHash() {
        NessieError error = AbstractRelativeReferences.expectError((Response)BaseTestNessieRest.rest().body((Object)this.etl1).put("trees/tag1@{hash}", new Object[]{this.c5 + "~2"}), 409);
        this.checkError(error, ErrorCode.REFERENCE_CONFLICT, "Named-reference 'tag1' is not at expected hash");
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    public void assignReferenceFromTagUnambiguousExpectedHashUnreachable() {
        NessieError error = AbstractRelativeReferences.expectError((Response)BaseTestNessieRest.rest().body((Object)this.etl1).put("trees/tag1@{hash}", new Object[]{this.c5 + "*" + Instant.now().plusSeconds(60L)}), 409);
        this.checkError(error, ErrorCode.REFERENCE_CONFLICT, "Named-reference 'tag1' is not at expected hash");
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    public void assignReferenceFromTagUnambiguousExpectedHashNonExistent() {
        NessieError error = AbstractRelativeReferences.expectError((Response)BaseTestNessieRest.rest().body((Object)this.etl1).put("trees/tag1@cafebabe~1", new Object[0]), 404);
        this.checkError(error, ErrorCode.REFERENCE_NOT_FOUND, "Commit 'cafebabe' not found");
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    public void assignReferenceFromTagAmbiguous() {
        NessieError error = AbstractRelativeReferences.expectError((Response)BaseTestNessieRest.rest().body((Object)this.etl1).put("trees/tag1@{hash}", new Object[]{"~1"}), 400);
        this.checkError(error, ErrorCode.BAD_REQUEST, "Expected hash must contain a starting commit ID.");
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    public void assignReferenceFromTagHead() {
        NessieError error = AbstractRelativeReferences.expectError((Response)BaseTestNessieRest.rest().body((Object)this.etl1).put("trees/tag1", new Object[0]), 400);
        this.checkError(error, ErrorCode.BAD_REQUEST, "Expected hash must be provided.");
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    public void assignReferenceFromDetachedUnambiguous() {
        NessieError error = AbstractRelativeReferences.expectError((Response)BaseTestNessieRest.rest().body((Object)this.etl1).put("trees/@{hash}", new Object[]{this.c2 + "~1"}), 400);
        this.checkError(error, ErrorCode.BAD_REQUEST, "Assignment target must be a branch or a tag.");
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    public void assignReferenceFromDetachedAmbiguous() {
        NessieError error = AbstractRelativeReferences.expectError((Response)BaseTestNessieRest.rest().body((Object)this.etl1).put("trees/@{hash}", new Object[]{"~1"}), 400);
        this.checkError(error, ErrorCode.BAD_REQUEST, "Assignment target must be a branch or a tag.");
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    public void assignReferenceToBranchUnambiguous() {
        this.etl1 = AbstractRelativeReferences.expectBranch((Response)BaseTestNessieRest.rest().body((Object)Branch.of((String)"base", (String)(this.c2 + "~1"))).put("trees/etl1@{hash}", new Object[]{this.etl1.getHash()}));
        this.outer.soft.assertThat(this.etl1.getHash()).isEqualTo(this.c1);
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    public void assignReferenceToBranchAmbiguous() {
        NessieError error = AbstractRelativeReferences.expectError((Response)BaseTestNessieRest.rest().body((Object)Branch.of((String)"etl2", (String)"~1")).put("trees/etl1@{hash}", new Object[]{this.etl1.getHash()}), 400);
        this.checkError(error, ErrorCode.BAD_REQUEST, "Target hash must contain a starting commit ID.");
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    public void assignReferenceToBranchHead() {
        NessieError error = AbstractRelativeReferences.expectError((Response)BaseTestNessieRest.rest().body((Object)Branch.of((String)"base", null)).put("trees/etl1@{hash}", new Object[]{this.etl1.getHash()}), 400);
        this.checkError(error, ErrorCode.BAD_REQUEST, "Target hash must be provided.");
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    public void assignReferenceToTagUnambiguous() {
        this.etl1 = AbstractRelativeReferences.expectBranch((Response)BaseTestNessieRest.rest().body((Object)Tag.of((String)"tag1", (String)(this.c4 + "~1"))).put("trees/etl1@{hash}", new Object[]{this.etl1.getHash()}));
        this.outer.soft.assertThat(this.etl1.getHash()).isEqualTo(this.c3);
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    public void assignReferenceToTagAmbiguous() {
        NessieError error = AbstractRelativeReferences.expectError((Response)BaseTestNessieRest.rest().body((Object)Tag.of((String)"tag1", (String)"~1")).put("trees/etl1@{hash}", new Object[]{this.etl1.getHash()}), 400);
        this.checkError(error, ErrorCode.BAD_REQUEST, "Target hash must contain a starting commit ID.");
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    public void assignReferenceToTagHead() {
        NessieError error = AbstractRelativeReferences.expectError((Response)BaseTestNessieRest.rest().body((Object)Tag.of((String)"tag1", null)).put("trees/etl1@{hash}", new Object[]{this.etl1.getHash()}), 400);
        this.checkError(error, ErrorCode.BAD_REQUEST, "Target hash must be provided.");
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    public void assignReferenceToDetachedUnambiguous() {
        this.etl1 = AbstractRelativeReferences.expectBranch((Response)BaseTestNessieRest.rest().body((Object)Detached.of((String)(this.c2 + "~1"))).put("trees/etl1@{hash}", new Object[]{this.etl1.getHash()}));
        this.outer.soft.assertThat(this.etl1.getHash()).isEqualTo(this.c1);
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    public void assignReferenceToDetachedAmbiguous() {
        NessieError error = AbstractRelativeReferences.expectError((Response)BaseTestNessieRest.rest().body((Object)Detached.of((String)"~1")).put("trees/etl1@{hash}", new Object[]{this.etl1.getHash()}), 400);
        this.checkError(error, ErrorCode.BAD_REQUEST, "Target hash must contain a starting commit ID.");
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    public void deleteReferenceUnambiguous() {
        Branch base = AbstractRelativeReferences.expectBranch((Response)BaseTestNessieRest.rest().delete("trees/base@{hash}", new Object[]{this.c3 + "~1"}));
        this.outer.soft.assertThat(base.getHash()).isEqualTo(this.c2);
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    public void deleteReferenceUnambiguousNotAtExpectedHash() {
        NessieError error = AbstractRelativeReferences.expectError((Response)BaseTestNessieRest.rest().delete("trees/base@{hash}", new Object[]{this.c3 + "~2"}), 409);
        this.checkError(error, ErrorCode.REFERENCE_CONFLICT, "Named-reference 'base' is not at expected hash");
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    public void deleteReferenceUnambiguousExpectedHashUnreachable() {
        NessieError error = AbstractRelativeReferences.expectError((Response)BaseTestNessieRest.rest().delete("trees/base@{hash}", new Object[]{this.c5 + "~1"}), 409);
        this.checkError(error, ErrorCode.REFERENCE_CONFLICT, "Named-reference 'base' is not at expected hash");
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    public void deleteReferenceUnambiguousExpectedHashNonExistent() {
        NessieError error = AbstractRelativeReferences.expectError((Response)BaseTestNessieRest.rest().delete("trees/base@{hash}", new Object[]{"cafebabe~1"}), 404);
        this.checkError(error, ErrorCode.REFERENCE_NOT_FOUND, "Commit 'cafebabe' not found");
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    public void deleteReferenceAmbiguous() {
        NessieError error = AbstractRelativeReferences.expectError((Response)BaseTestNessieRest.rest().delete("trees/base@{hash}", new Object[]{"^1"}), 400);
        this.checkError(error, ErrorCode.BAD_REQUEST, "Expected hash must contain a starting commit ID.");
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    public void deleteReferenceHead() {
        NessieError error = AbstractRelativeReferences.expectError((Response)BaseTestNessieRest.rest().delete("trees/base", new Object[0]), 400);
        this.checkError(error, ErrorCode.BAD_REQUEST, "Expected hash must be provided.");
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    void commitToBranchUnambiguous() {
        Set keys = ((CommitResponse)((ValidatableResponse)this.outer.prepareCommitV2("base@" + this.c3 + "~1", this.key3, this.table3, 2, false).statusCode(200)).extract().as(CommitResponse.class)).toAddedContentsMap().keySet();
        Assertions.assertThat(keys).containsOnly((Object[])new ContentKey[]{this.key3});
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    void commitToBranchUnambiguousNotAtExpectedHash() {
        Set keys = ((CommitResponse)((ValidatableResponse)this.outer.prepareCommitV2("base@" + this.c3 + "~2", this.key3, this.table3, 2, false).statusCode(200)).extract().as(CommitResponse.class)).toAddedContentsMap().keySet();
        Assertions.assertThat(keys).containsOnly((Object[])new ContentKey[]{this.key3});
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    void commitToBranchUnambiguousUnreachable() {
        NessieError error = AbstractRelativeReferences.expectError(this.outer.prepareCommitV2("base@" + this.c5 + "~1", this.key3, this.table3, 2, false), 404);
        this.checkError(error, ErrorCode.REFERENCE_NOT_FOUND, "Could not find commit '" + this.c4 + "' in reference 'base'");
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    void commitToBranchUnambiguousNonExistent() {
        NessieError error = AbstractRelativeReferences.expectError(this.outer.prepareCommitV2("base@cafebabe~1", this.key3, this.table3, 2, false), 404);
        this.checkError(error, ErrorCode.REFERENCE_NOT_FOUND, "Commit 'cafebabe' not found");
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    void commitToBranchAmbiguous() {
        NessieError error = AbstractRelativeReferences.expectError(this.outer.prepareCommitV2("base*2023-01-01T00:00:00.000Z", this.key3, this.table3, 2, false), 400);
        this.checkError(error, ErrorCode.BAD_REQUEST, "Expected hash must contain a starting commit ID.");
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    public void commitToBranchHead() {
        NessieError error = AbstractRelativeReferences.expectError(this.outer.prepareCommitV2("base", this.key3, this.table3, 2, false), 400);
        this.checkError(error, ErrorCode.BAD_REQUEST, "Expected hash must be provided.");
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    public void commitToTagUnambiguous() {
        NessieError error = AbstractRelativeReferences.expectError(this.outer.prepareCommitV2("tag1@" + this.c4 + "~1", this.key3, this.table3, 2, false), 400);
        this.checkError(error, ErrorCode.BAD_REQUEST, "Reference to commit into must be a branch.");
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    public void commitToTagAmbiguous() {
        NessieError error = AbstractRelativeReferences.expectError(this.outer.prepareCommitV2("tag1@~1", this.key3, this.table3, 2, false), 400);
        this.checkError(error, ErrorCode.BAD_REQUEST, "Reference to commit into must be a branch.");
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    public void commitToTagHead() {
        NessieError error = AbstractRelativeReferences.expectError(this.outer.prepareCommitV2("tag1", this.key3, this.table3, 2, false), 400);
        this.checkError(error, ErrorCode.BAD_REQUEST, "Reference to commit into must be a branch.");
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    public void commitToDetachedUnambiguous() {
        NessieError error = AbstractRelativeReferences.expectError(this.outer.prepareCommitV2("@" + this.c5 + "~1", this.key3, this.table3, 2, false), 400);
        this.checkError(error, ErrorCode.BAD_REQUEST, "Reference to commit into must be a branch.");
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    public void commitToDetachedAmbiguous() {
        NessieError error = AbstractRelativeReferences.expectError(this.outer.prepareCommitV2("@~1", this.key3, this.table3, 2, false), 400);
        this.checkError(error, ErrorCode.BAD_REQUEST, "Reference to commit into must be a branch.");
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    void mergeFromBranchUnambiguous() {
        MergeResponse response = AbstractRelativeReferences.expectMerge(this.outer.prepareMergeV2("base@" + this.c2, "etl2", this.c5 + "~2", 2));
        this.checkMerge(response, this.c2, this.c2);
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    void mergeFromBranchAmbiguous() {
        NessieError error = AbstractRelativeReferences.expectError(this.outer.prepareMergeV2("base@" + this.c2, "etl1", "*2023-01-01T00:00:00.000Z", 2), 400);
        this.checkError(error, ErrorCode.BAD_REQUEST, "Source hash must contain a starting commit ID.");
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    public void mergeFromBranchHead() {
        NessieError error = AbstractRelativeReferences.expectError(this.outer.prepareMergeV2("base@" + this.c2, "etl1", null, 2), 400);
        this.checkError(error, ErrorCode.BAD_REQUEST, "Source hash must be provided.");
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    public void mergeFromTagUnambiguous() {
        MergeResponse response = AbstractRelativeReferences.expectMerge(this.outer.prepareMergeV2("base@" + this.c2, "tag1", this.c5 + "~1", 2));
        this.checkMerge(response, this.c2, this.c2);
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    public void mergeFromTagAmbiguous() {
        NessieError error = AbstractRelativeReferences.expectError(this.outer.prepareMergeV2("base@" + this.c2, "tag1", "~2", 2), 400);
        this.checkError(error, ErrorCode.BAD_REQUEST, "Source hash must contain a starting commit ID.");
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    public void mergeFromTagHead() {
        NessieError error = AbstractRelativeReferences.expectError(this.outer.prepareMergeV2("base@" + this.c2, "tag1", null, 2), 400);
        this.checkError(error, ErrorCode.BAD_REQUEST, "Source hash must be provided.");
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    public void mergeFromDetachedUnambiguous() {
        MergeResponse response = AbstractRelativeReferences.expectMerge(this.outer.prepareMergeV2("base@" + this.c2, "DETACHED", this.c5 + "~2", 2));
        this.checkMerge(response, this.c2, this.c2);
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    public void mergeFromDetachedAmbiguous() {
        NessieError error = AbstractRelativeReferences.expectError(this.outer.prepareMergeV2("base@" + this.c2, "DETACHED", "~2", 2), 400);
        this.checkError(error, ErrorCode.BAD_REQUEST, "Source hash must contain a starting commit ID.");
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    void mergeToBranchUnambiguous() {
        MergeResponse response = AbstractRelativeReferences.expectMerge(this.outer.prepareMergeV2("base@" + this.c3 + "~1", "etl1", this.c3, 2));
        this.checkMerge(response, this.c2, this.c2);
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    void mergeToBranchUnambiguousNotAtExpectedHash() {
        MergeResponse response = AbstractRelativeReferences.expectMerge(this.outer.prepareMergeV2("base@" + this.c3 + "~2", "etl1", this.c3, 2));
        this.checkMerge(response, this.c2, this.c2);
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    void mergeToBranchUnambiguousExpectedHashUnreachable() {
        NessieError error = AbstractRelativeReferences.expectError(this.outer.prepareMergeV2("base@" + this.c5 + "~1", "etl1", this.c3, 2), 404);
        this.checkError(error, ErrorCode.REFERENCE_NOT_FOUND, "Could not find commit '" + this.c4 + "' in reference 'base'");
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    void mergeToBranchUnambiguousExpectedHashNonExistent() {
        NessieError error = AbstractRelativeReferences.expectError(this.outer.prepareMergeV2("base@cafebabe~1", "etl1", this.c3, 2), 404);
        this.checkError(error, ErrorCode.REFERENCE_NOT_FOUND, "Commit 'cafebabe' not found");
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    void mergeToBranchAmbiguous() {
        NessieError error = AbstractRelativeReferences.expectError(this.outer.prepareMergeV2("base@*2023-01-01T00:00:00.000Z", "etl1", this.c3, 2), 400);
        this.checkError(error, ErrorCode.BAD_REQUEST, "Expected hash must contain a starting commit ID.");
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    public void mergeToBranchHead() {
        NessieError error = AbstractRelativeReferences.expectError(this.outer.prepareMergeV2("base", "etl1", this.c3, 2), 400);
        this.checkError(error, ErrorCode.BAD_REQUEST, "Expected hash must be provided.");
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    public void mergeToTagUnambiguous() {
        NessieError error = AbstractRelativeReferences.expectError(this.outer.prepareMergeV2("tag1@" + this.c4 + "~1", "etl1", this.c3, 2), 400);
        this.checkError(error, ErrorCode.BAD_REQUEST, "Reference to merge into must be a branch.");
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    public void mergeToTagAmbiguous() {
        NessieError error = AbstractRelativeReferences.expectError(this.outer.prepareMergeV2("tag1@~1", "etl1", this.c3, 2), 400);
        this.checkError(error, ErrorCode.BAD_REQUEST, "Reference to merge into must be a branch.");
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    public void mergeToTagHead() {
        NessieError error = AbstractRelativeReferences.expectError(this.outer.prepareMergeV2("tag1", "etl1", this.c3, 2), 400);
        this.checkError(error, ErrorCode.BAD_REQUEST, "Reference to merge into must be a branch.");
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    public void mergeToDetachedUnambiguous() {
        NessieError error = AbstractRelativeReferences.expectError(this.outer.prepareMergeV2("@" + this.c5 + "~1", "etl1", this.c3, 2), 400);
        this.checkError(error, ErrorCode.BAD_REQUEST, "Reference to merge into must be a branch.");
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    public void mergeToDetachedAmbiguous() {
        NessieError error = AbstractRelativeReferences.expectError(this.outer.prepareMergeV2("@*2023-01-01T00:00:00.000Z", "etl1", this.c3, 2), 400);
        this.checkError(error, ErrorCode.BAD_REQUEST, "Reference to merge into must be a branch.");
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    void transplantFromBranchUnambiguous() {
        List<String> hashes = Arrays.asList(this.c5 + "~1", this.c5 + "*" + Instant.now().plusSeconds(60L));
        MergeResponse response = AbstractRelativeReferences.expectMerge(this.outer.prepareTransplantV2("base@" + this.c2, "etl2", hashes, 2));
        this.outer.soft.assertThat(response.getEffectiveTargetHash()).isEqualTo(this.c2);
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    void transplantFromBranchAmbiguous() {
        List<String> hashes = Arrays.asList(this.c5, "~1");
        NessieError error = AbstractRelativeReferences.expectError(this.outer.prepareTransplantV2("base@" + this.c2, "etl2", hashes, 2), 400);
        this.outer.soft.assertThat(error.getMessage()).contains(new CharSequence[]{"Hash to transplant must contain a starting commit ID."});
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    public void transplantFromTagUnambiguous() {
        List<CallSite> hashes = Collections.singletonList(this.c4 + "~1");
        MergeResponse response = AbstractRelativeReferences.expectMerge(this.outer.prepareTransplantV2("base@" + this.c2, "tag1", hashes, 2));
        this.outer.soft.assertThat(response.getEffectiveTargetHash()).isEqualTo(this.c2);
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    public void transplantFromTagAmbiguous() {
        List<String> hashes = Collections.singletonList("~1");
        NessieError error = AbstractRelativeReferences.expectError(this.outer.prepareTransplantV2("base@" + this.c2, "tag1", hashes, 2), 400);
        this.outer.soft.assertThat(error.getMessage()).contains(new CharSequence[]{"Hash to transplant must contain a starting commit ID."});
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    public void transplantFromDetachedUnambiguous() {
        List<CallSite> hashes = Collections.singletonList(this.c5 + "~1");
        MergeResponse response = AbstractRelativeReferences.expectMerge(this.outer.prepareTransplantV2("base@" + this.c2, "DETACHED", hashes, 2));
        this.outer.soft.assertThat(response.getEffectiveTargetHash()).isEqualTo(this.c2);
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    public void transplantFromDetachedAmbiguous() {
        List<String> hashes = Collections.singletonList("~1");
        NessieError error = AbstractRelativeReferences.expectError(this.outer.prepareTransplantV2("base@" + this.c2, "DETACHED", hashes, 2), 400);
        this.outer.soft.assertThat(error.getMessage()).contains(new CharSequence[]{"Hash to transplant must contain a starting commit ID."});
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    void transplantToBranchUnambiguous() {
        List<String> hashes = Arrays.asList(this.c3, this.c4, this.c5);
        MergeResponse response = AbstractRelativeReferences.expectMerge(this.outer.prepareTransplantV2("base@" + this.c3 + "~1", "etl2", hashes, 2));
        this.outer.soft.assertThat(response.getEffectiveTargetHash()).isEqualTo(this.c2);
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    void transplantToBranchUnambiguousNotAtExpectedHash() {
        List<String> hashes = Arrays.asList(this.c3, this.c4, this.c5);
        MergeResponse response = AbstractRelativeReferences.expectMerge(this.outer.prepareTransplantV2("base@" + this.c3 + "~2", "etl2", hashes, 2));
        this.outer.soft.assertThat(response.getEffectiveTargetHash()).isEqualTo(this.c2);
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    void transplantToBranchUnambiguousExpectedHashUnreachable() {
        List<String> hashes = Arrays.asList(this.c3, this.c4, this.c5);
        NessieError error = AbstractRelativeReferences.expectError(this.outer.prepareTransplantV2("base@" + this.c5 + "~1", "etl2", hashes, 2), 404);
        this.checkError(error, ErrorCode.REFERENCE_NOT_FOUND, "Could not find commit '" + this.c4 + "' in reference 'base'");
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    void transplantToBranchUnambiguousExpectedHashNonExistent() {
        List<String> hashes = Arrays.asList(this.c3, this.c4, this.c5);
        NessieError error = AbstractRelativeReferences.expectError(this.outer.prepareTransplantV2("base@cafebabe~1", "etl2", hashes, 2), 404);
        this.checkError(error, ErrorCode.REFERENCE_NOT_FOUND, "Commit 'cafebabe' not found");
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    void transplantToBranchAmbiguous() {
        List<String> hashes = Arrays.asList(this.c5, this.c4);
        NessieError error = AbstractRelativeReferences.expectError(this.outer.prepareTransplantV2("base@*2023-01-01T00:00:00.000Z", "etl2", hashes, 2), 400);
        this.checkError(error, ErrorCode.BAD_REQUEST, "Expected hash must contain a starting commit ID.");
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    public void transplantToBranchHead() {
        List<String> hashes = Arrays.asList(this.c5, this.c4);
        NessieError error = AbstractRelativeReferences.expectError(this.outer.prepareTransplantV2("base", "etl2", hashes, 2), 400);
        this.checkError(error, ErrorCode.BAD_REQUEST, "Expected hash must be provided.");
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    public void transplantToTagUnambiguous() {
        List<String> hashes = Arrays.asList(this.c3, this.c4, this.c5);
        NessieError error = AbstractRelativeReferences.expectError(this.outer.prepareTransplantV2("tag1@" + this.c4 + "~1", "etl2", hashes, 2), 400);
        this.checkError(error, ErrorCode.BAD_REQUEST, "Reference to transplant into must be a branch.");
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    public void transplantToTagAmbiguous() {
        List<String> hashes = Arrays.asList(this.c5, this.c4);
        NessieError error = AbstractRelativeReferences.expectError(this.outer.prepareTransplantV2("tag1@~1", "etl2", hashes, 2), 400);
        this.checkError(error, ErrorCode.BAD_REQUEST, "Reference to transplant into must be a branch.");
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    public void transplantToTagHead() {
        List<String> hashes = Arrays.asList(this.c5, this.c4);
        NessieError error = AbstractRelativeReferences.expectError(this.outer.prepareTransplantV2("tag1", "etl2", hashes, 2), 400);
        this.checkError(error, ErrorCode.BAD_REQUEST, "Reference to transplant into must be a branch.");
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    public void transplantToDetachedUnambiguous() {
        List<String> hashes = Arrays.asList(this.c3, this.c4, this.c5);
        NessieError error = AbstractRelativeReferences.expectError(this.outer.prepareTransplantV2("@" + this.c5 + "~1", "etl2", hashes, 2), 400);
        this.checkError(error, ErrorCode.BAD_REQUEST, "Reference to transplant into must be a branch.");
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    public void transplantToDetachedAmbiguous() {
        List<String> hashes = Arrays.asList(this.c5, this.c4);
        NessieError error = AbstractRelativeReferences.expectError(this.outer.prepareTransplantV2("@*2023-01-01T00:00:00.000Z", "etl2", hashes, 2), 400);
        this.checkError(error, ErrorCode.BAD_REQUEST, "Reference to transplant into must be a branch.");
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    void getSeveralContentsUnambiguous() {
        Stream<ContentKey> keys = AbstractRelativeReferences.expectContents((Response)BaseTestNessieRest.rest().queryParam("key", new Object[]{this.key1.toPathString(), this.key2.toPathString()}).get("trees/base@{hash}/contents", new Object[]{this.c2 + "~1"}));
        Assertions.assertThat(keys).containsOnly((Object[])new ContentKey[]{this.key1});
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    void getSeveralContentsUnambiguousDetached() {
        Stream<ContentKey> keys = AbstractRelativeReferences.expectContents((Response)BaseTestNessieRest.rest().queryParam("key", new Object[]{this.key1.toPathString(), this.key2.toPathString()}).get("trees/@{hash}/contents", new Object[]{this.c3 + "~1"}));
        Assertions.assertThat(keys).containsOnly((Object[])new ContentKey[]{this.key1, this.key2});
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    void getSeveralContentsAmbiguous() {
        Stream<ContentKey> keys = AbstractRelativeReferences.expectContents((Response)BaseTestNessieRest.rest().queryParam("key", new Object[]{this.key1.toPathString(), this.key2.toPathString()}).get("trees/base@{hash}/contents", new Object[]{"~1"}));
        Assertions.assertThat(keys).containsOnly((Object[])new ContentKey[]{this.key1});
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    void getSeveralContentsAmbiguousDetached() {
        NessieError error = AbstractRelativeReferences.expectError((Response)BaseTestNessieRest.rest().queryParam("key", new Object[]{this.key1.toPathString(), this.key2.toPathString()}).get("trees/@{hash}/contents", new Object[]{"~1"}), 400);
        this.checkError(error, ErrorCode.BAD_REQUEST, "Expected hash must contain a starting commit ID.");
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    void getMultipleContentsUnambiguous() {
        Stream<ContentKey> keys = AbstractRelativeReferences.expectContents((Response)BaseTestNessieRest.rest().body((Object)GetMultipleContentsRequest.of((ContentKey[])new ContentKey[]{this.key1, this.key2})).post("trees/base@{hash}/contents", new Object[]{this.c2 + "~1"}));
        Assertions.assertThat(keys).containsOnly((Object[])new ContentKey[]{this.key1});
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    void getMultipleContentsUnambiguousDetached() {
        Stream<ContentKey> keys = AbstractRelativeReferences.expectContents((Response)BaseTestNessieRest.rest().body((Object)GetMultipleContentsRequest.of((ContentKey[])new ContentKey[]{this.key1, this.key2})).post("trees/@{hash}/contents", new Object[]{this.c3 + "~1"}));
        Assertions.assertThat(keys).containsOnly((Object[])new ContentKey[]{this.key1, this.key2});
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    void getMultipleContentsAmbiguous() {
        Stream<ContentKey> keys = AbstractRelativeReferences.expectContents((Response)BaseTestNessieRest.rest().body((Object)GetMultipleContentsRequest.of((ContentKey[])new ContentKey[]{this.key1, this.key2})).post("trees/base@{hash}/contents", new Object[]{"~1"}));
        Assertions.assertThat(keys).containsOnly((Object[])new ContentKey[]{this.key1});
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    void getMultipleContentsAmbiguousDetached() {
        NessieError error = AbstractRelativeReferences.expectError((Response)BaseTestNessieRest.rest().body((Object)GetMultipleContentsRequest.of((ContentKey[])new ContentKey[]{this.key1, this.key2})).post("trees/@{hash}/contents", new Object[]{"~1"}), 400);
        this.checkError(error, ErrorCode.BAD_REQUEST, "Expected hash must contain a starting commit ID.");
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    void getContentUnambiguous() {
        IcebergTable content = AbstractRelativeReferences.expectContent((Response)BaseTestNessieRest.rest().get("trees/base@{hash}/contents/{key}", new Object[]{this.c2 + "~1", this.key1.toPathString()}));
        Assertions.assertThat((int)content.getSpecId()).isEqualTo(this.table1.getSpecId());
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    void getContentUnambiguousDetached() {
        IcebergTable content = AbstractRelativeReferences.expectContent((Response)BaseTestNessieRest.rest().get("trees/@{hash}/contents/{key}", new Object[]{this.c3 + "~1", this.key2.toPathString()}));
        Assertions.assertThat((int)content.getSpecId()).isEqualTo(this.table2.getSpecId());
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    void getContentAmbiguous() {
        IcebergTable content = AbstractRelativeReferences.expectContent((Response)BaseTestNessieRest.rest().get("trees/base@{hash}/contents/{key}", new Object[]{"~1", this.key1.toPathString()}));
        Assertions.assertThat((int)content.getSpecId()).isEqualTo(this.table1.getSpecId());
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    void getContentAmbiguousDetached() {
        NessieError error = AbstractRelativeReferences.expectError((Response)BaseTestNessieRest.rest().get("trees/@{hash}/contents/{key}", new Object[]{"~1", this.key1.toPathString()}), 400);
        this.checkError(error, ErrorCode.BAD_REQUEST, "Expected hash must contain a starting commit ID.");
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    void getEntriesUnambiguous() {
        Stream<ContentKey> keys = AbstractRelativeReferences.expectEntries((Response)BaseTestNessieRest.rest().queryParam("key", new Object[]{this.key1.toPathString(), this.key2.toPathString()}).get("trees/base@{hash}/entries", new Object[]{this.c2 + "~1"}));
        Assertions.assertThat(keys).containsOnly((Object[])new ContentKey[]{this.key1});
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    void getEntriesUnambiguousDetached() {
        Stream<ContentKey> keys = AbstractRelativeReferences.expectEntries((Response)BaseTestNessieRest.rest().queryParam("key", new Object[]{this.key1.toPathString(), this.key2.toPathString()}).get("trees/@{hash}/entries", new Object[]{this.c3 + "~1"}));
        Assertions.assertThat(keys).containsOnly((Object[])new ContentKey[]{this.key1, this.key2});
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    void getEntriesAmbiguous() {
        Stream<ContentKey> keys = AbstractRelativeReferences.expectEntries((Response)BaseTestNessieRest.rest().queryParam("key", new Object[]{this.key1.toPathString(), this.key2.toPathString()}).get("trees/base@{hash}/entries", new Object[]{"~1"}));
        Assertions.assertThat(keys).containsOnly((Object[])new ContentKey[]{this.key1});
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    void getEntriesAmbiguousDetached() {
        NessieError error = AbstractRelativeReferences.expectError((Response)BaseTestNessieRest.rest().queryParam("key", new Object[]{this.key1.toPathString(), this.key2.toPathString()}).get("trees/@{hash}/entries", new Object[]{"~1"}), 400);
        this.checkError(error, ErrorCode.BAD_REQUEST, "Expected hash must contain a starting commit ID.");
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    void getCommitLogYoungestHashUnambiguous() {
        Stream<String> hashes = AbstractRelativeReferences.expectCommitLog((Response)BaseTestNessieRest.rest().get("trees/base@{hash}/history", new Object[]{this.c2 + "~1"}));
        Assertions.assertThat(hashes).containsExactly((Object[])new String[]{this.c1});
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    void getCommitLogYoungestHashUnambiguousDetached() {
        Stream<String> hashes = AbstractRelativeReferences.expectCommitLog((Response)BaseTestNessieRest.rest().get("trees/@{hash}/history", new Object[]{this.c3 + "~1"}));
        Assertions.assertThat(hashes).containsExactly((Object[])new String[]{this.c2, this.c1});
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    void getCommitLogYoungestHashAmbiguous() {
        Stream<String> hashes = AbstractRelativeReferences.expectCommitLog((Response)BaseTestNessieRest.rest().get("trees/base@{hash}/history", new Object[]{"~1"}));
        Assertions.assertThat(hashes).containsExactly((Object[])new String[]{this.c1});
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    void getCommitLogYoungestHashAmbiguousDetached() {
        NessieError error = AbstractRelativeReferences.expectError((Response)BaseTestNessieRest.rest().get("trees/@{hash}/history", new Object[]{"~1"}), 400);
        this.checkError(error, ErrorCode.BAD_REQUEST, "Youngest hash must contain a starting commit ID.");
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    void getCommitLogOldestHashUnambiguous() {
        Stream<String> hashes = AbstractRelativeReferences.expectCommitLog((Response)BaseTestNessieRest.rest().queryParam("limit-hash", new Object[]{this.c4 + "~1"}).get("trees/etl2/history", new Object[0]));
        Assertions.assertThat(hashes).containsExactly((Object[])new String[]{this.c5, this.c4, this.c3});
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    void getCommitLogOldestHashUnambiguousDetached() {
        Stream<String> hashes = AbstractRelativeReferences.expectCommitLog((Response)BaseTestNessieRest.rest().queryParam("limit-hash", new Object[]{this.c4 + "~1"}).get("trees/@{hash}/history", new Object[]{this.c5}));
        Assertions.assertThat(hashes).containsExactly((Object[])new String[]{this.c5, this.c4, this.c3});
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    void getCommitLogOldestHashAmbiguous() {
        Stream<String> hashes = AbstractRelativeReferences.expectCommitLog((Response)BaseTestNessieRest.rest().queryParam("limit-hash", new Object[]{"~2"}).get("trees/etl2/history", new Object[0]));
        Assertions.assertThat(hashes).containsExactly((Object[])new String[]{this.c5, this.c4, this.c3});
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    void getCommitLogOldestHashAmbiguousDetached() {
        NessieError error = AbstractRelativeReferences.expectError((Response)BaseTestNessieRest.rest().queryParam("limit-hash", new Object[]{"~2"}).get("trees/@{hash}/history", new Object[]{this.c5}), 400);
        this.checkError(error, ErrorCode.BAD_REQUEST, "Oldest hash must contain a starting commit ID.");
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    void getDiffFromRefToRefUnambiguous() {
        Stream<ContentKey> keys = AbstractRelativeReferences.expectDiff((Response)BaseTestNessieRest.rest().get("trees/etl1@{from}/diff/base@{to}", new Object[]{this.c3 + "~1", this.c2 + "~2"}));
        Assertions.assertThat(keys).containsOnly((Object[])new ContentKey[]{this.key1, this.key2});
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    void getDiffFromRefToRefAmbiguous() {
        Stream<ContentKey> keys = AbstractRelativeReferences.expectDiff((Response)BaseTestNessieRest.rest().get("trees/etl1@{from}/diff/base@{to}", new Object[]{"~1", "~2"}));
        Assertions.assertThat(keys).containsOnly((Object[])new ContentKey[]{this.key1, this.key2});
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    void getDiffFromRefToRefUnambiguousDetached() {
        Stream<ContentKey> keys = AbstractRelativeReferences.expectDiff((Response)BaseTestNessieRest.rest().get("trees/@{from}/diff/@{to}", new Object[]{this.c3 + "~1", this.c2 + "~2"}));
        Assertions.assertThat(keys).containsOnly((Object[])new ContentKey[]{this.key1, this.key2});
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    void getDiffFromRefAmbiguousDetached() {
        NessieError error = AbstractRelativeReferences.expectError((Response)BaseTestNessieRest.rest().get("trees/@{from}/diff/base@{to}", new Object[]{"~1", "~2"}), 400);
        this.checkError(error, ErrorCode.BAD_REQUEST, "\"From\" hash must contain a starting commit ID.");
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    void getDiffToRefAmbiguousDetached() {
        NessieError error = AbstractRelativeReferences.expectError((Response)BaseTestNessieRest.rest().get("trees/base@{from}/diff/@{to}", new Object[]{"~1", "~2"}), 400);
        this.checkError(error, ErrorCode.BAD_REQUEST, "\"To\" hash must contain a starting commit ID.");
    }

    private static Branch expectBranch(Response base) {
        return (Branch)((SingleReferenceResponse)((ValidatableResponse)((ValidatableResponse)base.then()).statusCode(200)).extract().as(SingleReferenceResponse.class)).getReference();
    }

    private static Tag expectTag(Response base) {
        return (Tag)((SingleReferenceResponse)((ValidatableResponse)((ValidatableResponse)base.then()).statusCode(200)).extract().as(SingleReferenceResponse.class)).getReference();
    }

    private static MergeResponse expectMerge(ValidatableResponse etl2) {
        return (MergeResponse)((ValidatableResponse)etl2.statusCode(200)).extract().as(MergeResponse.class);
    }

    private static Stream<ContentKey> expectContents(Response key) {
        return ((GetMultipleContentsResponse)((ValidatableResponse)((ValidatableResponse)key.then()).statusCode(200)).extract().as(GetMultipleContentsResponse.class)).getContents().stream().map(GetMultipleContentsResponse.ContentWithKey::getKey);
    }

    private static IcebergTable expectContent(Response response) {
        return (IcebergTable)((ContentResponse)((ValidatableResponse)((ValidatableResponse)response.then()).statusCode(200)).extract().as(ContentResponse.class)).getContent();
    }

    private static Stream<ContentKey> expectEntries(Response key) {
        return ((EntriesResponse)((ValidatableResponse)((ValidatableResponse)key.then()).statusCode(200)).extract().as(EntriesResponse.class)).getEntries().stream().map(EntriesResponse.Entry::getName);
    }

    private static Stream<String> expectCommitLog(Response c2) {
        return ((LogResponse)((ValidatableResponse)((ValidatableResponse)c2.then()).statusCode(200)).extract().as(LogResponse.class)).getLogEntries().stream().map(LogResponse.LogEntry::getCommitMeta).map(CommitMeta::getHash);
    }

    private static Stream<ContentKey> expectDiff(Response response) {
        return ((DiffResponse)((ValidatableResponse)((ValidatableResponse)response.then()).statusCode(200)).extract().as(DiffResponse.class)).getDiffs().stream().map(DiffResponse.DiffEntry::getKey);
    }

    private static NessieError expectError(Response response, int expectedStatusCode) {
        return AbstractRelativeReferences.expectError((ValidatableResponse)response.then(), expectedStatusCode);
    }

    private static NessieError expectError(ValidatableResponse response, int expectedStatusCode) {
        return (NessieError)((ValidatableResponse)response.statusCode(expectedStatusCode)).extract().as(NessieError.class);
    }

    private void checkMerge(MergeResponse response, String commonAncestor, String effectiveTargetHash) {
        this.outer.soft.assertThat(response.getCommonAncestor()).isEqualTo(commonAncestor);
        this.outer.soft.assertThat(response.getEffectiveTargetHash()).isEqualTo(effectiveTargetHash);
    }

    private void checkError(NessieError error, ErrorCode code, String msg) {
        this.outer.soft.assertThat((Comparable)error.getErrorCode()).isEqualTo((Object)code);
        this.outer.soft.assertThat(error.getMessage()).contains(new CharSequence[]{msg});
    }
}

