/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.jaxrs.tests;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.hash.Hashing;
import jakarta.validation.constraints.NotNull;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.SoftAssertions;
import org.assertj.core.groups.Tuple;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.projectnessie.client.api.AssignBranchBuilder;
import org.projectnessie.client.api.AssignReferenceBuilder;
import org.projectnessie.client.api.AssignTagBuilder;
import org.projectnessie.client.api.CommitMultipleOperationsBuilder;
import org.projectnessie.client.api.CreateNamespaceBuilder;
import org.projectnessie.client.api.CreateNamespaceResult;
import org.projectnessie.client.api.DeleteBranchBuilder;
import org.projectnessie.client.api.DeleteNamespaceBuilder;
import org.projectnessie.client.api.DeleteNamespaceResult;
import org.projectnessie.client.api.DeleteReferenceBuilder;
import org.projectnessie.client.api.DeleteTagBuilder;
import org.projectnessie.client.api.GetAllReferencesBuilder;
import org.projectnessie.client.api.GetCommitLogBuilder;
import org.projectnessie.client.api.GetContentBuilder;
import org.projectnessie.client.api.GetDiffBuilder;
import org.projectnessie.client.api.GetEntriesBuilder;
import org.projectnessie.client.api.GetMultipleNamespacesBuilder;
import org.projectnessie.client.api.GetNamespaceBuilder;
import org.projectnessie.client.api.MergeReferenceBuilder;
import org.projectnessie.client.api.NessieApiV1;
import org.projectnessie.client.api.NessieApiV2;
import org.projectnessie.client.api.TransplantCommitsBuilder;
import org.projectnessie.client.api.UpdateNamespaceBuilder;
import org.projectnessie.client.api.UpdateNamespaceResult;
import org.projectnessie.client.ext.NessieApiVersion;
import org.projectnessie.client.ext.NessieApiVersions;
import org.projectnessie.client.ext.NessieClientFactory;
import org.projectnessie.error.BaseNessieClientServerException;
import org.projectnessie.error.ContentKeyErrorDetails;
import org.projectnessie.error.ErrorCode;
import org.projectnessie.error.NessieBadRequestException;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieContentNotFoundException;
import org.projectnessie.error.NessieNamespaceNotEmptyException;
import org.projectnessie.error.NessieNamespaceNotFoundException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.error.NessieReferenceConflictException;
import org.projectnessie.error.ReferenceConflicts;
import org.projectnessie.model.Branch;
import org.projectnessie.model.CommitConsistency;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.CommitResponse;
import org.projectnessie.model.Conflict;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.ContentResponse;
import org.projectnessie.model.DiffResponse;
import org.projectnessie.model.EntriesResponse;
import org.projectnessie.model.FetchOption;
import org.projectnessie.model.GarbageCollectorConfig;
import org.projectnessie.model.GetMultipleContentsResponse;
import org.projectnessie.model.GetNamespacesResponse;
import org.projectnessie.model.IcebergTable;
import org.projectnessie.model.IcebergView;
import org.projectnessie.model.ImmutableGarbageCollectorConfig;
import org.projectnessie.model.ImmutableIcebergTable;
import org.projectnessie.model.ImmutableReferenceMetadata;
import org.projectnessie.model.LogResponse;
import org.projectnessie.model.MergeResponse;
import org.projectnessie.model.Namespace;
import org.projectnessie.model.NessieConfiguration;
import org.projectnessie.model.Operation;
import org.projectnessie.model.Reference;
import org.projectnessie.model.ReferenceHistoryResponse;
import org.projectnessie.model.ReferenceHistoryState;
import org.projectnessie.model.ReferenceMetadata;
import org.projectnessie.model.ReferencesResponse;
import org.projectnessie.model.RepositoryConfig;
import org.projectnessie.model.Tag;
import org.projectnessie.model.types.GenericRepositoryConfig;
import org.projectnessie.model.types.ImmutableGenericRepositoryConfig;

@org.junit.jupiter.api.Tag(value="nessie-multi-env")
@NessieApiVersions
public abstract class BaseTestNessieApi {
    public static final String EMPTY = Hashing.sha256().hashString((CharSequence)"empty", StandardCharsets.UTF_8).toString();
    private NessieApiV1 api;
    private NessieApiVersion apiVersion;
    protected final SoftAssertions soft = new SoftAssertions();

    @BeforeEach
    void initApi(NessieClientFactory clientFactory) {
        this.api = clientFactory.make();
        this.apiVersion = clientFactory.apiVersion();
    }

    @NotNull
    public NessieApiV1 api() {
        return this.api;
    }

    public NessieApiV2 apiV2() {
        Preconditions.checkState((boolean)(this.api instanceof NessieApiV2), (Object)"Not using API v2");
        return (NessieApiV2)this.api;
    }

    public boolean isV2() {
        return NessieApiVersion.V2 == this.apiVersion;
    }

    @AfterEach
    public void tearDown() throws Exception {
        try {
            this.soft.assertAll();
        }
        finally {
            Branch defaultBranch = this.api.getDefaultBranch();
            ((AssignBranchBuilder)this.api().assignBranch().branch(defaultBranch)).assignTo((Reference)Branch.of((String)defaultBranch.getName(), (String)EMPTY)).assign();
            this.api.getAllReferences().stream().forEach(ref -> {
                try {
                    if (ref instanceof Branch && !ref.getName().equals(defaultBranch.getName())) {
                        ((DeleteBranchBuilder)this.api.deleteBranch().branch((Branch)ref)).delete();
                    } else if (ref instanceof Tag) {
                        ((DeleteTagBuilder)this.api.deleteTag().tag((Tag)ref)).delete();
                    }
                }
                catch (NessieConflictException | NessieNotFoundException e) {
                    throw new RuntimeException(e);
                }
            });
            this.api.close();
        }
    }

    protected <R extends Reference> R createReference(R reference, String sourceRefName) throws NessieConflictException, NessieNotFoundException {
        return (R)this.api().createReference().sourceRefName(sourceRefName).reference(reference).create();
    }

    protected CommitMultipleOperationsBuilder prepCommit(Branch branch, String msg, Operation ... operations) {
        return ((CommitMultipleOperationsBuilder)this.api().commitMultipleOperations().branch(branch)).commitMeta(CommitMeta.fromMessage((String)msg)).operations(Arrays.asList(operations));
    }

    protected Operation.Put dummyPut(String ... elements) {
        return Operation.Put.of((ContentKey)ContentKey.of((String[])elements), (Content)BaseTestNessieApi.dummyTable());
    }

    private static IcebergTable dummyTable() {
        return IcebergTable.of((String)"foo", (long)1L, (int)2, (int)3, (int)4);
    }

    @Test
    public void config() throws NessieNotFoundException {
        NessieConfiguration config = this.api().getConfig();
        this.soft.assertThat((Object)config).extracting(new Function[]{NessieConfiguration::getDefaultBranch, NessieConfiguration::getMaxSupportedApiVersion}).containsExactly(new Object[]{"main", 2});
        if (this.isV2()) {
            this.soft.assertThat(config.getNoAncestorHash()).isNotNull();
        }
        this.soft.assertThat((Object)this.api().getDefaultBranch()).extracting(new Function[]{Branch::getName, Branch::getHash}).containsExactly(new Object[]{config.getDefaultBranch(), EMPTY});
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    public void specVersion() {
        NessieConfiguration config = this.api().getConfig();
        this.soft.assertThat(config.getSpecVersion()).isNotEmpty();
    }

    @Test
    public void references() throws Exception {
        Branch branchAssigned;
        Branch main = this.api().getDefaultBranch();
        this.soft.assertThat(this.api().getAllReferences().get().getReferences()).containsExactly((Object[])new Reference[]{main});
        Branch main1 = this.prepCommit(main, "commit", new Operation[]{Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{"key"}), (Content)Namespace.of((String[])new String[]{"key"})), this.dummyPut("key", "foo")}).commit();
        CommitMeta commitMetaMain = ((LogResponse.LogEntry)((GetCommitLogBuilder)this.api().getCommitLog().reference((Reference)main1)).get().getLogEntries().get(0)).getCommitMeta();
        Tag tag = this.createReference(Tag.of((String)"tag1", (String)main1.getHash()), main.getName());
        Branch branch = this.createReference(Branch.of((String)"branch1", (String)main1.getHash()), main.getName());
        Branch branch1 = this.prepCommit(branch, "branch", new Operation[]{this.dummyPut("key", "bar")}).commit();
        CommitMeta commitMetaBranch = ((LogResponse.LogEntry)((GetCommitLogBuilder)this.api().getCommitLog().reference((Reference)branch1)).get().getLogEntries().get(0)).getCommitMeta();
        this.soft.assertThat(this.api().getAllReferences().get().getReferences()).containsExactlyInAnyOrder((Object[])new Reference[]{main1, tag, branch1});
        this.soft.assertThat((Object)this.api().getReference().refName(main.getName()).get()).isEqualTo((Object)main1);
        this.soft.assertThat((Object)this.api().getReference().refName(tag.getName()).get()).isEqualTo((Object)tag);
        this.soft.assertThat((Object)this.api().getReference().refName(branch.getName()).get()).isEqualTo((Object)branch1);
        Branch mainFull = Branch.of((String)main.getName(), (String)main1.getHash(), (ReferenceMetadata)ImmutableReferenceMetadata.builder().numTotalCommits(Long.valueOf(1L)).commitMetaOfHEAD(commitMetaMain).build());
        Branch branchFull = Branch.of((String)branch.getName(), (String)branch1.getHash(), (ReferenceMetadata)ImmutableReferenceMetadata.builder().numTotalCommits(Long.valueOf(2L)).numCommitsAhead(Integer.valueOf(1)).numCommitsBehind(Integer.valueOf(0)).commonAncestorHash(main1.getHash()).commitMetaOfHEAD(commitMetaBranch).build());
        Tag tagFull = Tag.of((String)tag.getName(), (String)tag.getHash(), (ReferenceMetadata)ImmutableReferenceMetadata.builder().numTotalCommits(Long.valueOf(1L)).commitMetaOfHEAD(commitMetaMain).build());
        this.soft.assertThat(this.api().getAllReferences().fetch(FetchOption.ALL).get().getReferences()).containsExactlyInAnyOrder((Object[])new Reference[]{mainFull, branchFull, tagFull});
        this.soft.assertThat((Object)this.api().getReference().refName(main.getName()).fetch(FetchOption.ALL).get()).isEqualTo((Object)mainFull);
        this.soft.assertThat((Object)this.api().getReference().refName(tag.getName()).fetch(FetchOption.ALL).get()).isEqualTo((Object)tagFull);
        this.soft.assertThat((Object)this.api().getReference().refName(branch.getName()).fetch(FetchOption.ALL).get()).isEqualTo((Object)branchFull);
        if (this.isV2()) {
            tag = ((AssignTagBuilder)this.api.assignTag().tag(tag)).assignTo((Reference)main).assignAndGet();
            this.soft.assertThat((Object)tag).isEqualTo((Object)Tag.of((String)tag.getName(), (String)main.getHash()));
        } else {
            ((AssignTagBuilder)this.api.assignTag().tag(tag)).assignTo((Reference)main).assign();
            tag = Tag.of((String)tag.getName(), (String)main.getHash());
        }
        AbstractThrowableAssert assignConflict = this.isV2() ? this.soft.assertThatThrownBy(() -> ((AssignBranchBuilder)this.api.assignBranch().branch(branch)).assignTo((Reference)main).assignAndGet()) : this.soft.assertThatThrownBy(() -> ((AssignBranchBuilder)this.api.assignBranch().branch(branch)).assignTo((Reference)main).assign());
        ((ListAssert)((ObjectAssert)((AbstractThrowableAssert)assignConflict.isInstanceOf(NessieReferenceConflictException.class)).asInstanceOf(InstanceOfAssertFactories.type(NessieReferenceConflictException.class))).extracting(NessieReferenceConflictException::getErrorDetails).extracting(ReferenceConflicts::conflicts, InstanceOfAssertFactories.list(Conflict.class))).extracting(Conflict::conflictType).containsExactly((Object[])new Conflict.ConflictType[]{Conflict.ConflictType.UNEXPECTED_HASH});
        if (this.isV2()) {
            branchAssigned = ((AssignBranchBuilder)this.api.assignBranch().branch(branch1)).assignTo((Reference)main).assignAndGet();
            this.soft.assertThat((Object)branchAssigned).isEqualTo((Object)Branch.of((String)branch.getName(), (String)main.getHash()));
        } else {
            ((AssignBranchBuilder)this.api.assignBranch().branch(branch1)).assignTo((Reference)main).assign();
            branchAssigned = Branch.of((String)branch.getName(), (String)main.getHash());
        }
        this.soft.assertThat(this.api().getAllReferences().get().getReferences()).containsExactlyInAnyOrder((Object[])new Reference[]{main1, tag, branchAssigned});
        this.soft.assertThat((Object)this.api().getReference().refName(main.getName()).get()).isEqualTo((Object)main1);
        this.soft.assertThat((Object)this.api().getReference().refName(tag.getName()).get()).isEqualTo((Object)tag);
        this.soft.assertThat((Object)this.api().getReference().refName(branch.getName()).get()).isEqualTo((Object)branchAssigned);
        if (this.isV2()) {
            Tag deleted = ((DeleteTagBuilder)this.api().deleteTag().tag(tag)).getAndDelete();
            this.soft.assertThat((Object)deleted).isEqualTo((Object)tag);
        } else {
            ((DeleteTagBuilder)this.api().deleteTag().tag(tag)).delete();
        }
        AbstractThrowableAssert deleteConflict = this.isV2() ? this.soft.assertThatThrownBy(() -> ((DeleteBranchBuilder)this.api().deleteBranch().branch(branch)).getAndDelete()) : this.soft.assertThatThrownBy(() -> ((DeleteBranchBuilder)this.api().deleteBranch().branch(branch)).delete());
        ((ListAssert)((ObjectAssert)((AbstractThrowableAssert)deleteConflict.isInstanceOf(NessieReferenceConflictException.class)).asInstanceOf(InstanceOfAssertFactories.type(NessieReferenceConflictException.class))).extracting(NessieReferenceConflictException::getErrorDetails).extracting(ReferenceConflicts::conflicts, InstanceOfAssertFactories.list(Conflict.class))).extracting(Conflict::conflictType).containsExactly((Object[])new Conflict.ConflictType[]{Conflict.ConflictType.UNEXPECTED_HASH});
        if (this.isV2()) {
            Branch deleted = ((DeleteBranchBuilder)this.api().deleteBranch().branch(branchAssigned)).getAndDelete();
            this.soft.assertThat((Object)deleted).isEqualTo((Object)branchAssigned);
        } else {
            ((DeleteBranchBuilder)this.api().deleteBranch().branch(branchAssigned)).delete();
        }
        this.soft.assertThat(this.api().getAllReferences().get().getReferences()).containsExactlyInAnyOrder((Object[])new Reference[]{main1});
        this.soft.assertThat((Object)this.api().getReference().refName(main.getName()).get()).isEqualTo((Object)main1);
        this.soft.assertThatThrownBy(() -> this.createReference(Tag.of((String)"tag2", null), main.getName())).isInstanceOf(NessieBadRequestException.class);
        this.soft.assertThatThrownBy(() -> this.createReference(Branch.of((String)"branch2", null), main.getName())).isInstanceOf(NessieBadRequestException.class);
        String refName = "does-not-exist";
        this.soft.assertThatThrownBy(() -> this.api().getReference().refName(refName).get()).isInstanceOf(NessieNotFoundException.class);
        this.soft.assertThatThrownBy(() -> ((AssignBranchBuilder)this.api().assignBranch().branch(Branch.of((String)refName, (String)main.getHash()))).assignTo((Reference)main).assign()).isInstanceOf(NessieNotFoundException.class);
        this.soft.assertThatThrownBy(() -> ((AssignTagBuilder)this.api().assignTag().tag(Tag.of((String)refName, (String)main.getHash()))).assignTo((Reference)main).assign()).isInstanceOf(NessieNotFoundException.class);
        this.soft.assertThatThrownBy(() -> ((DeleteBranchBuilder)this.api().deleteBranch().branch(Branch.of((String)refName, (String)main.getHash()))).delete()).isInstanceOf(NessieNotFoundException.class);
        this.soft.assertThatThrownBy(() -> ((DeleteTagBuilder)this.api().deleteTag().tag(Tag.of((String)refName, (String)main.getHash()))).delete()).isInstanceOf(NessieNotFoundException.class);
        if (this.isV2()) {
            this.soft.assertThatThrownBy(() -> ((AssignBranchBuilder)this.api().assignBranch().branch(Branch.of((String)refName, (String)main.getHash()))).assignTo((Reference)main).assignAndGet()).isInstanceOf(NessieNotFoundException.class);
            this.soft.assertThatThrownBy(() -> ((AssignTagBuilder)this.api().assignTag().tag(Tag.of((String)refName, (String)main.getHash()))).assignTo((Reference)main).assignAndGet()).isInstanceOf(NessieNotFoundException.class);
            this.soft.assertThatThrownBy(() -> ((DeleteBranchBuilder)this.api().deleteBranch().branch(Branch.of((String)refName, (String)main.getHash()))).getAndDelete()).isInstanceOf(NessieNotFoundException.class);
            this.soft.assertThatThrownBy(() -> ((DeleteTagBuilder)this.api().deleteTag().tag(Tag.of((String)refName, (String)main.getHash()))).getAndDelete()).isInstanceOf(NessieNotFoundException.class);
        }
    }

    @ParameterizedTest
    @EnumSource(value=Reference.ReferenceType.class)
    @NessieApiVersions(versions={NessieApiVersion.V2})
    public void referencesUntyped(Reference.ReferenceType referenceType) throws Exception {
        Reference.ReferenceType anotherType;
        Tag ref0;
        Branch main = this.api().getDefaultBranch();
        this.soft.assertThat(this.api().getAllReferences().get().getReferences()).containsExactly((Object[])new Reference[]{main});
        Branch main1 = this.prepCommit(main, "commit", new Operation[]{Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{"key"}), (Content)Namespace.of((String[])new String[]{"key"})), this.dummyPut("key", "foo")}).commit();
        switch (referenceType) {
            case TAG: {
                ref0 = Tag.of((String)"tag1", (String)main.getHash());
                anotherType = Reference.ReferenceType.BRANCH;
                break;
            }
            case BRANCH: {
                ref0 = Branch.of((String)"branch1", (String)main.getHash());
                anotherType = Reference.ReferenceType.TAG;
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported ref type: " + referenceType);
            }
        }
        Tag ref = this.createReference(ref0, main.getName());
        ((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> this.lambda$referencesUntyped$16((Reference)ref0, main1)).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Expected hash must be provided");
        ((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> this.lambda$referencesUntyped$17((Reference)ref0, anotherType, main1)).isInstanceOf(NessieBadRequestException.class)).hasMessageMatching(".*Expected reference type .+ does not match existing reference.*");
        ref = this.apiV2().assignReference().reference((Reference)ref).assignTo((Reference)main1).assignAndGet();
        this.soft.assertThat((Object)ref).extracting(new Function[]{Reference::getName, Reference::getHash}).containsExactly(new Object[]{ref0.getName(), main1.getHash()});
        ref = ((AssignReferenceBuilder)((AssignReferenceBuilder)this.apiV2().assignReference().refName(ref.getName())).hash(ref.getHash())).assignTo((Reference)main).assignAndGet();
        this.soft.assertThat((Object)ref).extracting(new Function[]{Reference::getName, Reference::getHash}).containsExactly(new Object[]{ref0.getName(), main.getHash()});
        ref = ((AssignReferenceBuilder)((AssignReferenceBuilder)((AssignReferenceBuilder)this.apiV2().assignReference().refName(ref.getName())).hash(ref.getHash())).refType(ref.getType())).assignTo((Reference)main1).assignAndGet();
        this.soft.assertThat((Object)ref).extracting(new Function[]{Reference::getName, Reference::getHash}).containsExactly(new Object[]{ref0.getName(), main1.getHash()});
        AssignReferenceBuilder assignRequest = ((AssignReferenceBuilder)((AssignReferenceBuilder)this.apiV2().assignReference().refName(ref.getName())).hash(ref.getHash())).assignTo((Reference)main1);
        ref = referenceType == Reference.ReferenceType.BRANCH ? assignRequest.asBranch().assignAndGet() : assignRequest.asTag().assignAndGet();
        this.soft.assertThat((Object)ref).extracting(new Function[]{Reference::getName, Reference::getHash}).containsExactly(new Object[]{ref0.getName(), main1.getHash()});
        ((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> this.lambda$referencesUntyped$18((Reference)ref0)).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Expected hash must be provided");
        Reference deleted = (Reference)this.apiV2().deleteReference().reference((Reference)ref).getAndDelete();
        this.soft.assertThat((Object)deleted).isEqualTo((Object)ref);
        ref = this.createReference(ref0, main.getName());
        deleted = (Reference)((DeleteReferenceBuilder)((DeleteReferenceBuilder)this.apiV2().deleteReference().refName(ref.getName())).hash(ref.getHash())).getAndDelete();
        this.soft.assertThat((Object)deleted).isEqualTo((Object)ref);
        ref = this.createReference(ref0, main.getName());
        ((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> this.lambda$referencesUntyped$19((Reference)ref0, anotherType)).isInstanceOf(NessieBadRequestException.class)).hasMessageMatching(".*Expected reference type .+ does not match existing reference.*");
        deleted = (Reference)((DeleteReferenceBuilder)((DeleteReferenceBuilder)((DeleteReferenceBuilder)this.apiV2().deleteReference().refName(ref.getName())).hash(ref.getHash())).refType(ref.getType())).getAndDelete();
        this.soft.assertThat((Object)deleted).isEqualTo((Object)ref);
        ref = this.createReference(ref0, main.getName());
        DeleteReferenceBuilder deleteRequest = (DeleteReferenceBuilder)((DeleteReferenceBuilder)this.apiV2().deleteReference().refName(ref.getName())).hash(ref.getHash());
        deleted = referenceType == Reference.ReferenceType.BRANCH ? (Reference)deleteRequest.asBranch().getAndDelete() : (Reference)deleteRequest.asTag().getAndDelete();
        this.soft.assertThat((Object)deleted).isEqualTo((Object)ref);
    }

    @Test
    public void commitMergeTransplant() throws Exception {
        Reference main2;
        Branch main = this.api().getDefaultBranch();
        main = this.prepCommit(main, "common ancestor", new Operation[]{this.dummyPut("unrelated"), Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{"a"}), (Content)Namespace.of((String[])new String[]{"a"})), Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{"b"}), (Content)Namespace.of((String[])new String[]{"b"}))}).commit();
        main = this.prepCommit(main, "common ancestor", new Operation[]{Operation.Delete.of((ContentKey)ContentKey.of((String[])new String[]{"unrelated"}))}).commit();
        Branch branch = this.createReference(Branch.of((String)"branch", (String)main.getHash()), main.getName());
        Branch otherBranch = this.createReference(Branch.of((String)"other", (String)main.getHash()), main.getName());
        if (this.isV2()) {
            CommitResponse resp = this.prepCommit(branch, "one", new Operation[]{this.dummyPut("a", "a")}).commitWithResponse();
            branch = resp.getTargetBranch();
            this.soft.assertThat(resp.getAddedContents()).hasSize(1);
            resp = this.prepCommit(branch, "two", new Operation[]{this.dummyPut("b", "a"), this.dummyPut("b", "b")}).commitWithResponse();
            branch = resp.getTargetBranch();
            ((ListAssert)this.soft.assertThat(resp.getAddedContents()).hasSize(2)).extracting(CommitResponse.AddedContent::getKey).containsExactlyInAnyOrder((Object[])new ContentKey[]{ContentKey.of((String[])new String[]{"b", "a"}), ContentKey.of((String[])new String[]{"b", "b"})});
            this.soft.assertThat((Object)((IcebergTable)resp.contentWithAssignedId(ContentKey.of((String[])new String[]{"b", "a"}), (Content)BaseTestNessieApi.dummyTable()))).extracting(Content::getId).isNotNull();
            this.soft.assertThat((Object)((IcebergTable)resp.contentWithAssignedId(ContentKey.of((String[])new String[]{"b", "b"}), (Content)BaseTestNessieApi.dummyTable()))).extracting(Content::getId).isNotNull();
            this.soft.assertThat((Object)((IcebergTable)resp.contentWithAssignedId(ContentKey.of((String[])new String[]{"x", "y"}), (Content)BaseTestNessieApi.dummyTable()))).extracting(Content::getId).isNull();
        } else {
            branch = this.prepCommit(branch, "one", new Operation[]{this.dummyPut("a", "a")}).commit();
            branch = this.prepCommit(branch, "two", new Operation[]{this.dummyPut("b", "a"), this.dummyPut("b", "b")}).commit();
        }
        this.soft.assertThat(((GetCommitLogBuilder)this.api().getCommitLog().refName(branch.getName())).get().getLogEntries()).hasSize(4);
        this.soft.assertThat(((GetEntriesBuilder)this.api().getEntries().reference((Reference)branch)).get().getEntries()).extracting(EntriesResponse.Entry::getName).containsExactlyInAnyOrder((Object[])new ContentKey[]{ContentKey.of((String[])new String[]{"a"}), ContentKey.of((String[])new String[]{"b"}), ContentKey.of((String[])new String[]{"a", "a"}), ContentKey.of((String[])new String[]{"b", "a"}), ContentKey.of((String[])new String[]{"b", "b"})});
        this.soft.assertThat(((GetCommitLogBuilder)this.api().getCommitLog().refName(main.getName())).get().getLogEntries()).hasSize(2);
        this.soft.assertThat(((GetEntriesBuilder)this.api().getEntries().reference((Reference)main)).get().getEntries()).extracting(EntriesResponse.Entry::getName).containsExactly((Object[])new ContentKey[]{ContentKey.of((String[])new String[]{"a"}), ContentKey.of((String[])new String[]{"b"})});
        if (this.isV2()) {
            ((MergeReferenceBuilder)((MergeReferenceBuilder)this.api().mergeRefIntoBranch().fromRef((Reference)branch).branch(main)).message("not the merge message").commitMeta((CommitMeta)CommitMeta.builder().message("My custom merge message").author("NessieHerself").signedOffBy("Arctic").authorTime(Instant.EPOCH).putProperties("property", "value").build()).keepIndividualCommits(false)).merge();
            main2 = this.api().getReference().refName(main.getName()).get();
            List postMergeLog = ((GetCommitLogBuilder)this.api().getCommitLog().refName(main.getName())).get().getLogEntries();
            ((ObjectAssert)((ListAssert)this.soft.assertThat(postMergeLog).hasSize(3)).first()).extracting(LogResponse.LogEntry::getCommitMeta).extracting(new Function[]{CommitMeta::getMessage, CommitMeta::getAllAuthors, CommitMeta::getAllSignedOffBy, CommitMeta::getAuthorTime, CommitMeta::getProperties}).containsExactly(new Object[]{"My custom merge message", Collections.singletonList("NessieHerself"), Collections.singletonList("Arctic"), Instant.EPOCH, Collections.singletonMap("property", "value")});
        } else {
            ((MergeReferenceBuilder)((MergeReferenceBuilder)this.api().mergeRefIntoBranch().fromRef((Reference)branch).branch(main)).keepIndividualCommits(false)).merge();
            main2 = this.api().getReference().refName(main.getName()).get();
            this.soft.assertThat(((GetCommitLogBuilder)this.api().getCommitLog().refName(main.getName())).get().getLogEntries()).hasSize(3);
        }
        this.soft.assertThat(((GetEntriesBuilder)this.api().getEntries().reference(main2)).get().getEntries()).extracting(EntriesResponse.Entry::getName).containsExactlyInAnyOrder((Object[])new ContentKey[]{ContentKey.of((String[])new String[]{"a"}), ContentKey.of((String[])new String[]{"b"}), ContentKey.of((String[])new String[]{"a", "a"}), ContentKey.of((String[])new String[]{"b", "a"}), ContentKey.of((String[])new String[]{"b", "b"})});
        this.soft.assertThat(((GetEntriesBuilder)this.api().getEntries().reference((Reference)otherBranch)).get().getEntries()).extracting(EntriesResponse.Entry::getName).containsExactly((Object[])new ContentKey[]{ContentKey.of((String[])new String[]{"a"}), ContentKey.of((String[])new String[]{"b"})});
        ((TransplantCommitsBuilder)((TransplantCommitsBuilder)this.api().transplantCommitsIntoBranch().fromRefName(main.getName())).hashesToTransplant(Collections.singletonList(main2.getHash())).branch(otherBranch)).transplant();
        this.soft.assertThat(((GetEntriesBuilder)this.api().getEntries().refName(otherBranch.getName())).get().getEntries()).extracting(EntriesResponse.Entry::getName).containsExactlyInAnyOrder((Object[])new ContentKey[]{ContentKey.of((String[])new String[]{"a"}), ContentKey.of((String[])new String[]{"b"}), ContentKey.of((String[])new String[]{"a", "a"}), ContentKey.of((String[])new String[]{"b", "a"}), ContentKey.of((String[])new String[]{"b", "b"})});
        this.soft.assertThat(((GetContentBuilder)this.api().getContent().key(ContentKey.of((String[])new String[]{"a", "a"})).key(ContentKey.of((String[])new String[]{"b", "a"})).key(ContentKey.of((String[])new String[]{"b", "b"})).refName(main.getName())).get()).containsKeys((Object[])new ContentKey[]{ContentKey.of((String[])new String[]{"a", "a"}), ContentKey.of((String[])new String[]{"b", "a"}), ContentKey.of((String[])new String[]{"b", "b"})});
    }

    @Test
    public void mergeTransplantDryRunWithConflictInResult() throws Exception {
        Branch main0 = this.prepCommit(this.api().getDefaultBranch(), "common ancestor", new Operation[]{this.dummyPut("common")}).commit();
        Branch branch = this.createReference(Branch.of((String)"branch", (String)main0.getHash()), main0.getName());
        branch = this.prepCommit(branch, "branch", new Operation[]{this.dummyPut("conflictingKey1"), this.dummyPut("branchKey")}).commit();
        Branch main = this.prepCommit(main0, "main", new Operation[]{this.dummyPut("conflictingKey1"), this.dummyPut("mainKey")}).commit();
        ListAssert mergeAssert = this.soft.assertThat(((MergeReferenceBuilder)((MergeReferenceBuilder)((MergeReferenceBuilder)this.api().mergeRefIntoBranch().fromRef((Reference)branch).branch(main)).returnConflictAsResult(true)).dryRun(true)).merge().getDetails());
        if (this.isV2()) {
            mergeAssert.extracting(new Function[]{MergeResponse.ContentKeyDetails::getKey, d -> d.getConflict() != null}).contains((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{ContentKey.of((String[])new String[]{"branchKey"}), false}), Assertions.tuple((Object[])new Object[]{ContentKey.of((String[])new String[]{"conflictingKey1"}), true})});
        } else {
            mergeAssert.extracting(new Function[]{MergeResponse.ContentKeyDetails::getKey, MergeResponse.ContentKeyDetails::getConflictType}).contains((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{ContentKey.of((String[])new String[]{"branchKey"}), MergeResponse.ContentKeyConflict.NONE}), Assertions.tuple((Object[])new Object[]{ContentKey.of((String[])new String[]{"conflictingKey1"}), MergeResponse.ContentKeyConflict.UNRESOLVABLE})});
        }
        this.soft.assertThat((Object)this.api().getReference().refName(main.getName()).get()).isEqualTo((Object)main);
        mergeAssert = this.soft.assertThat(((TransplantCommitsBuilder)((TransplantCommitsBuilder)((TransplantCommitsBuilder)((TransplantCommitsBuilder)this.api().transplantCommitsIntoBranch().fromRefName(branch.getName())).hashesToTransplant(Collections.singletonList(branch.getHash())).branch(main0)).returnConflictAsResult(true)).dryRun(true)).transplant().getDetails());
        if (this.isV2()) {
            mergeAssert.extracting(new Function[]{MergeResponse.ContentKeyDetails::getKey, d -> d.getConflict() != null}).contains((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{ContentKey.of((String[])new String[]{"branchKey"}), false}), Assertions.tuple((Object[])new Object[]{ContentKey.of((String[])new String[]{"conflictingKey1"}), true})});
        } else {
            mergeAssert.extracting(new Function[]{MergeResponse.ContentKeyDetails::getKey, MergeResponse.ContentKeyDetails::getConflictType}).contains((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{ContentKey.of((String[])new String[]{"branchKey"}), MergeResponse.ContentKeyConflict.NONE}), Assertions.tuple((Object[])new Object[]{ContentKey.of((String[])new String[]{"conflictingKey1"}), MergeResponse.ContentKeyConflict.UNRESOLVABLE})});
        }
        this.soft.assertThat((Object)this.api().getReference().refName(main.getName()).get()).isEqualTo((Object)main);
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    public void commitParents() throws Exception {
        Branch main = this.api().getDefaultBranch();
        Branch initialCommit = this.prepCommit(main, "common ancestor", new Operation[]{this.dummyPut("initial")}).commit();
        main = this.prepCommit(main, "common ancestor", new Operation[]{this.dummyPut("test1")}).commit();
        ((ListAssert)((ObjectAssert)this.soft.assertThat(((GetCommitLogBuilder)((GetCommitLogBuilder)this.api().getCommitLog().refName(main.getName())).maxRecords(1)).get().getLogEntries()).map(logEntry -> logEntry.getCommitMeta().getParentCommitHashes()).first()).asInstanceOf(InstanceOfAssertFactories.list(String.class))).containsExactly((Object[])new String[]{initialCommit.getHash()});
        Branch branch = this.createReference(Branch.of((String)"branch", (String)main.getHash()), main.getName());
        branch = this.prepCommit(branch, "one", new Operation[]{Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{"a"}), (Content)Namespace.of((String[])new String[]{"a"})), this.dummyPut("a", "a")}).commit();
        Reference mainParent = this.api().getReference().refName(main.getName()).get();
        ((MergeReferenceBuilder)this.api().mergeRefIntoBranch().fromRef((Reference)branch).branch(main)).merge();
        ((ListAssert)((ObjectAssert)this.soft.assertThat(((GetCommitLogBuilder)((GetCommitLogBuilder)this.api().getCommitLog().refName(main.getName())).maxRecords(1)).get().getLogEntries()).map(logEntry -> logEntry.getCommitMeta().getParentCommitHashes()).first()).asInstanceOf(InstanceOfAssertFactories.list(String.class))).containsExactly((Object[])new String[]{mainParent.getHash(), branch.getHash()});
    }

    @Test
    public void diff() throws Exception {
        Branch main = this.api().getDefaultBranch();
        Branch branch1 = this.createReference(Branch.of((String)"b1", (String)main.getHash()), main.getName());
        Branch branch2 = this.createReference(Branch.of((String)"b2", (String)main.getHash()), main.getName());
        ContentKey key1 = ContentKey.of((String[])new String[]{"1"});
        ContentKey key3 = ContentKey.of((String[])new String[]{"3"});
        ContentKey key4 = ContentKey.of((String[])new String[]{"4"});
        branch1 = this.prepCommit(branch1, "c1", new Operation[]{Operation.Put.of((ContentKey)key1, (Content)Namespace.of((String[])new String[]{"1"})), this.dummyPut("1", "1"), this.dummyPut("1", "2"), this.dummyPut("1", "3")}).commit();
        branch2 = this.prepCommit(branch2, "c2", new Operation[]{Operation.Put.of((ContentKey)key1, (Content)Namespace.of((String[])new String[]{"1"})), Operation.Put.of((ContentKey)key3, (Content)Namespace.of((String[])new String[]{"3"})), Operation.Put.of((ContentKey)key4, (Content)Namespace.of((String[])new String[]{"4"})), this.dummyPut("1", "1"), this.dummyPut("3", "1"), this.dummyPut("4", "1")}).commit();
        ContentKey key11 = ContentKey.of((String[])new String[]{"1", "1"});
        ContentKey key12 = ContentKey.of((String[])new String[]{"1", "2"});
        ContentKey key13 = ContentKey.of((String[])new String[]{"1", "3"});
        ContentKey key31 = ContentKey.of((String[])new String[]{"3", "1"});
        ContentKey key41 = ContentKey.of((String[])new String[]{"4", "1"});
        Map contents1 = ((GetContentBuilder)this.api().getContent().reference((Reference)branch1)).key(key11).key(key12).key(key13).key(key11.getParent()).key(key31.getParent()).key(key41.getParent()).get();
        Map contents2 = ((GetContentBuilder)this.api().getContent().reference((Reference)branch2)).key(key11).key(key31).key(key41).key(key11.getParent()).key(key31.getParent()).key(key41.getParent()).get();
        DiffResponse diff1response = this.api().getDiff().fromRef((Reference)branch1).toRef((Reference)branch2).get();
        List diff1 = diff1response.getDiffs();
        if (this.isV2()) {
            this.soft.assertThat((Object)diff1response.getEffectiveFromReference()).isEqualTo((Object)branch1);
            this.soft.assertThat((Object)diff1response.getEffectiveToReference()).isEqualTo((Object)branch2);
            this.soft.assertThat(((GetDiffBuilder)((GetDiffBuilder)this.api().getDiff().fromRef((Reference)branch1).toRef((Reference)branch2).minKey(key12)).maxKey(key31)).get().getDiffs()).extracting(DiffResponse.DiffEntry::getKey).containsExactlyInAnyOrder((Object[])new ContentKey[]{key12, key13, key3, key31});
            this.soft.assertThat(((GetDiffBuilder)this.api().getDiff().fromRef((Reference)branch1).toRef((Reference)branch2).minKey(key31)).get().getDiffs()).extracting(DiffResponse.DiffEntry::getKey).containsExactlyInAnyOrder((Object[])new ContentKey[]{key31, key4, key41});
            this.soft.assertThat(((GetDiffBuilder)this.api().getDiff().fromRef((Reference)branch1).toRef((Reference)branch2).maxKey(key12)).get().getDiffs()).extracting(DiffResponse.DiffEntry::getKey).containsExactlyInAnyOrder((Object[])new ContentKey[]{key1, key11, key12});
            this.soft.assertThat(((GetDiffBuilder)this.api().getDiff().fromRef((Reference)branch1).toRef((Reference)branch2).key(key12)).get().getDiffs()).extracting(DiffResponse.DiffEntry::getKey).containsExactlyInAnyOrder((Object[])new ContentKey[]{key12});
            this.soft.assertThat(((GetDiffBuilder)((GetDiffBuilder)this.api().getDiff().fromRef((Reference)branch1).toRef((Reference)branch2).key(key31)).key(key12)).get().getDiffs()).extracting(DiffResponse.DiffEntry::getKey).containsExactlyInAnyOrder((Object[])new ContentKey[]{key12, key31});
            this.soft.assertThat(((GetDiffBuilder)this.api().getDiff().fromRef((Reference)branch1).toRef((Reference)branch2).filter("key.namespace=='1'")).get().getDiffs()).extracting(DiffResponse.DiffEntry::getKey).containsExactlyInAnyOrder((Object[])new ContentKey[]{key11, key12, key13});
        }
        this.soft.assertThat(diff1).containsExactlyInAnyOrder((Object[])new DiffResponse.DiffEntry[]{DiffResponse.DiffEntry.diffEntry((ContentKey)key11.getParent(), (Content)((Content)contents1.get(key11.getParent())), (Content)((Content)contents2.get(key11.getParent()))), DiffResponse.DiffEntry.diffEntry((ContentKey)key11, (Content)((Content)contents1.get(key11)), (Content)((Content)contents2.get(key11))), DiffResponse.DiffEntry.diffEntry((ContentKey)key12, (Content)((Content)contents1.get(key12)), null), DiffResponse.DiffEntry.diffEntry((ContentKey)key13, (Content)((Content)contents1.get(key13)), null), DiffResponse.DiffEntry.diffEntry((ContentKey)key31, null, (Content)((Content)contents2.get(key31))), DiffResponse.DiffEntry.diffEntry((ContentKey)key41, null, (Content)((Content)contents2.get(key41))), DiffResponse.DiffEntry.diffEntry((ContentKey)key31.getParent(), null, (Content)((Content)contents2.get(key31.getParent()))), DiffResponse.DiffEntry.diffEntry((ContentKey)key41.getParent(), null, (Content)((Content)contents2.get(key41.getParent())))});
        List diff2 = this.api().getDiff().fromRefName(branch1.getName()).toRef((Reference)branch2).get().getDiffs();
        List diff3 = this.api().getDiff().fromRef((Reference)branch1).toRefName(branch2.getName()).get().getDiffs();
        this.soft.assertThat(diff1).isEqualTo((Object)diff2).isEqualTo((Object)diff3);
        if (this.isV2()) {
            ArrayList all = new ArrayList();
            String token = null;
            for (int i = 0; i < 8; ++i) {
                DiffResponse resp = ((GetDiffBuilder)((GetDiffBuilder)this.api().getDiff().fromRef((Reference)branch1).toRef((Reference)branch2).maxRecords(1)).pageToken(token)).get();
                all.addAll(resp.getDiffs());
                token = resp.getToken();
                if (i == 7) {
                    this.soft.assertThat(token).isNull();
                    continue;
                }
                this.soft.assertThat(token).isNotNull();
            }
            this.soft.assertThat(all).containsExactlyInAnyOrderElementsOf((Iterable)diff1);
            this.soft.assertThat(((GetDiffBuilder)this.api().getDiff().fromRef((Reference)branch1).toRef((Reference)branch2).maxRecords(1)).stream()).containsExactlyInAnyOrderElementsOf((Iterable)diff1);
        }
    }

    @Test
    public void commitLog() throws Exception {
        Branch main = this.api().getDefaultBranch();
        for (int i = 0; i < 10; ++i) {
            main = i == 0 ? this.prepCommit(main, "c-" + i, new Operation[]{Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{"c"}), (Content)Namespace.of((String[])new String[]{"c"})), this.dummyPut("c", Integer.toString(i))}).commit() : this.prepCommit(main, "c-" + i, new Operation[]{this.dummyPut("c", Integer.toString(i))}).commit();
        }
        List notPaged = ((GetCommitLogBuilder)this.api().getCommitLog().reference((Reference)main)).get().getLogEntries();
        this.soft.assertThat(notPaged).hasSize(10);
        ArrayList all = new ArrayList();
        String token = null;
        for (int i = 0; i < 10; ++i) {
            LogResponse resp = ((GetCommitLogBuilder)((GetCommitLogBuilder)((GetCommitLogBuilder)this.api().getCommitLog().reference((Reference)main)).maxRecords(1)).pageToken(token)).get();
            all.addAll(resp.getLogEntries());
            token = resp.getToken();
            if (i == 9) {
                this.soft.assertThat(token).isNull();
                continue;
            }
            this.soft.assertThat(token).isNotNull();
        }
        this.soft.assertThat(all).containsExactlyElementsOf((Iterable)notPaged);
        this.soft.assertAll();
        this.soft.assertThat(((GetCommitLogBuilder)((GetCommitLogBuilder)this.api().getCommitLog().reference((Reference)main)).maxRecords(1)).stream()).containsExactlyInAnyOrderElementsOf(all);
    }

    @Test
    public void allReferences() throws Exception {
        Branch main = this.api().getDefaultBranch();
        ArrayList<Object> expect = new ArrayList<Object>();
        for (int i = 0; i < 5; ++i) {
            expect.add(this.createReference(Branch.of((String)("b-" + i), (String)main.getHash()), main.getName()));
            expect.add(this.createReference(Tag.of((String)("t-" + i), (String)main.getHash()), main.getName()));
        }
        expect.add(main);
        List notPaged = this.api().getAllReferences().get().getReferences();
        this.soft.assertThat(notPaged).containsExactlyInAnyOrderElementsOf(expect);
        ArrayList all = new ArrayList();
        String token = null;
        for (int i = 0; i < 11; ++i) {
            ReferencesResponse resp = ((GetAllReferencesBuilder)((GetAllReferencesBuilder)this.api().getAllReferences().maxRecords(1)).pageToken(token)).get();
            all.addAll(resp.getReferences());
            token = resp.getToken();
            if (i == 10) {
                this.soft.assertThat(token).isNull();
                continue;
            }
            this.soft.assertThat(token).isNotNull();
        }
        this.soft.assertThat(all).containsExactlyElementsOf((Iterable)notPaged);
        this.soft.assertAll();
        this.soft.assertThat(((GetAllReferencesBuilder)this.api().getAllReferences().maxRecords(1)).stream()).containsExactlyInAnyOrderElementsOf(all);
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V1})
    public void contentsOnDefaultBranch() throws Exception {
        Branch main = this.api().getDefaultBranch();
        ContentKey key = ContentKey.of((String[])new String[]{"test.key1"});
        Branch main1 = this.prepCommit(main, "commit", new Operation[]{Operation.Put.of((ContentKey)key, (Content)IcebergTable.of((String)"loc111", (long)1L, (int)2, (int)3, (int)4))}).commit();
        IcebergTable created = (IcebergTable)this.api().getContent().key(key).get().get(key);
        Assertions.assertThat((String)created.getMetadataLocation()).isEqualTo("loc111");
        this.prepCommit(main1, "commit", new Operation[]{Operation.Put.of((ContentKey)key, (Content)IcebergTable.builder().from(created).metadataLocation("loc222").build())}).commit();
        IcebergTable table2 = (IcebergTable)this.api().getContent().key(key).get().get(key);
        Assertions.assertThat((String)table2.getMetadataLocation()).isEqualTo("loc222");
        IcebergTable table1 = (IcebergTable)((GetContentBuilder)this.api().getContent().hashOnRef(main1.getHash())).key(key).get().get(key);
        Assertions.assertThat((Object)table1).isEqualTo((Object)created);
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    public void contents() throws Exception {
        Branch main = this.api().getDefaultBranch();
        CommitResponse committed = this.prepCommit(main, "commit", (Operation[])Stream.concat(Stream.of(Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{"b.b"}), (Content)Namespace.of((String[])new String[]{"b.b"})), Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{"b.b", "c"}), (Content)Namespace.of((String[])new String[]{"b.b", "c"}))), IntStream.range(0, 8).mapToObj(i -> this.dummyPut("b.b", "c", Integer.toString(i)))).toArray(Operation[]::new)).commitWithResponse();
        main = committed.getTargetBranch();
        List allKeys = Stream.concat(Stream.of(ContentKey.of((String[])new String[]{"b.b"}), ContentKey.of((String[])new String[]{"b.b", "c"})), IntStream.range(0, 8).mapToObj(i -> ContentKey.of((String[])new String[]{"b.b", "c", Integer.toString(i)}))).collect(Collectors.toList());
        GetMultipleContentsResponse resp = ((GetContentBuilder)this.api().getContent().refName(main.getName())).keys(allKeys).getWithResponse();
        ContentKey singleKey = ContentKey.of((String[])new String[]{"b.b", "c", "3"});
        this.soft.assertThat((Object)((GetContentBuilder)this.api().getContent().refName(main.getName())).getSingle(singleKey)).extracting(new Function[]{ContentResponse::getEffectiveReference, ContentResponse::getContent}).containsExactly(new Object[]{main, IcebergTable.of((String)"foo", (long)1L, (int)2, (int)3, (int)4, (String)((String)committed.toAddedContentsMap().get(singleKey)))});
        this.soft.assertThat((Object)resp.getEffectiveReference()).isEqualTo((Object)main);
        ((MapAssert)this.soft.assertThat(resp.toContentsMap()).containsOnlyKeys(allKeys)).hasSize(allKeys.size());
        String mainName = main.getName();
        ContentKey key = ContentKey.of((String[])new String[]{"b.b", "c", "1"});
        this.soft.assertThat((Object)((GetContentBuilder)this.api().getContent().refName(mainName)).getSingle(key)).isEqualTo((Object)ContentResponse.of((Content)IcebergTable.of((String)"foo", (long)1L, (int)2, (int)3, (int)4, (String)((String)committed.toAddedContentsMap().get(key))), (Reference)main));
        ContentKey nonExisting = ContentKey.of((String[])new String[]{"not", "there"});
        ((ObjectAssert)((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> ((GetContentBuilder)this.api().getContent().refName(mainName)).getSingle(nonExisting)).isInstanceOf(NessieContentNotFoundException.class)).asInstanceOf(InstanceOfAssertFactories.type(NessieContentNotFoundException.class))).extracting(NessieContentNotFoundException::getErrorDetails).extracting(ContentKeyErrorDetails::contentKey).isEqualTo((Object)nonExisting);
    }

    @Test
    public void entries() throws Exception {
        Branch main0 = this.api().getDefaultBranch();
        Branch main = this.prepCommit(main0, "commit", (Operation[])Stream.concat(Stream.of(Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{"c"}), (Content)Namespace.of((String[])new String[]{"c"}))), IntStream.range(0, 9).mapToObj(i -> this.dummyPut("c", Integer.toString(i)))).toArray(Operation.Put[]::new)).commit();
        EntriesResponse response = ((GetEntriesBuilder)this.api().getEntries().reference((Reference)main)).withContent(this.isV2()).get();
        List notPaged = response.getEntries();
        this.soft.assertThat(notPaged).hasSize(10);
        if (this.isV2()) {
            this.soft.assertThat((Object)response.getEffectiveReference()).isEqualTo((Object)main);
            ((AbstractListAssert)this.soft.assertThat(response.getEntries()).extracting(EntriesResponse.Entry::getContent).doesNotContainNull()).isNotEmpty();
            this.soft.assertThat(((GetEntriesBuilder)((GetEntriesBuilder)((GetEntriesBuilder)this.api().getEntries().reference((Reference)main)).minKey(ContentKey.of((String[])new String[]{"c", "2"}))).maxKey(ContentKey.of((String[])new String[]{"c", "4"}))).get().getEntries()).extracting(EntriesResponse.Entry::getName).containsExactlyInAnyOrder((Object[])new ContentKey[]{ContentKey.of((String[])new String[]{"c", "2"}), ContentKey.of((String[])new String[]{"c", "3"}), ContentKey.of((String[])new String[]{"c", "4"})});
            ((AbstractListAssert)this.soft.assertThat(((GetEntriesBuilder)((GetEntriesBuilder)this.api().getEntries().reference((Reference)main)).prefixKey(ContentKey.of((String[])new String[]{"c"}))).get().getEntries()).extracting(EntriesResponse.Entry::getName).contains((Object[])new ContentKey[]{ContentKey.of((String[])new String[]{"c"})})).containsAll((Iterable)IntStream.range(0, 9).mapToObj(i -> ContentKey.of((String[])new String[]{"c", Integer.toString(i)})).collect(Collectors.toList()));
            this.soft.assertThat(((GetEntriesBuilder)((GetEntriesBuilder)((GetEntriesBuilder)this.api().getEntries().reference((Reference)main)).key(ContentKey.of((String[])new String[]{"c", "2"}))).key(ContentKey.of((String[])new String[]{"c", "4"}))).get().getEntries()).extracting(EntriesResponse.Entry::getName).containsExactlyInAnyOrder((Object[])new ContentKey[]{ContentKey.of((String[])new String[]{"c", "2"}), ContentKey.of((String[])new String[]{"c", "4"})});
            this.soft.assertThat(((GetEntriesBuilder)((GetEntriesBuilder)this.api().getEntries().reference((Reference)main)).prefixKey(ContentKey.of((String[])new String[]{"c", "5"}))).get().getEntries()).extracting(EntriesResponse.Entry::getName).containsExactlyInAnyOrder((Object[])new ContentKey[]{ContentKey.of((String[])new String[]{"c", "5"})});
        }
        ArrayList all = new ArrayList();
        String token = null;
        for (int i2 = 0; i2 < 10; ++i2) {
            EntriesResponse resp = ((GetEntriesBuilder)((GetEntriesBuilder)((GetEntriesBuilder)this.api().getEntries().withContent(this.isV2()).reference((Reference)main)).maxRecords(1)).pageToken(token)).get();
            all.addAll(resp.getEntries());
            token = resp.getToken();
            if (i2 == 9) {
                this.soft.assertThat(token).isNull();
                continue;
            }
            this.soft.assertThat(token).isNotNull();
        }
        this.soft.assertThat(all).containsExactlyElementsOf((Iterable)notPaged);
        this.soft.assertAll();
        this.soft.assertThat(((GetEntriesBuilder)((GetEntriesBuilder)this.api().getEntries().withContent(this.isV2()).reference((Reference)main)).maxRecords(1)).stream()).containsExactlyInAnyOrderElementsOf(all);
    }

    @NessieApiVersions(versions={NessieApiVersion.V2})
    @Test
    public void entryContentId() throws Exception {
        Branch main = this.prepCommit(this.api().getDefaultBranch(), "commit", new Operation[]{this.dummyPut("test-table")}).commit();
        ((AbstractListAssert)this.soft.assertThat(((GetEntriesBuilder)this.api().getEntries().reference((Reference)main)).stream()).isNotEmpty()).allSatisfy(e -> Assertions.assertThat((String)e.getContentId()).isNotNull());
    }

    @Test
    public void namespaces() throws Exception {
        Namespace namespace4WithId;
        Namespace namespace3WithId;
        Namespace namespace2WithId;
        Namespace namespace1WithId;
        Branch main = this.api().getDefaultBranch();
        String mainName = main.getName();
        this.soft.assertThat(((GetMultipleNamespacesBuilder)((GetMultipleNamespacesBuilder)this.api().getMultipleNamespaces().reference((Reference)main)).namespace(Namespace.EMPTY)).get().getNamespaces()).isEmpty();
        Namespace namespace1 = Namespace.of((String[])new String[]{"a"});
        Namespace namespace2 = Namespace.of((String[])new String[]{"a", "b.b"});
        Namespace namespace3 = Namespace.of((String[])new String[]{"a", "b.bbbb"});
        Namespace namespace4 = Namespace.of((String[])new String[]{"a", "b.b", "c"});
        Function<String, CommitMeta> buildMeta = msg -> CommitMeta.builder().authorTime(Instant.EPOCH).author("NessieHerself").signedOffBy("Arctic").message(msg + " my namespace with commit meta").putProperties("property", "value").build();
        BiConsumer<Reference, String> checkMeta = (ref, msg) -> {
            try (Stream log = ((GetCommitLogBuilder)((GetCommitLogBuilder)this.api().getCommitLog().reference(ref)).maxRecords(1)).stream();){
                ((ObjectAssert)this.soft.assertThat(log).first()).extracting(LogResponse.LogEntry::getCommitMeta).extracting(new Function[]{CommitMeta::getMessage, CommitMeta::getAllAuthors, CommitMeta::getAuthorTime, CommitMeta::getAllSignedOffBy, CommitMeta::getProperties}).containsExactly(new Object[]{msg + " my namespace with commit meta", Collections.singletonList("NessieHerself"), Instant.EPOCH, Collections.singletonList("Arctic"), Collections.singletonMap("property", "value")});
            }
            catch (NessieNotFoundException e) {
                throw new RuntimeException(e);
            }
        };
        if (this.isV2()) {
            CreateNamespaceResult resp1 = ((CreateNamespaceBuilder)((CreateNamespaceBuilder)((CreateNamespaceBuilder)this.api().createNamespace().refName(mainName)).namespace(namespace1)).commitMeta(buildMeta.apply("Create"))).createWithResponse();
            ((ObjectAssert)this.soft.assertThat((Object)resp1.getEffectiveBranch()).isNotNull()).isNotEqualTo((Object)main);
            checkMeta.accept((Reference)resp1.getEffectiveBranch(), "Create");
            CreateNamespaceResult resp2 = ((CreateNamespaceBuilder)((CreateNamespaceBuilder)this.api().createNamespace().refName(mainName)).namespace(namespace2)).createWithResponse();
            ((ObjectAssert)((ObjectAssert)this.soft.assertThat((Object)resp2.getEffectiveBranch()).isNotNull()).isNotEqualTo((Object)main)).isNotEqualTo((Object)resp1.getEffectiveBranch());
            CreateNamespaceResult resp3 = ((CreateNamespaceBuilder)((CreateNamespaceBuilder)this.api().createNamespace().refName(mainName)).namespace(namespace3)).createWithResponse();
            ((ObjectAssert)((ObjectAssert)this.soft.assertThat((Object)resp3.getEffectiveBranch()).isNotNull()).isNotEqualTo((Object)resp1.getEffectiveBranch())).isNotEqualTo((Object)resp2.getEffectiveBranch());
            CreateNamespaceResult resp4 = ((CreateNamespaceBuilder)((CreateNamespaceBuilder)this.api().createNamespace().refName(mainName)).namespace(namespace4)).createWithResponse();
            ((ObjectAssert)((ObjectAssert)this.soft.assertThat((Object)resp4.getEffectiveBranch()).isNotNull()).isNotEqualTo((Object)resp2.getEffectiveBranch())).isNotEqualTo((Object)resp3.getEffectiveBranch());
            namespace1WithId = resp1.getNamespace();
            namespace2WithId = resp2.getNamespace();
            namespace3WithId = resp3.getNamespace();
            namespace4WithId = resp4.getNamespace();
            for (Map.Entry c : ImmutableMap.of((Object)Namespace.EMPTY, Collections.singletonList(namespace1WithId), (Object)namespace1, Arrays.asList(namespace2WithId, namespace3WithId), (Object)namespace2, Collections.singletonList(namespace4WithId), (Object)namespace3, Collections.emptyList(), (Object)namespace4, Collections.emptyList()).entrySet()) {
                ((ListAssert)this.soft.assertThat(((GetMultipleNamespacesBuilder)((GetMultipleNamespacesBuilder)this.api().getMultipleNamespaces().refName(mainName)).namespace((Namespace)c.getKey())).onlyDirectChildren(true).get().getNamespaces()).describedAs("for namespace %s", new Object[]{c.getKey()})).containsExactlyInAnyOrderElementsOf((Iterable)c.getValue());
            }
        } else {
            namespace1WithId = ((CreateNamespaceBuilder)((CreateNamespaceBuilder)this.api().createNamespace().refName(mainName)).namespace(namespace1)).create();
            namespace2WithId = ((CreateNamespaceBuilder)((CreateNamespaceBuilder)this.api().createNamespace().refName(mainName)).namespace(namespace2)).create();
            namespace3WithId = ((CreateNamespaceBuilder)((CreateNamespaceBuilder)this.api().createNamespace().refName(mainName)).namespace(namespace3)).create();
            namespace4WithId = ((CreateNamespaceBuilder)((CreateNamespaceBuilder)this.api().createNamespace().refName(mainName)).namespace(namespace4)).create();
        }
        IcebergTable table = IcebergTable.of((String)"irrelevant", (long)1L, (int)2, (int)3, (int)4);
        ContentKey table1 = ContentKey.of((Namespace)namespace4, (String)"table1");
        ((CommitMultipleOperationsBuilder)this.api().commitMultipleOperations().branch(main)).commitMeta(CommitMeta.fromMessage((String)"Add table1")).operation((Operation)Operation.Put.of((ContentKey)table1, (Content)table)).commit();
        for (Map.Entry c : ImmutableMap.of((Object)Namespace.EMPTY, Arrays.asList(namespace1WithId, namespace2WithId, namespace3WithId, namespace4WithId), (Object)namespace1, Arrays.asList(namespace1WithId, namespace2WithId, namespace3WithId, namespace4WithId), (Object)namespace2, Arrays.asList(namespace2WithId, namespace4WithId), (Object)namespace3, Collections.singletonList(namespace3WithId), (Object)namespace4, Collections.singletonList(namespace4WithId)).entrySet()) {
            ((ListAssert)this.soft.assertThat(((GetMultipleNamespacesBuilder)((GetMultipleNamespacesBuilder)this.api().getMultipleNamespaces().refName(mainName)).namespace((Namespace)c.getKey())).get().getNamespaces()).describedAs("for namespace %s", new Object[]{c.getKey()})).containsExactlyInAnyOrderElementsOf((Iterable)c.getValue());
        }
        GetNamespacesResponse getMultiple = ((GetMultipleNamespacesBuilder)((GetMultipleNamespacesBuilder)this.api().getMultipleNamespaces().refName(mainName)).namespace(Namespace.EMPTY)).get();
        if (this.isV2()) {
            main = (Branch)this.api().getReference().refName(mainName).get();
            this.soft.assertThat((Object)getMultiple.getEffectiveReference()).isEqualTo((Object)main);
        }
        this.soft.assertThat(getMultiple.getNamespaces()).containsExactlyInAnyOrder((Object[])new Namespace[]{namespace1WithId, namespace2WithId, namespace3WithId, namespace4WithId});
        this.soft.assertThat(((GetMultipleNamespacesBuilder)((GetMultipleNamespacesBuilder)this.api().getMultipleNamespaces().refName(mainName)).namespace(namespace1)).get().getNamespaces()).containsExactlyInAnyOrder((Object[])new Namespace[]{namespace1WithId, namespace2WithId, namespace3WithId, namespace4WithId});
        this.soft.assertThat(((GetMultipleNamespacesBuilder)((GetMultipleNamespacesBuilder)this.api().getMultipleNamespaces().refName(mainName)).namespace(namespace2)).get().getNamespaces()).containsExactlyInAnyOrder((Object[])new Namespace[]{namespace2WithId, namespace4WithId});
        ((MapAssert)((MapAssert)((MapAssert)this.soft.assertThat(((GetContentBuilder)this.api().getContent().refName(mainName)).key(namespace1.toContentKey()).key(namespace2.toContentKey()).key(namespace3.toContentKey()).key(namespace4.toContentKey()).get()).containsEntry((Object)namespace1.toContentKey(), (Object)namespace1WithId)).containsEntry((Object)namespace2.toContentKey(), (Object)namespace2WithId)).containsEntry((Object)namespace3.toContentKey(), (Object)namespace3WithId)).containsEntry((Object)namespace4.toContentKey(), (Object)namespace4WithId);
        this.soft.assertThat((Object)((GetNamespaceBuilder)((GetNamespaceBuilder)this.api().getNamespace().refName(mainName)).namespace(namespace1)).get()).isEqualTo((Object)namespace1WithId);
        this.soft.assertThat((Object)((GetNamespaceBuilder)((GetNamespaceBuilder)this.api().getNamespace().refName(mainName)).namespace(namespace2)).get()).isEqualTo((Object)namespace2WithId);
        this.soft.assertThat((Object)((GetNamespaceBuilder)((GetNamespaceBuilder)this.api().getNamespace().refName(mainName)).namespace(namespace3)).get()).isEqualTo((Object)namespace3WithId);
        this.soft.assertThat((Object)((GetNamespaceBuilder)((GetNamespaceBuilder)this.api().getNamespace().refName(mainName)).namespace(namespace4)).get()).isEqualTo((Object)namespace4WithId);
        if (this.isV2()) {
            main = (Branch)this.api().getReference().refName(mainName).get();
            UpdateNamespaceResult update = ((UpdateNamespaceBuilder)((UpdateNamespaceBuilder)((UpdateNamespaceBuilder)this.api().updateProperties().refName(mainName)).namespace(namespace2)).commitMeta(buildMeta.apply("Update"))).updateProperty("foo", "bar").updateProperty("bar", "baz").updateWithResponse();
            ((ObjectAssert)this.soft.assertThat((Object)update.getEffectiveBranch()).isNotNull()).isNotEqualTo((Object)main);
            checkMeta.accept((Reference)update.getEffectiveBranch(), "Update");
        } else {
            ((UpdateNamespaceBuilder)((UpdateNamespaceBuilder)this.api().updateProperties().refName(mainName)).namespace(namespace2)).updateProperty("foo", "bar").updateProperty("bar", "baz").update();
        }
        Namespace namespace2update = (Namespace)((GetContentBuilder)this.api().getContent().refName(mainName)).key(ContentKey.of((String[])new String[]{"a", "b.b"})).get().get(ContentKey.of((String[])new String[]{"a", "b.b"}));
        this.soft.assertThat((Object)((GetNamespaceBuilder)((GetNamespaceBuilder)this.api().getNamespace().refName(mainName)).namespace(namespace2)).get()).isEqualTo((Object)namespace2update);
        this.soft.assertThat(((GetMultipleNamespacesBuilder)((GetMultipleNamespacesBuilder)this.api().getMultipleNamespaces().refName(mainName)).namespace(Namespace.EMPTY)).get().getNamespaces()).containsExactlyInAnyOrder((Object[])new Namespace[]{namespace1WithId, namespace2update, namespace3WithId, namespace4WithId});
        if (this.isV2()) {
            UpdateNamespaceResult updateResponse = ((UpdateNamespaceBuilder)((UpdateNamespaceBuilder)this.api().updateProperties().refName(mainName)).namespace(namespace2)).removeProperty("foo").updateWithResponse();
            this.soft.assertThat((Object)updateResponse.getEffectiveBranch()).isNotEqualTo((Object)main);
            main = updateResponse.getEffectiveBranch();
        } else {
            ((UpdateNamespaceBuilder)((UpdateNamespaceBuilder)this.api().updateProperties().refName(mainName)).namespace(namespace2)).removeProperty("foo").update();
        }
        Namespace namespace2update2 = (Namespace)((GetContentBuilder)this.api().getContent().refName(mainName)).key(ContentKey.of((String[])new String[]{"a", "b.b"})).get().get(ContentKey.of((String[])new String[]{"a", "b.b"}));
        this.soft.assertThat((Object)((GetNamespaceBuilder)((GetNamespaceBuilder)this.api().getNamespace().refName(mainName)).namespace(namespace2)).get()).isEqualTo((Object)namespace2update2);
        this.soft.assertThat(((GetMultipleNamespacesBuilder)((GetMultipleNamespacesBuilder)this.api().getMultipleNamespaces().refName(mainName)).namespace(Namespace.EMPTY)).get().getNamespaces()).containsExactlyInAnyOrder((Object[])new Namespace[]{namespace1WithId, namespace2update2, namespace3WithId, namespace4WithId});
        if (this.isV2()) {
            ((ObjectAssert)((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> ((DeleteNamespaceBuilder)((DeleteNamespaceBuilder)this.api().deleteNamespace().refName(mainName)).namespace(namespace2)).delete()).isInstanceOf(NessieNamespaceNotEmptyException.class)).asInstanceOf(InstanceOfAssertFactories.type(NessieNamespaceNotEmptyException.class))).extracting(NessieNamespaceNotEmptyException::getErrorDetails).extracting(ContentKeyErrorDetails::contentKey).isEqualTo((Object)namespace2.toContentKey());
            ((ObjectAssert)((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> ((DeleteNamespaceBuilder)((DeleteNamespaceBuilder)this.api().deleteNamespace().refName(mainName)).namespace(namespace4)).delete()).isInstanceOf(NessieNamespaceNotEmptyException.class)).asInstanceOf(InstanceOfAssertFactories.type(NessieNamespaceNotEmptyException.class))).extracting(NessieNamespaceNotEmptyException::getErrorDetails).extracting(ContentKeyErrorDetails::contentKey).isEqualTo((Object)namespace4.toContentKey());
        } else {
            this.soft.assertThatThrownBy(() -> ((DeleteNamespaceBuilder)((DeleteNamespaceBuilder)this.api().deleteNamespace().refName(mainName)).namespace(namespace2)).delete()).isInstanceOf(NessieNamespaceNotEmptyException.class);
            this.soft.assertThatThrownBy(() -> ((DeleteNamespaceBuilder)((DeleteNamespaceBuilder)this.api().deleteNamespace().refName(mainName)).namespace(namespace4)).delete()).isInstanceOf(NessieNamespaceNotEmptyException.class);
        }
        main = (Branch)this.api().getReference().refName(mainName).get();
        ((CommitMultipleOperationsBuilder)this.api().commitMultipleOperations().branch(main)).commitMeta(CommitMeta.fromMessage((String)"Delete table1")).operation((Operation)Operation.Delete.of((ContentKey)table1)).commit();
        if (this.isV2()) {
            main = (Branch)this.api().getReference().refName(mainName).get();
            DeleteNamespaceResult response = ((DeleteNamespaceBuilder)((DeleteNamespaceBuilder)((DeleteNamespaceBuilder)this.api().deleteNamespace().refName(mainName)).namespace(namespace4)).commitMeta(buildMeta.apply("Delete"))).deleteWithResponse();
            ((ObjectAssert)this.soft.assertThat((Object)response.getEffectiveBranch()).isNotNull()).isNotEqualTo((Object)main);
            checkMeta.accept((Reference)response.getEffectiveBranch(), "Delete");
        } else {
            ((DeleteNamespaceBuilder)((DeleteNamespaceBuilder)this.api().deleteNamespace().refName(mainName)).namespace(namespace4)).delete();
        }
        this.soft.assertThat(((GetContentBuilder)this.api().getContent().refName(mainName)).key(ContentKey.of((String[])new String[]{"a", "b.b", "c"})).get()).isEmpty();
        ((ObjectAssert)((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> ((GetNamespaceBuilder)((GetNamespaceBuilder)this.api().getNamespace().refName(mainName)).namespace(namespace4)).get()).isInstanceOf(NessieNamespaceNotFoundException.class)).asInstanceOf(InstanceOfAssertFactories.type(NessieNamespaceNotFoundException.class))).extracting(NessieNamespaceNotFoundException::getErrorDetails).extracting(ContentKeyErrorDetails::contentKey).isEqualTo((Object)namespace4.toContentKey());
        this.soft.assertThatThrownBy(() -> ((DeleteNamespaceBuilder)((DeleteNamespaceBuilder)this.api().deleteNamespace().refName(mainName)).namespace(namespace4)).delete()).isInstanceOf(NessieNamespaceNotFoundException.class);
        this.soft.assertThat(((GetMultipleNamespacesBuilder)((GetMultipleNamespacesBuilder)this.api().getMultipleNamespaces().refName(mainName)).namespace(Namespace.EMPTY)).get().getNamespaces()).containsExactlyInAnyOrder((Object[])new Namespace[]{namespace1WithId, namespace2update2, namespace3WithId});
        this.soft.assertThatCode(() -> ((DeleteNamespaceBuilder)((DeleteNamespaceBuilder)this.api().deleteNamespace().refName(mainName)).namespace(namespace2)).delete()).doesNotThrowAnyException();
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    public void commitLogForNamelessReference() throws BaseNessieClientServerException {
        Branch main = this.api().getDefaultBranch();
        Branch branch = this.createReference(Branch.of((String)"commitLogForNamelessReference", (String)main.getHash()), main.getName());
        for (int i = 0; i < 5; ++i) {
            branch = i == 0 ? this.prepCommit(branch, "c-" + i, new Operation[]{Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{"c"}), (Content)Namespace.of((String[])new String[]{"c"})), this.dummyPut("c", Integer.toString(i))}).commit() : this.prepCommit(branch, "c-" + i, new Operation[]{this.dummyPut("c", Integer.toString(i))}).commit();
        }
        List log = ((GetCommitLogBuilder)this.api().getCommitLog().hashOnRef(branch.getHash())).stream().collect(Collectors.toList());
        Assertions.assertThat(log).hasSize(5);
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    public void testDiffByNamelessReference() throws BaseNessieClientServerException {
        Branch main = this.api().getDefaultBranch();
        Branch fromRef = this.createReference(Branch.of((String)"testFrom", (String)main.getHash()), main.getName());
        Branch toRef = this.createReference(Branch.of((String)"testTo", (String)main.getHash()), main.getName());
        toRef = this.prepCommit(toRef, "commit", new Operation[]{this.dummyPut("c")}).commit();
        ((ListAssert)this.soft.assertThat(this.api().getDiff().fromRef((Reference)fromRef).toHashOnRef(toRef.getHash()).get().getDiffs()).hasSize(1)).allSatisfy(diff -> {
            Assertions.assertThat((Comparable)diff.getKey()).isNotNull();
            Assertions.assertThat((Object)diff.getFrom()).isNull();
            Assertions.assertThat((Object)diff.getTo()).isNotNull();
        });
        ((ListAssert)this.soft.assertThat(this.api().getDiff().fromHashOnRef(fromRef.getHash()).toHashOnRef(toRef.getHash()).get().getDiffs()).hasSize(1)).allSatisfy(diff -> {
            Assertions.assertThat((Comparable)diff.getKey()).isNotNull();
            Assertions.assertThat((Object)diff.getFrom()).isNull();
            Assertions.assertThat((Object)diff.getTo()).isNotNull();
        });
        ((ListAssert)this.soft.assertThat(this.api().getDiff().fromHashOnRef(toRef.getHash()).toRef((Reference)fromRef).get().getDiffs()).hasSize(1)).allSatisfy(diff -> {
            Assertions.assertThat((Comparable)diff.getKey()).isNotNull();
            Assertions.assertThat((Object)diff.getFrom()).isNotNull();
            Assertions.assertThat((Object)diff.getTo()).isNull();
        });
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    public void fetchEntriesByNamelessReference() throws BaseNessieClientServerException {
        Branch main = this.api().getDefaultBranch();
        Branch branch = this.createReference(Branch.of((String)"fetchEntriesByNamelessReference", (String)main.getHash()), main.getName());
        ContentKey a = ContentKey.of((String[])new String[]{"a"});
        ContentKey b = ContentKey.of((String[])new String[]{"b"});
        IcebergTable ta = IcebergTable.of((String)"path1", (long)42L, (int)42, (int)42, (int)42);
        IcebergView tb = IcebergView.of((String)"pathx", (long)1L, (int)1, (String)"select * from table", (String)"Dremio");
        branch = ((CommitMultipleOperationsBuilder)this.api().commitMultipleOperations().branch(branch)).operation((Operation)Operation.Put.of((ContentKey)a, (Content)ta)).operation((Operation)Operation.Put.of((ContentKey)b, (Content)tb)).commitMeta(CommitMeta.fromMessage((String)"commit 1")).commit();
        List entries = ((GetEntriesBuilder)this.api().getEntries().hashOnRef(branch.getHash())).get().getEntries();
        this.soft.assertThat(entries).map(e -> Maps.immutableEntry((Object)e.getName(), (Object)e.getType())).containsExactlyInAnyOrder((Object[])new Map.Entry[]{Maps.immutableEntry((Object)a, (Object)Content.Type.ICEBERG_TABLE), Maps.immutableEntry((Object)b, (Object)Content.Type.ICEBERG_VIEW)});
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    @DisabledOnOs(value={OS.WINDOWS})
    public void relativeCommitLocations() throws BaseNessieClientServerException {
        Branch main = this.api().getDefaultBranch();
        int numCommits = 3;
        Branch branch = this.createReference(Branch.of((String)"relativeCommitLocations", (String)main.getHash()), main.getName());
        ContentKey key = ContentKey.of((String[])new String[]{"foo"});
        ImmutableIcebergTable content = (ImmutableIcebergTable)IcebergTable.of((String)"here", (long)(numCommits - 1), (int)2, (int)3, (int)4);
        ArrayList<String> hashes = new ArrayList<String>();
        for (int i = 0; i < numCommits; ++i) {
            CommitResponse commitResponse = ((CommitMultipleOperationsBuilder)this.api.commitMultipleOperations().branch(branch)).operation((Operation)Operation.Put.of((ContentKey)key, (Content)content)).operation((Operation)Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{"other-" + i}), (Content)IcebergTable.of((String)("other-" + i), (long)1L, (int)2, (int)3, (int)4))).commitMeta(CommitMeta.fromMessage((String)("commit " + i))).commitWithResponse();
            content = ((ImmutableIcebergTable)commitResponse.contentWithAssignedId(key, (Content)content)).withSnapshotId(content.getSnapshotId() - 1L);
            branch = commitResponse.getTargetBranch();
            hashes.add(branch.getHash());
        }
        Collections.reverse(hashes);
        List commits = ((GetCommitLogBuilder)this.api().getCommitLog().reference((Reference)branch)).stream().collect(Collectors.toList());
        String headCommit = ((LogResponse.LogEntry)commits.get(0)).getCommitMeta().getHash();
        for (int i = 1; i < numCommits; ++i) {
            CommitMeta refCommit = ((LogResponse.LogEntry)commits.get(i - 1)).getCommitMeta();
            String[] relativeCommitSpecs = new String[]{"~" + i, headCommit + "~" + i, "*" + refCommit.getCommitTime().minus(1L, ChronoUnit.NANOS), headCommit + "*" + refCommit.getCommitTime().minus(1L, ChronoUnit.NANOS)};
            String branchName = branch.getName();
            int i2 = i;
            for (String relativeCommitSpec : relativeCommitSpecs) {
                ((AbstractThrowableAssert)this.soft.assertThatCode(() -> Assertions.assertThat(((GetCommitLogBuilder)((GetCommitLogBuilder)((GetCommitLogBuilder)this.api().getCommitLog().refName(branchName)).hashOnRef(relativeCommitSpec)).maxRecords(1)).stream().findFirst()).map(LogResponse.LogEntry::getCommitMeta).map(CommitMeta::getHash).isEqualTo(Optional.of((String)hashes.get(i2)))).describedAs("commit-log - %s - relative-commit-spec %s - ref-commit: %s %s", new Object[]{i, relativeCommitSpec, refCommit.getHash(), refCommit.getCommitTime()})).doesNotThrowAnyException();
                ((AbstractThrowableAssert)this.soft.assertThatCode(() -> Assertions.assertThat((long)((GetEntriesBuilder)((GetEntriesBuilder)this.api().getEntries().refName(branchName)).hashOnRef(relativeCommitSpec)).stream().map(EntriesResponse.Entry::getName).count()).isEqualTo((long)(1 + numCommits - i2))).describedAs("get-entries - %s - relative-commit-spec %s - ref-commit: %s %s", new Object[]{i, relativeCommitSpec, refCommit.getHash(), refCommit.getCommitTime()})).doesNotThrowAnyException();
                this.soft.assertThatCode(() -> {
                    ContentResponse cr = ((GetContentBuilder)((GetContentBuilder)this.api().getContent().refName(branchName)).hashOnRef(relativeCommitSpec)).getSingle(key);
                    Assertions.assertThat((String)cr.getEffectiveReference().getHash()).isEqualTo((String)hashes.get(i2)).isEqualTo(((LogResponse.LogEntry)commits.get(i2)).getCommitMeta().getHash());
                    Assertions.assertThat((long)((IcebergTable)cr.getContent()).getSnapshotId()).isEqualTo((long)i2);
                }).describedAs("get-content - %s - relative-commit-spec %s - ref-commit: %s %s", new Object[]{i, relativeCommitSpec, refCommit.getHash(), refCommit.getCommitTime()});
            }
        }
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    void createAndUpdateRepositoryConfig() throws Exception {
        NessieApiV2 api = this.apiV2();
        ImmutableGarbageCollectorConfig created = GarbageCollectorConfig.builder().defaultCutoffPolicy("P30D").newFilesGracePeriod(Duration.of(3L, ChronoUnit.HOURS)).build();
        ImmutableGarbageCollectorConfig updated = GarbageCollectorConfig.builder().defaultCutoffPolicy("P10D").expectedFileCountPerContent(Integer.valueOf(123)).build();
        this.soft.assertThat((Object)created.getType()).isEqualTo((Object)RepositoryConfig.Type.GARBAGE_COLLECTOR);
        this.soft.assertThat((Object)updated.getType()).isEqualTo((Object)RepositoryConfig.Type.GARBAGE_COLLECTOR);
        this.soft.assertThat(api.getRepositoryConfig().type(RepositoryConfig.Type.GARBAGE_COLLECTOR).get().getConfigs()).isEmpty();
        this.soft.assertThat((Object)api.updateRepositoryConfig().repositoryConfig((RepositoryConfig)created).update().getPrevious()).isNull();
        this.soft.assertThat(api.getRepositoryConfig().type(RepositoryConfig.Type.GARBAGE_COLLECTOR).get().getConfigs()).containsExactly((Object[])new RepositoryConfig[]{created});
        this.soft.assertThat((Object)api.updateRepositoryConfig().repositoryConfig((RepositoryConfig)updated).update().getPrevious()).isEqualTo((Object)created);
        this.soft.assertThat(api.getRepositoryConfig().type(RepositoryConfig.Type.GARBAGE_COLLECTOR).get().getConfigs()).containsExactly((Object[])new RepositoryConfig[]{updated});
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    void genericRepositoryConfigForbidden() {
        NessieApiV2 api = this.apiV2();
        ImmutableGenericRepositoryConfig created = ImmutableGenericRepositoryConfig.builder().type(new RepositoryConfig.Type(){

            public String name() {
                return "FOO_BAR";
            }

            public Class<? extends RepositoryConfig> type() {
                return GenericRepositoryConfig.class;
            }
        }).putAttributes("foo", (Object)"bar").putAttributes("bar", (Object)"baz").build();
        ((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> BaseTestNessieApi.lambda$genericRepositoryConfigForbidden$48(api, (RepositoryConfig)created)).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Repository config type bundle for 'FOO_BAR' is not available on the Nessie server side");
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    void invalidCreateRepositoryConfig() {
        NessieApiV2 api = this.apiV2();
        this.api().getConfig();
        ((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> api.updateRepositoryConfig().repositoryConfig((RepositoryConfig)GarbageCollectorConfig.builder().defaultCutoffPolicy("foo").newFilesGracePeriod(Duration.of(3L, ChronoUnit.HOURS)).build()).update().getPrevious()).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Failed to parse default-cutoff-value");
    }

    @Test
    void invalidParameters() {
        ((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> ((GetEntriesBuilder)this.api().getEntries().refName("..invalid..")).get()).isInstanceOf(NessieBadRequestException.class)).hasMessageContaining("Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'");
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    void renameTwice() throws Exception {
        Branch main = this.api().getDefaultBranch();
        this.soft.assertThat(this.api().getAllReferences().get().getReferences()).containsExactly((Object[])new Reference[]{main});
        ContentKey key = ContentKey.of((String[])new String[]{"table"});
        ContentKey keyBackup = ContentKey.of((String[])new String[]{"table_backup"});
        ContentKey keyTemp = ContentKey.of((String[])new String[]{"table_tmp"});
        ImmutableList keys = ImmutableList.of((Object)key, (Object)keyTemp, (Object)keyBackup);
        IcebergTable tableOld = IcebergTable.of((String)"old", (long)1L, (int)2, (int)3, (int)4);
        IcebergTable tableNew = IcebergTable.of((String)"new", (long)1L, (int)2, (int)3, (int)4);
        CommitResponse createTable = this.prepCommit(main, "commit", new Operation[]{Operation.Put.of((ContentKey)key, (Content)tableOld)}).commitWithResponse();
        tableOld = (IcebergTable)createTable.contentWithAssignedId(key, (Content)tableOld);
        ((MapAssert)this.soft.assertThat(((GetContentBuilder)this.api().getContent().reference((Reference)createTable.getTargetBranch())).key(key).get()).hasSize(1)).containsEntry((Object)key, (Object)tableOld);
        CommitResponse createNewTemp = this.prepCommit(createTable.getTargetBranch(), "new", new Operation[]{Operation.Put.of((ContentKey)keyTemp, (Content)tableNew)}).commitWithResponse();
        tableNew = (IcebergTable)createNewTemp.contentWithAssignedId(keyTemp, (Content)tableNew);
        ((MapAssert)((MapAssert)this.soft.assertThat(((GetContentBuilder)this.api().getContent().reference((Reference)createNewTemp.getTargetBranch())).keys((List)keys).get()).hasSize(2)).containsEntry((Object)key, (Object)tableOld)).containsEntry((Object)keyTemp, (Object)tableNew);
        CommitResponse renameToBackup = this.prepCommit(createNewTemp.getTargetBranch(), "backup", new Operation[]{Operation.Delete.of((ContentKey)key), Operation.Put.of((ContentKey)keyBackup, (Content)tableOld)}).commitWithResponse();
        ((MapAssert)((MapAssert)this.soft.assertThat(((GetContentBuilder)this.api().getContent().reference((Reference)renameToBackup.getTargetBranch())).keys((List)keys).get()).hasSize(2)).containsEntry((Object)keyBackup, (Object)tableOld)).containsEntry((Object)keyTemp, (Object)tableNew);
        CommitResponse renameNew = this.prepCommit(renameToBackup.getTargetBranch(), "rename new", new Operation[]{Operation.Delete.of((ContentKey)keyTemp), Operation.Put.of((ContentKey)key, (Content)tableNew)}).commitWithResponse();
        ((MapAssert)((MapAssert)this.soft.assertThat(((GetContentBuilder)this.api().getContent().reference((Reference)renameNew.getTargetBranch())).keys((List)keys).get()).hasSize(2)).containsEntry((Object)keyBackup, (Object)tableOld)).containsEntry((Object)key, (Object)tableNew);
        CommitResponse deleteOld = this.prepCommit(renameNew.getTargetBranch(), "delete", new Operation[]{Operation.Delete.of((ContentKey)keyBackup)}).commitWithResponse();
        ((MapAssert)this.soft.assertThat(((GetContentBuilder)this.api().getContent().reference((Reference)deleteOld.getTargetBranch())).keys((List)keys).get()).hasSize(1)).containsEntry((Object)key, (Object)tableNew);
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    public void testErrorsV2() throws Exception {
        ContentKey key = ContentKey.of((String[])new String[]{"namespace", "foo"});
        IcebergTable table = IcebergTable.of((String)"content-table1", (long)42L, (int)42, (int)42, (int)42);
        Branch main = this.api().getDefaultBranch();
        Branch branch = (Branch)this.api().createReference().reference((Reference)Branch.of((String)"ref-conflicts", (String)main.getHash())).sourceRefName(main.getName()).create();
        ((ListAssert)((ListAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> ((CommitMultipleOperationsBuilder)this.api().commitMultipleOperations().commitMeta(CommitMeta.fromMessage((String)"commit")).operation((Operation)Operation.Put.of((ContentKey)key, (Content)table)).branch(branch)).commit()).isInstanceOf(NessieReferenceConflictException.class)).asInstanceOf(InstanceOfAssertFactories.type(NessieReferenceConflictException.class))).matches(e -> e.getErrorCode().equals((Object)ErrorCode.REFERENCE_CONFLICT))).extracting(NessieReferenceConflictException::getErrorDetails).asInstanceOf(InstanceOfAssertFactories.type(ReferenceConflicts.class))).extracting(ReferenceConflicts::conflicts, InstanceOfAssertFactories.list(Conflict.class))).hasSize(1)).extracting(Conflict::conflictType).containsExactly((Object[])new Conflict.ConflictType[]{Conflict.ConflictType.NAMESPACE_ABSENT});
        ((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> this.api().getReference().refName("main@12345678").get()).isInstanceOf(NessieBadRequestException.class)).hasMessageEndingWith("Hashes are not allowed when fetching a reference by name");
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    public void referenceHistory() throws Exception {
        Branch main = this.api().getDefaultBranch();
        Branch branch = (Branch)this.api().createReference().reference((Reference)Branch.of((String)"ref-history", (String)main.getHash())).sourceRefName(main.getName()).create();
        ArrayList<String> expectedHashes = new ArrayList<String>();
        for (int c = 0; c < 10; ++c) {
            expectedHashes.add(branch.getHash());
            branch = this.prepCommit(branch, "commit-" + c, new Operation[0]).operation((Operation)Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{"t-" + c}), (Content)IcebergTable.of((String)("m-" + c), (long)1L, (int)2, (int)3, (int)4))).commit();
        }
        Collections.reverse(expectedHashes);
        ReferenceHistoryResponse response = this.apiV2().referenceHistory().refName(branch.getName()).headCommitsToScan(Integer.valueOf(1000)).get();
        this.soft.assertThat((Object)response).extracting(new Function[]{ReferenceHistoryResponse::getReference, ReferenceHistoryResponse::commitLogConsistency}).containsExactly(new Object[]{branch, CommitConsistency.COMMIT_CONSISTENT});
        this.soft.assertThat((Object)response.current()).extracting(new Function[]{ReferenceHistoryState::commitHash, ReferenceHistoryState::commitConsistency}).containsExactly(new Object[]{branch.getHash(), CommitConsistency.COMMIT_CONSISTENT});
        ((ListAssert)this.soft.assertThat(response.previous()).hasSize(10)).extracting(ReferenceHistoryState::commitConsistency).containsOnly((Object[])new CommitConsistency[]{CommitConsistency.COMMIT_CONSISTENT});
        ((ListAssert)this.soft.assertThat(response.previous()).hasSize(10)).extracting(ReferenceHistoryState::commitHash).containsExactlyElementsOf(expectedHashes);
    }

    private static /* synthetic */ void lambda$genericRepositoryConfigForbidden$48(NessieApiV2 api, RepositoryConfig created) throws Throwable {
        api.updateRepositoryConfig().repositoryConfig(created).update().getPrevious();
    }

    private /* synthetic */ void lambda$referencesUntyped$19(Reference ref0, Reference.ReferenceType anotherType) throws Throwable {
        ((DeleteReferenceBuilder)((DeleteReferenceBuilder)((DeleteReferenceBuilder)this.apiV2().deleteReference().refName(ref0.getName())).hash(ref0.getHash())).refType(anotherType)).delete();
    }

    private /* synthetic */ void lambda$referencesUntyped$18(Reference ref0) throws Throwable {
        ((DeleteReferenceBuilder)this.apiV2().deleteReference().refName(ref0.getName())).delete();
    }

    private /* synthetic */ void lambda$referencesUntyped$17(Reference ref0, Reference.ReferenceType anotherType, Branch main1) throws Throwable {
        ((AssignReferenceBuilder)((AssignReferenceBuilder)((AssignReferenceBuilder)this.apiV2().assignReference().refName(ref0.getName())).hash(ref0.getHash())).refType(anotherType)).assignTo((Reference)main1).assign();
    }

    private /* synthetic */ void lambda$referencesUntyped$16(Reference ref0, Branch main1) throws Throwable {
        ((AssignReferenceBuilder)this.apiV2().assignReference().refName(ref0.getName())).assignTo((Reference)main1).assign();
    }

    static {
        Locale.setDefault(Locale.ENGLISH);
    }
}

