/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.jaxrs.tests;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.restassured.RestAssured;
import io.restassured.builder.RequestSpecBuilder;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import io.restassured.specification.RequestSpecification;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.assertj.core.data.MapEntry;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.projectnessie.client.api.NessieApiV2;
import org.projectnessie.client.ext.NessieApiVersion;
import org.projectnessie.client.ext.NessieApiVersions;
import org.projectnessie.client.ext.NessieClientUri;
import org.projectnessie.error.ErrorCode;
import org.projectnessie.error.NessieError;
import org.projectnessie.error.ReferenceConflicts;
import org.projectnessie.jaxrs.tests.AbstractRelativeReferences;
import org.projectnessie.jaxrs.tests.BaseTestNessieApi;
import org.projectnessie.model.Branch;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.CommitResponse;
import org.projectnessie.model.Conflict;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.ContentResponse;
import org.projectnessie.model.DiffResponse;
import org.projectnessie.model.EntriesResponse;
import org.projectnessie.model.GetMultipleContentsRequest;
import org.projectnessie.model.GetMultipleContentsResponse;
import org.projectnessie.model.IcebergTable;
import org.projectnessie.model.ImmutableBranch;
import org.projectnessie.model.ImmutableOperations;
import org.projectnessie.model.Namespace;
import org.projectnessie.model.Operation;
import org.projectnessie.model.Reference;
import org.projectnessie.model.SingleReferenceResponse;
import org.projectnessie.model.Tag;

public abstract class BaseTestNessieRest
extends BaseTestNessieApi {
    protected URI clientUri;

    @BeforeEach
    public void enableLogging() {
        RestAssured.enableLoggingOfRequestAndResponseIfValidationFails();
    }

    @BeforeEach
    void setupRestUri(@NessieClientUri URI uri) {
        this.clientUri = uri;
        RestAssured.baseURI = uri.toString();
        RestAssured.port = uri.getPort();
    }

    @BeforeAll
    static void setupRestAssured() {
        RestAssured.requestSpecification = new RequestSpecBuilder().setContentType(ContentType.JSON).setAccept(ContentType.JSON).build();
    }

    protected static RequestSpecification rest() {
        return RestAssured.given().when().baseUri(RestAssured.baseURI).basePath("").contentType(ContentType.JSON);
    }

    private static Content withoutId(Content content) {
        if (content instanceof IcebergTable) {
            return IcebergTable.builder().from(content).id(null).build();
        }
        throw new IllegalArgumentException("Expected IcebergTable, got " + content);
    }

    private ValidatableResponse prepareCommitV1(ContentKey contentKey, Content content, Branch branch, int clientSpec, boolean buildMissingNamespaces) {
        ImmutableOperations.Builder contents = ImmutableOperations.builder().commitMeta((CommitMeta)CommitMeta.builder().author("test author").message("").build());
        if (buildMissingNamespaces) {
            if (contentKey.getElementCount() > 1) {
                contents.addOperations((Operation)Operation.Put.of((ContentKey)contentKey.getParent(), (Content)contentKey.getNamespace()));
            }
            if (contentKey.getElementCount() > 2) {
                contents.addOperations((Operation)Operation.Put.of((ContentKey)contentKey.getParent().getParent(), (Content)contentKey.getParent().getNamespace()));
            }
        }
        contents.addOperations((Operation)Operation.Put.of((ContentKey)contentKey, (Content)content));
        RequestSpecification resp = BaseTestNessieRest.rest().body((Object)contents.build());
        if (clientSpec > 0) {
            resp = resp.header("Nessie-Client-Spec", (Object)clientSpec, new Object[0]);
        }
        return (ValidatableResponse)((Response)resp.queryParam("expectedHash", new Object[]{branch.getHash()}).post("trees/branch/{branch}/commit", new Object[]{branch.getName()})).then();
    }

    private Branch commitV1(ContentKey contentKey, Content content, Branch branch) {
        return (Branch)((ValidatableResponse)this.prepareCommitV1(contentKey, content, branch, 2, true).statusCode(200)).extract().as(Branch.class);
    }

    private Branch createBranchV1(String name) {
        Branch main = (Branch)((ValidatableResponse)((ValidatableResponse)((Response)BaseTestNessieRest.rest().get("trees/tree", new Object[0])).then()).statusCode(200)).extract().as(Branch.class);
        ImmutableBranch test = ImmutableBranch.builder().name(name).hash(main.getHash()).build();
        return (Branch)((ValidatableResponse)((ValidatableResponse)((Response)BaseTestNessieRest.rest().body((Object)test).post("trees/tree", new Object[0])).then()).statusCode(200)).extract().as(Branch.class);
    }

    @ParameterizedTest
    @ValueSource(strings={"trees/not-there-using", "contents/not-there-using", "something/not-there-using", ""})
    public void testNotFoundUrls(String path) {
        ((ValidatableResponse)((Response)BaseTestNessieRest.rest().get(path, new Object[0])).then()).statusCode(404);
        ((ValidatableResponse)((Response)BaseTestNessieRest.rest().head(path, new Object[0])).then()).statusCode(404);
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V1})
    public void testReferenceConflictDetailsV1() {
        ContentKey key = ContentKey.of((String[])new String[]{"namespace", "foo"});
        IcebergTable table = IcebergTable.of((String)"content-table1", (long)42L, (int)42, (int)42, (int)42);
        Branch branch = this.createBranchV1("ref-conflicts");
        NessieError nessieError = (NessieError)((ValidatableResponse)this.prepareCommitV1(key, (Content)table, branch, 2, false).statusCode(409)).extract().as(NessieError.class);
        this.soft.assertThat((Comparable)nessieError.getErrorCode()).isEqualTo((Object)ErrorCode.REFERENCE_CONFLICT);
        ((ListAssert)((ListAssert)((ObjectAssert)((ObjectAssert)this.soft.assertThat((Object)nessieError.getErrorDetails()).isNotNull()).asInstanceOf(InstanceOfAssertFactories.type(ReferenceConflicts.class))).extracting(ReferenceConflicts::conflicts, InstanceOfAssertFactories.list(Conflict.class))).hasSize(1)).extracting(Conflict::conflictType).containsExactly((Object[])new Conflict.ConflictType[]{Conflict.ConflictType.NAMESPACE_ABSENT});
        nessieError = (NessieError)((ValidatableResponse)this.prepareCommitV1(key, (Content)table, branch, 1, false).statusCode(409)).extract().as(NessieError.class);
        this.soft.assertThat((Comparable)nessieError.getErrorCode()).isEqualTo((Object)ErrorCode.REFERENCE_CONFLICT);
        this.soft.assertThat((Object)nessieError.getErrorDetails()).isNull();
        nessieError = (NessieError)((ValidatableResponse)this.prepareCommitV1(key, (Content)table, branch, 0, false).statusCode(409)).extract().as(NessieError.class);
        this.soft.assertThat((Comparable)nessieError.getErrorCode()).isEqualTo((Object)ErrorCode.REFERENCE_CONFLICT);
        this.soft.assertThat((Object)nessieError.getErrorDetails()).isNull();
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    public void testReferenceConflictDetailsV2() {
        ContentKey key = ContentKey.of((String[])new String[]{"namespace", "foo"});
        IcebergTable table = IcebergTable.of((String)"content-table1", (long)42L, (int)42, (int)42, (int)42);
        Branch branch = this.createBranchV2("ref-conflicts");
        NessieError nessieError = (NessieError)((ValidatableResponse)this.prepareCommitV2(branch, key, table, 2, false).statusCode(409)).extract().as(NessieError.class);
        this.soft.assertThat((Comparable)nessieError.getErrorCode()).isEqualTo((Object)ErrorCode.REFERENCE_CONFLICT);
        ((ListAssert)((ListAssert)((ObjectAssert)((ObjectAssert)this.soft.assertThat((Object)nessieError.getErrorDetails()).isNotNull()).asInstanceOf(InstanceOfAssertFactories.type(ReferenceConflicts.class))).extracting(ReferenceConflicts::conflicts, InstanceOfAssertFactories.list(Conflict.class))).hasSize(1)).extracting(Conflict::conflictType).containsExactly((Object[])new Conflict.ConflictType[]{Conflict.ConflictType.NAMESPACE_ABSENT});
        nessieError = (NessieError)((ValidatableResponse)this.prepareCommitV2(branch, key, table, 1, false).statusCode(409)).extract().as(NessieError.class);
        this.soft.assertThat((Comparable)nessieError.getErrorCode()).isEqualTo((Object)ErrorCode.REFERENCE_CONFLICT);
        this.soft.assertThat((Object)nessieError.getErrorDetails()).isNull();
        nessieError = (NessieError)((ValidatableResponse)this.prepareCommitV2(branch, key, table, 0, false).statusCode(409)).extract().as(NessieError.class);
        this.soft.assertThat((Comparable)nessieError.getErrorCode()).isEqualTo((Object)ErrorCode.REFERENCE_CONFLICT);
        this.soft.assertThat((Object)nessieError.getErrorDetails()).isNull();
    }

    @NessieApiVersions(versions={NessieApiVersion.V1})
    @ParameterizedTest
    @CsvSource(value={"simple,name", "simple,dotted.txt", "dotted.prefix,name", "dotted.prefix,dotted.txt"})
    public void testGetContent(String ns, String name) throws JsonProcessingException {
        Branch branch = this.createBranchV1("content-test-" + UUID.randomUUID());
        IcebergTable table = IcebergTable.of((String)"content-table1", (long)42L, (int)42, (int)42, (int)42);
        ContentKey key = ContentKey.of((String[])new String[]{ns, name});
        branch = this.commitV1(key, (Content)table, branch);
        Content content = (Content)((ValidatableResponse)((ValidatableResponse)((Response)BaseTestNessieRest.rest().queryParam("ref", new Object[]{branch.getName()}).queryParam("hashOnRef", new Object[]{branch.getHash()}).get(String.format("contents/%s", key.toPathString()), new Object[0])).then()).statusCode(200)).extract().as(Content.class);
        this.soft.assertThat((Object)BaseTestNessieRest.withoutId(content)).isEqualTo((Object)table);
        String response = ((ValidatableResponse)((ValidatableResponse)((Response)BaseTestNessieRest.rest().queryParam("ref", new Object[]{branch.getName()}).queryParam("hashOnRef", new Object[]{branch.getHash()}).body((Object)GetMultipleContentsRequest.of((ContentKey[])new ContentKey[]{key})).post("contents", new Object[0])).then()).statusCode(200)).extract().asString();
        this.soft.assertThat(response).doesNotContain(new CharSequence[]{"effectiveReference"});
        GetMultipleContentsResponse multi = (GetMultipleContentsResponse)new ObjectMapper().readValue(response, GetMultipleContentsResponse.class);
        this.soft.assertThat((Object)BaseTestNessieRest.withoutId((Content)multi.toContentsMap().get(key))).isEqualTo((Object)table);
        this.soft.assertThat((Object)multi.getEffectiveReference()).isNull();
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V1})
    public void testGetUnknownContentType() {
        String nsName = "foo";
        String branchName = "unknown-content-type";
        String path = String.format("namespaces/namespace/%s/%s", branchName, nsName);
        this.createBranchV1(branchName);
        Namespace ns = Namespace.of((String[])new String[]{"id"});
        NessieError error = (NessieError)((ValidatableResponse)((ValidatableResponse)((Response)BaseTestNessieRest.rest().body((Object)ns).contentType(ContentType.TEXT).put(path, new Object[0])).then()).statusCode(415)).extract().as(NessieError.class);
        Assertions.assertThat((String)error.getReason()).containsIgnoringCase((CharSequence)"Unsupported Media Type");
        ((ValidatableResponse)((Response)BaseTestNessieRest.rest().body((Object)ns).put(path, new Object[0])).then()).statusCode(200);
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V1})
    public void testNullMergePayload() {
        NessieError response = (NessieError)((ValidatableResponse)((ValidatableResponse)((Response)BaseTestNessieRest.rest().post("trees/branch/main/merge", new Object[0])).then()).statusCode(400)).extract().as(NessieError.class);
        Assertions.assertThat((String)response.getMessage()).contains(new CharSequence[]{".merge: must not be null"});
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V1})
    public void testNullTagPayload() {
        NessieError response = (NessieError)((ValidatableResponse)((ValidatableResponse)((Response)BaseTestNessieRest.rest().put("trees/tag/newTag", new Object[0])).then()).statusCode(400)).extract().as(NessieError.class);
        Assertions.assertThat((String)response.getMessage()).contains(new CharSequence[]{".assignTo: must not be null"});
        Assertions.assertThat((String)response.getMessage()).contains(new CharSequence[]{".expectedHash: must not be null"});
    }

    @NessieApiVersions(versions={NessieApiVersion.V1})
    @ParameterizedTest
    @ValueSource(strings={"", "abc'", ".foo", "abc'def'..'blah", "abc'de..blah", "abc'de@{blah"})
    public void testInvalidTag(String invalidTagName) {
        String validHash = "0011223344556677";
        String validRefName = "hello";
        org.junit.jupiter.api.Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertThat((String)((NessieError)((ValidatableResponse)((ValidatableResponse)((Response)BaseTestNessieRest.rest().body("{\"type\": \"TAG\", \"name\": \"" + invalidTagName + "\", \"hash\": \"" + validHash + "\"}").put("trees/tag/" + validRefName, new Object[0])).then()).statusCode(400)).extract().as(NessieError.class)).getMessage()).contains(new CharSequence[]{"Cannot construct instance of `org.projectnessie.model.ImmutableTag`, problem: Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..' - but was: " + invalidTagName + "\n"}), () -> Assertions.assertThat((String)((NessieError)((ValidatableResponse)((ValidatableResponse)((Response)BaseTestNessieRest.rest().body("{\"type\": \"TAG\", \"name\": \"" + invalidTagName + "\", \"hash\": \"" + validHash + "\"}").put("trees/tag/" + validRefName, new Object[0])).then()).statusCode(400)).extract().as(NessieError.class)).getMessage()).contains(new CharSequence[]{"Cannot construct instance of `org.projectnessie.model.ImmutableTag`, problem: Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'"}), () -> Assertions.assertThat((String)((NessieError)((ValidatableResponse)((ValidatableResponse)((Response)BaseTestNessieRest.rest().body("{\"type\": \"FOOBAR\", \"name\": \"" + validRefName + "\", \"hash\": \"" + validHash + "\"}").put("trees/tag/" + validRefName, new Object[0])).then()).statusCode(400)).extract().as(NessieError.class)).getMessage()).contains(new CharSequence[]{"Could not resolve type id 'FOOBAR' as a subtype of `org.projectnessie.model.Reference`"})});
    }

    Branch createBranchV2(String branchName) {
        Reference main = ((SingleReferenceResponse)((ValidatableResponse)((ValidatableResponse)((Response)BaseTestNessieRest.rest().get("trees/-", new Object[0])).then()).statusCode(200)).extract().as(SingleReferenceResponse.class)).getReference();
        return this.createBranchV2(branchName, main);
    }

    Branch createBranchV2(String branchName, Reference ref) {
        return (Branch)((SingleReferenceResponse)((ValidatableResponse)((ValidatableResponse)((Response)BaseTestNessieRest.rest().queryParam("name", new Object[]{branchName}).queryParam("type", new Object[]{Reference.ReferenceType.BRANCH.name()}).body((Object)ref).post("trees", new Object[0])).then()).statusCode(200)).extract().as(SingleReferenceResponse.class)).getReference();
    }

    Tag createTagV2(String tagName, Reference ref) {
        return (Tag)((SingleReferenceResponse)((ValidatableResponse)((ValidatableResponse)((Response)BaseTestNessieRest.rest().queryParam("name", new Object[]{tagName}).queryParam("type", new Object[]{Reference.ReferenceType.TAG.name()}).body((Object)ref).post("trees", new Object[0])).then()).statusCode(200)).extract().as(SingleReferenceResponse.class)).getReference();
    }

    ValidatableResponse prepareCommitV2(Branch branch, ContentKey key, IcebergTable table, int clientSpec, boolean buildMissingNamespaces) {
        return this.prepareCommitV2(branch.toPathString(), key, table, clientSpec, buildMissingNamespaces);
    }

    ValidatableResponse prepareCommitV2(String ref, ContentKey key, IcebergTable table, int clientSpec, boolean buildMissingNamespaces) {
        ImmutableOperations.Builder ops = ImmutableOperations.builder().commitMeta(CommitMeta.fromMessage((String)"test commit"));
        if (buildMissingNamespaces) {
            if (key.getElementCount() > 1) {
                ops.addOperations((Operation)Operation.Put.of((ContentKey)key.getParent(), (Content)key.getNamespace()));
            }
            if (key.getElementCount() > 2) {
                ops.addOperations((Operation)Operation.Put.of((ContentKey)key.getParent().getParent(), (Content)key.getParent().getNamespace()));
            }
        }
        ops.addOperations((Operation)Operation.Put.of((ContentKey)key, (Content)table));
        RequestSpecification resp = BaseTestNessieRest.rest().body((Object)ops.build());
        if (clientSpec > 0) {
            resp = resp.header("Nessie-Client-Spec", (Object)clientSpec, new Object[0]);
        }
        return (ValidatableResponse)((Response)resp.post("trees/{ref}/history/commit", new Object[]{ref})).then();
    }

    ValidatableResponse prepareMergeV2(String targetRefAndHash, String fromRefName, String fromHash, int clientSpec) {
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("fromRefName", fromRefName);
        body.put("fromHash", fromHash);
        RequestSpecification resp = BaseTestNessieRest.rest().body(body);
        if (clientSpec > 0) {
            resp = resp.header("Nessie-Client-Spec", (Object)clientSpec, new Object[0]);
        }
        return (ValidatableResponse)((Response)resp.post("trees/{ref}/history/merge", new Object[]{targetRefAndHash})).then();
    }

    ValidatableResponse prepareTransplantV2(String targetRefAndHash, String fromRefName, List<String> hashesToTransplant, int clientSpec) {
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("fromRefName", fromRefName);
        body.put("hashesToTransplant", hashesToTransplant);
        RequestSpecification resp = BaseTestNessieRest.rest().body(body);
        if (clientSpec > 0) {
            resp = resp.header("Nessie-Client-Spec", (Object)clientSpec, new Object[0]);
        }
        return (ValidatableResponse)((Response)resp.post("trees/{ref}/history/transplant", new Object[]{targetRefAndHash})).then();
    }

    Branch commitV2(Branch branch, ContentKey key, IcebergTable table) {
        return ((CommitResponse)((ValidatableResponse)this.prepareCommitV2(branch, key, table, 2, true).statusCode(200)).extract().as(CommitResponse.class)).getTargetBranch();
    }

    private Content getContentV2(Reference reference, ContentKey key) {
        return ((ContentResponse)((ValidatableResponse)((ValidatableResponse)((Response)BaseTestNessieRest.rest().get("trees/{ref}/contents/{key}", new Object[]{reference.toPathString(), key.toPathString()})).then()).statusCode(200)).extract().as(ContentResponse.class)).getContent();
    }

    @NessieApiVersions(versions={NessieApiVersion.V2})
    @ParameterizedTest
    @CsvSource(value={"simple1,testKey", "simple2,test.Key", "simple3,test\u001dKey", "simple4,test\u001dnested.Key", "with/slash1,testKey", "with/slash2,test.Key", "with/slash3,test\u001dKey", "with/slash4,test\u001d.nested.Key"})
    void testGetSingleContent(String branchName, String encodedKey) {
        Branch branch = this.createBranchV2(branchName);
        ContentKey key = ContentKey.fromPathString((String)encodedKey);
        IcebergTable table = IcebergTable.of((String)"test-location", (long)1L, (int)2, (int)3, (int)4);
        branch = this.commitV2(branch, key, table);
        ((ObjectAssert)Assertions.assertThat((Object)this.getContentV2((Reference)branch, key)).asInstanceOf(InstanceOfAssertFactories.type(IcebergTable.class))).extracting(IcebergTable::getMetadataLocation).isEqualTo((Object)"test-location");
    }

    @NessieApiVersions(versions={NessieApiVersion.V2})
    @ParameterizedTest
    @ValueSource(strings={"simple", "with/slash"})
    void testGetSeveralContents(String branchName) {
        Branch branch = this.createBranchV2(branchName);
        ContentKey key1 = ContentKey.of((String[])new String[]{"test", "Key"});
        ContentKey key2 = ContentKey.of((String[])new String[]{"test.with.dot", "Key"});
        IcebergTable table1 = IcebergTable.of((String)"loc1", (long)1L, (int)2, (int)3, (int)4);
        IcebergTable table2 = IcebergTable.of((String)"loc2", (long)1L, (int)2, (int)3, (int)4);
        branch = this.commitV2(branch, key1, table1);
        branch = this.commitV2(branch, key2, table2);
        EntriesResponse entries = (EntriesResponse)((ValidatableResponse)((ValidatableResponse)((Response)BaseTestNessieRest.rest().get("trees/{ref}/entries", new Object[]{branch.toPathString()})).then()).statusCode(200)).extract().as(EntriesResponse.class);
        ((ListAssert)Assertions.assertThat((List)entries.getEntries()).hasSize(4)).allSatisfy(e -> Assertions.assertThat((String)e.getContentId()).isNotNull());
        Stream<MapEntry> contents = ((GetMultipleContentsResponse)((ValidatableResponse)((ValidatableResponse)((Response)BaseTestNessieRest.rest().queryParam("key", new Object[]{key1.toPathString(), key2.toPathString()}).get("trees/{ref}/contents", new Object[]{branch.toPathString()})).then()).statusCode(200)).extract().as(GetMultipleContentsResponse.class)).getContents().stream().map(content -> Assertions.entry((Object)content.getKey(), (Object)((IcebergTable)content.getContent()).getMetadataLocation()));
        Assertions.assertThat(contents).containsExactlyInAnyOrder((Object[])new MapEntry[]{Assertions.entry((Object)key1, (Object)"loc1"), Assertions.entry((Object)key2, (Object)"loc2")});
    }

    @NessieApiVersions(versions={NessieApiVersion.V2})
    @Test
    void testBranchWithSlashInUrlPath(@NessieClientUri URI clientUri) throws IOException {
        Branch branch = this.createBranchV2("test/branch/name1");
        Assertions.assertThat((Object)((SingleReferenceResponse)((ValidatableResponse)((ValidatableResponse)((Response)BaseTestNessieRest.rest().get("trees/test/branch/name1@", new Object[0])).then()).statusCode(200)).extract().as(SingleReferenceResponse.class)).getReference()).isEqualTo((Object)branch);
        URL url = clientUri.resolve(clientUri.getPath() + "/trees/test/branch/name1@").toURL();
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        Assertions.assertThat((int)conn.getResponseCode()).isEqualTo(200);
        conn.disconnect();
    }

    @NessieApiVersions(versions={NessieApiVersion.V2})
    @Test
    void testDefaultBranchSpecInUrlPath() {
        Reference main = ((SingleReferenceResponse)((ValidatableResponse)((ValidatableResponse)((Response)BaseTestNessieRest.rest().get("trees/-", new Object[0])).then()).statusCode(200)).extract().as(SingleReferenceResponse.class)).getReference();
        Assertions.assertThat((String)main.getName()).isEqualTo("main");
        Branch branch = this.createBranchV2("testDefaultBranchSpecInUrlPath");
        ContentKey key = ContentKey.of((String[])new String[]{"test1"});
        this.commitV2(branch, key, IcebergTable.of((String)"loc", (long)1L, (int)2, (int)3, (int)4));
        Assertions.assertThat((List)((DiffResponse)((ValidatableResponse)((ValidatableResponse)((Response)BaseTestNessieRest.rest().get("trees/-/diff/{name}", new Object[]{branch.getName()})).then()).statusCode(200)).extract().as(DiffResponse.class)).getDiffs()).satisfiesExactly(new ThrowingConsumer[]{e -> Assertions.assertThat((Comparable)e.getKey()).isEqualTo((Object)key)});
        Assertions.assertThat((List)((DiffResponse)((ValidatableResponse)((ValidatableResponse)((Response)BaseTestNessieRest.rest().get("trees/{name}/diff/-", new Object[]{branch.getName()})).then()).statusCode(200)).extract().as(DiffResponse.class)).getDiffs()).satisfiesExactly(new ThrowingConsumer[]{e -> Assertions.assertThat((Comparable)e.getKey()).isEqualTo((Object)key)});
        Assertions.assertThat((List)((DiffResponse)((ValidatableResponse)((ValidatableResponse)((Response)BaseTestNessieRest.rest().get("trees/-/diff/-", new Object[0])).then()).statusCode(200)).extract().as(DiffResponse.class)).getDiffs()).isEmpty();
    }

    @NessieApiVersions(versions={NessieApiVersion.V2})
    @Test
    public void testCommitMetaAttributes() {
        Branch branch = this.createBranchV2("testCommitMetaAttributes");
        this.commitV2(branch, ContentKey.of((String[])new String[]{"test-key"}), IcebergTable.of((String)"meta", (long)1L, (int)2, (int)3, (int)4));
        String response = ((ValidatableResponse)((ValidatableResponse)((Response)BaseTestNessieRest.rest().get("trees/{ref}/history", new Object[]{branch.getName()})).then()).statusCode(200)).extract().asString();
        ((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)response).doesNotContain(new CharSequence[]{"\"author\""})).contains(new CharSequence[]{"\"authors\""})).doesNotContain(new CharSequence[]{"\"signedOffBy\""})).contains(new CharSequence[]{"allSignedOffBy"});
    }

    @NessieApiVersions(versions={NessieApiVersion.V2})
    @Test
    public void referenceTypeInvalidValue() {
        NessieError nessieError = (NessieError)((ValidatableResponse)((ValidatableResponse)((Response)BaseTestNessieRest.rest().delete("trees/test@2e1cfa82b035c26cbbbdae632cea070514eb8b773f616aaeaf668e2f0be8f10d?type=X", new Object[0])).then()).statusCode(400)).extract().as(NessieError.class);
        this.soft.assertThat((Object)nessieError).extracting(new Function[]{NessieError::getStatus, NessieError::getErrorCode}).containsExactly(new Object[]{400, ErrorCode.BAD_REQUEST});
        this.soft.assertThat(nessieError.getMessage()).contains(new CharSequence[]{"Reference type name must be either 'branch' or 'tag'"});
        nessieError = (NessieError)((ValidatableResponse)((ValidatableResponse)((Response)BaseTestNessieRest.rest().body("{\"type\": \"TAG\", \"name\": \"name\", \"hash\": \"feedbeef\"}").put("trees/test@2e1cfa82b035c26cbbbdae632cea070514eb8b773f616aaeaf668e2f0be8f10d?type=X", new Object[0])).then()).statusCode(400)).extract().as(NessieError.class);
        this.soft.assertThat((Object)nessieError).extracting(new Function[]{NessieError::getStatus, NessieError::getErrorCode}).containsExactly(new Object[]{400, ErrorCode.BAD_REQUEST});
        this.soft.assertThat(nessieError.getMessage()).contains(new CharSequence[]{"Reference type name must be either 'branch' or 'tag'"});
        nessieError = (NessieError)((ValidatableResponse)((ValidatableResponse)((Response)BaseTestNessieRest.rest().queryParam("name", new Object[]{"branch"}).queryParam("type", new Object[]{"X"}).post("trees", new Object[0])).then()).statusCode(400)).extract().as(NessieError.class);
        this.soft.assertThat((Object)nessieError).extracting(new Function[]{NessieError::getStatus, NessieError::getErrorCode}).containsExactly(new Object[]{400, ErrorCode.BAD_REQUEST});
        this.soft.assertThat(nessieError.getMessage()).contains(new CharSequence[]{"Reference type name must be either 'branch' or 'tag'"});
    }

    @Test
    @NessieApiVersions(versions={NessieApiVersion.V2})
    public void getRefByNameHashNotAllowed() {
        NessieError nessieError = (NessieError)((ValidatableResponse)((ValidatableResponse)((Response)BaseTestNessieRest.rest().get("trees/main@12345678", new Object[0])).then()).statusCode(400)).extract().as(NessieError.class);
        this.soft.assertThat((Object)nessieError).extracting(new Function[]{NessieError::getStatus, NessieError::getErrorCode}).containsExactly(new Object[]{400, ErrorCode.BAD_REQUEST});
        this.soft.assertThat(nessieError.getMessage()).contains(new CharSequence[]{"Hashes are not allowed when fetching a reference by name"});
    }

    @NessieApiVersions(versions={NessieApiVersion.V2})
    @Test
    public void assignAndDeleteRefWithoutType() throws Exception {
        Branch branch = this.createBranchV2("assignAndDeleteRefWithoutType");
        String initial = branch.getHash();
        branch = this.commitV2(branch, ContentKey.of((String[])new String[]{"foo"}), IcebergTable.of((String)"a", (long)1L, (int)2, (int)3, (int)4));
        NessieApiV2 api = this.apiV2();
        Branch testBranch1 = (Branch)api.createReference().sourceRefName(branch.getName()).reference((Reference)Branch.of((String)"branch1", (String)branch.getHash())).create();
        Branch testBranch2 = (Branch)api.createReference().sourceRefName(branch.getName()).reference((Reference)Branch.of((String)"branch2", (String)branch.getHash())).create();
        Tag testTag1 = (Tag)api.createReference().sourceRefName(branch.getName()).reference((Reference)Tag.of((String)"tag1", (String)branch.getHash())).create();
        Tag testTag2 = (Tag)api.createReference().sourceRefName(branch.getName()).reference((Reference)Tag.of((String)"tag2", (String)branch.getHash())).create();
        this.soft.assertThat((Object)((SingleReferenceResponse)((ValidatableResponse)((ValidatableResponse)((Response)BaseTestNessieRest.rest().body("{\"type\": \"BRANCH\", \"name\": \"" + testBranch1.getName() + "\", \"hash\": \"" + initial + "\"}").put("trees/{name}@{hash}", new Object[]{testBranch1.getName(), testBranch1.getHash()})).then()).statusCode(200)).extract().as(SingleReferenceResponse.class))).extracting(SingleReferenceResponse::getReference).isEqualTo((Object)Branch.of((String)testBranch1.getName(), (String)initial));
        this.soft.assertThat((Object)((SingleReferenceResponse)((ValidatableResponse)((ValidatableResponse)((Response)BaseTestNessieRest.rest().delete("trees/{name}@{hash}", new Object[]{testBranch2.getName(), testBranch2.getHash()})).then()).statusCode(200)).extract().as(SingleReferenceResponse.class))).extracting(SingleReferenceResponse::getReference).isEqualTo((Object)testBranch2);
        this.soft.assertThat((Object)((SingleReferenceResponse)((ValidatableResponse)((ValidatableResponse)((Response)BaseTestNessieRest.rest().body("{\"type\": \"TAG\", \"name\": \"" + testTag1.getName() + "\", \"hash\": \"" + initial + "\"}").put("trees/{name}@{hash}", new Object[]{testTag1.getName(), testTag1.getHash()})).then()).statusCode(200)).extract().as(SingleReferenceResponse.class))).extracting(SingleReferenceResponse::getReference).isEqualTo((Object)Tag.of((String)"tag1", (String)initial));
        this.soft.assertThat((Object)((SingleReferenceResponse)((ValidatableResponse)((ValidatableResponse)((Response)BaseTestNessieRest.rest().delete("trees/{name}@{hash}", new Object[]{testTag2.getName(), testTag2.getHash()})).then()).statusCode(200)).extract().as(SingleReferenceResponse.class))).extracting(SingleReferenceResponse::getReference).isEqualTo((Object)testTag2);
    }

    @Nested
    @NessieApiVersions(versions={NessieApiVersion.V2})
    public class RelativeReferences
    extends AbstractRelativeReferences {
        protected RelativeReferences() {
            super(BaseTestNessieRest.this);
        }
    }
}

