/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.jaxrs.tests;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.projectnessie.client.http.HttpResponse;
import org.projectnessie.client.http.HttpResponseFactory;
import org.projectnessie.client.http.ResponseContext;

public class ValidatingApiV1ResponseFactory
implements HttpResponseFactory {
    private static final List<String> API_V2_ATTRIBUTES = ImmutableList.of((Object)"\"contentId\"", (Object)"\"effectiveReference\"", (Object)"\"authors\"", (Object)"\"allSignedOffBy\"", (Object)"\"addedContents\"", (Object)"\"effectiveFromReference\"");

    public HttpResponse make(final ResponseContext context, final ObjectMapper mapper) {
        return new HttpResponse(context, mapper){

            public <V> V readEntity(Class<V> clazz) {
                try {
                    JsonNode jsonNode = (JsonNode)mapper.readValue(context.getInputStream(), JsonNode.class);
                    String jsonString = jsonNode.toPrettyString();
                    Assertions.assertThat((String)jsonString).doesNotContain(API_V2_ATTRIBUTES);
                    return (V)mapper.readerFor(clazz).readValue(jsonNode);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }
}

