/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.api.v2.params;

import java.util.List;
import javax.annotation.Nullable;
import javax.ws.rs.QueryParam;
import org.eclipse.microprofile.openapi.annotations.media.ExampleObject;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;
import org.immutables.builder.Builder;
import org.projectnessie.api.v2.params.EntriesParamsBuilder;
import org.projectnessie.api.v2.params.KeyRangeParams;
import org.projectnessie.model.ContentKey;

public class EntriesParams
extends KeyRangeParams<EntriesParams> {
    @Parameter(description="Restrict the result to one or more keys.\n\nCan be combined with min/max-key and prefix-key parameters, however both predicates must match. This means that keys specified via this parameter that do not match a given min/max-key or prefix-key will not be returned.\n\nContent key and namespace components are separated by the dot (`.`) character.\nThe components itself must be escaped using the rules described in [NESSIE-SPEC-2.0.md in the repository](https://github.com/projectnessie/nessie/blob/main/api/NESSIE-SPEC-2-0.md).")
    @QueryParam(value="key")
    @jakarta.ws.rs.QueryParam(value="key")
    private List<ContentKey> requestedKeys;
    @Nullable
    @jakarta.annotation.Nullable
    @Parameter(description="A Common Expression Language (CEL) expression. An intro to CEL can be found at https://github.com/google/cel-spec/blob/master/doc/intro.md.\nUsable variables within the expression are 'entry.namespace' (string) & 'entry.contentType' (string)", examples={@ExampleObject(ref="expr_by_namespace"), @ExampleObject(ref="expr_by_contentType"), @ExampleObject(ref="expr_by_namespace_and_contentType")})
    @QueryParam(value="filter")
    @jakarta.ws.rs.QueryParam(value="filter")
    private String filter;
    @Nullable
    @jakarta.annotation.Nullable
    @Parameter(description="Optionally request to return 'Content' objects for the returned keys.")
    @QueryParam(value="content")
    @jakarta.ws.rs.QueryParam(value="content")
    private Boolean withContent;

    public EntriesParams() {
    }

    @Builder.Constructor
    EntriesParams(@Nullable @jakarta.annotation.Nullable Integer maxRecords, @Nullable @jakarta.annotation.Nullable String pageToken, @Nullable @jakarta.annotation.Nullable ContentKey minKey, @Nullable @jakarta.annotation.Nullable ContentKey maxKey, @Nullable @jakarta.annotation.Nullable ContentKey prefixKey, @Nullable @jakarta.annotation.Nullable List<ContentKey> requestedKeys, @Nullable @jakarta.annotation.Nullable String filter, @Nullable @jakarta.annotation.Nullable Boolean withContent) {
        super(maxRecords, pageToken, minKey, maxKey, prefixKey);
        this.filter = filter;
        this.withContent = withContent;
        this.requestedKeys = requestedKeys;
    }

    public static EntriesParamsBuilder builder() {
        return new EntriesParamsBuilder();
    }

    public static EntriesParams empty() {
        return EntriesParams.builder().build();
    }

    public List<ContentKey> getRequestedKeys() {
        return this.requestedKeys;
    }

    @Nullable
    @jakarta.annotation.Nullable
    public String filter() {
        return this.filter;
    }

    public boolean withContent() {
        return this.withContent != null && this.withContent != false;
    }

    @Override
    public EntriesParams forNextPage(String pageToken) {
        return new EntriesParams(this.maxRecords(), pageToken, this.minKey(), this.maxKey(), this.prefixKey(), this.requestedKeys, this.filter, this.withContent);
    }
}

