/*
 * Copyright (C) 2023 Dremio
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.List;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.tags.Tag;
import org.immutables.value.Value;

@Schema(type = SchemaType.OBJECT, title = "RepositoryConfigResponse")
@Tag(name = "v2")
@Value.Immutable
@JsonSerialize(as = ImmutableRepositoryConfigResponse.class)
@JsonDeserialize(as = ImmutableRepositoryConfigResponse.class)
public interface RepositoryConfigResponse {
  @JsonInclude(JsonInclude.Include.NON_EMPTY)
  @Schema(
      title = "Repository configuration objects for the requested types.",
      description =
          "The existing configuration objects for the requested types will be returned. "
              + "Non-existing config objects will not be returned.")
  List<RepositoryConfig> getConfigs();
}
