/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.model.Conflict;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.MergeBehavior;
import org.projectnessie.model.MergeResponse;
import org.projectnessie.model.ser.Views;

@ParametersAreNonnullByDefault
@Generated(from="MergeResponse.ContentKeyDetails", generator="Immutables")
@Immutable
public final class ImmutableContentKeyDetails
implements MergeResponse.ContentKeyDetails {
    private final ContentKey key;
    private final MergeBehavior mergeBehavior;
    private final MergeResponse.ContentKeyConflict conflictType;
    private final List<String> sourceCommits;
    private final List<String> targetCommits;
    @Nullable
    private final Conflict conflict;

    private ImmutableContentKeyDetails(Builder builder) {
        this.key = builder.key;
        this.mergeBehavior = builder.mergeBehavior;
        this.sourceCommits = ImmutableContentKeyDetails.createUnmodifiableList(true, builder.sourceCommits);
        this.targetCommits = ImmutableContentKeyDetails.createUnmodifiableList(true, builder.targetCommits);
        this.conflict = builder.conflict;
        this.conflictType = builder.conflictType != null ? builder.conflictType : Objects.requireNonNull(MergeResponse.ContentKeyDetails.super.getConflictType(), "conflictType");
    }

    private ImmutableContentKeyDetails(ContentKey key, MergeBehavior mergeBehavior, MergeResponse.ContentKeyConflict conflictType, List<String> sourceCommits, List<String> targetCommits, @Nullable Conflict conflict) {
        this.key = key;
        this.mergeBehavior = mergeBehavior;
        this.conflictType = conflictType;
        this.sourceCommits = sourceCommits;
        this.targetCommits = targetCommits;
        this.conflict = conflict;
    }

    @Override
    @JsonProperty(value="key")
    public ContentKey getKey() {
        return this.key;
    }

    @Override
    @JsonProperty(value="mergeBehavior")
    public MergeBehavior getMergeBehavior() {
        return this.mergeBehavior;
    }

    @Override
    @JsonProperty(value="conflictType")
    @JsonDeserialize(using=MergeResponse.ContentKeyConflict.Deserializer.class)
    @JsonView(value={Views.V1.class})
    @Deprecated
    public MergeResponse.ContentKeyConflict getConflictType() {
        return this.conflictType;
    }

    @Override
    @JsonProperty(value="sourceCommits")
    @JsonView(value={Views.V1.class})
    @Deprecated
    public List<String> getSourceCommits() {
        return this.sourceCommits;
    }

    @Override
    @JsonProperty(value="targetCommits")
    @JsonView(value={Views.V1.class})
    @Deprecated
    public List<String> getTargetCommits() {
        return this.targetCommits;
    }

    @Override
    @JsonProperty(value="conflict")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonView(value={Views.V2.class})
    @Nullable
    public Conflict getConflict() {
        return this.conflict;
    }

    public final ImmutableContentKeyDetails withKey(ContentKey value) {
        if (this.key == value) {
            return this;
        }
        ContentKey newValue = Objects.requireNonNull(value, "key");
        return new ImmutableContentKeyDetails(newValue, this.mergeBehavior, this.conflictType, this.sourceCommits, this.targetCommits, this.conflict);
    }

    public final ImmutableContentKeyDetails withMergeBehavior(MergeBehavior value) {
        MergeBehavior newValue = Objects.requireNonNull(value, "mergeBehavior");
        if (this.mergeBehavior == newValue) {
            return this;
        }
        return new ImmutableContentKeyDetails(this.key, newValue, this.conflictType, this.sourceCommits, this.targetCommits, this.conflict);
    }

    @Deprecated
    public final ImmutableContentKeyDetails withConflictType(MergeResponse.ContentKeyConflict value) {
        MergeResponse.ContentKeyConflict newValue = Objects.requireNonNull(value, "conflictType");
        if (this.conflictType == newValue) {
            return this;
        }
        return new ImmutableContentKeyDetails(this.key, this.mergeBehavior, newValue, this.sourceCommits, this.targetCommits, this.conflict);
    }

    @Deprecated
    public final ImmutableContentKeyDetails withSourceCommits(String ... elements) {
        List<String> newValue = ImmutableContentKeyDetails.createUnmodifiableList(false, ImmutableContentKeyDetails.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableContentKeyDetails(this.key, this.mergeBehavior, this.conflictType, newValue, this.targetCommits, this.conflict);
    }

    @Deprecated
    public final ImmutableContentKeyDetails withSourceCommits(Iterable<String> elements) {
        if (this.sourceCommits == elements) {
            return this;
        }
        List<String> newValue = ImmutableContentKeyDetails.createUnmodifiableList(false, ImmutableContentKeyDetails.createSafeList(elements, true, false));
        return new ImmutableContentKeyDetails(this.key, this.mergeBehavior, this.conflictType, newValue, this.targetCommits, this.conflict);
    }

    @Deprecated
    public final ImmutableContentKeyDetails withTargetCommits(String ... elements) {
        List<String> newValue = ImmutableContentKeyDetails.createUnmodifiableList(false, ImmutableContentKeyDetails.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableContentKeyDetails(this.key, this.mergeBehavior, this.conflictType, this.sourceCommits, newValue, this.conflict);
    }

    @Deprecated
    public final ImmutableContentKeyDetails withTargetCommits(Iterable<String> elements) {
        if (this.targetCommits == elements) {
            return this;
        }
        List<String> newValue = ImmutableContentKeyDetails.createUnmodifiableList(false, ImmutableContentKeyDetails.createSafeList(elements, true, false));
        return new ImmutableContentKeyDetails(this.key, this.mergeBehavior, this.conflictType, this.sourceCommits, newValue, this.conflict);
    }

    public final ImmutableContentKeyDetails withConflict(@Nullable Conflict value) {
        if (this.conflict == value) {
            return this;
        }
        return new ImmutableContentKeyDetails(this.key, this.mergeBehavior, this.conflictType, this.sourceCommits, this.targetCommits, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableContentKeyDetails && this.equalTo(0, (ImmutableContentKeyDetails)another);
    }

    private boolean equalTo(int synthetic, ImmutableContentKeyDetails another) {
        return this.key.equals(another.key) && this.mergeBehavior.equals((Object)another.mergeBehavior) && this.conflictType.equals((Object)another.conflictType) && this.sourceCommits.equals(another.sourceCommits) && this.targetCommits.equals(another.targetCommits) && Objects.equals(this.conflict, another.conflict);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.key.hashCode();
        h += (h << 5) + this.mergeBehavior.hashCode();
        h += (h << 5) + this.conflictType.hashCode();
        h += (h << 5) + this.sourceCommits.hashCode();
        h += (h << 5) + this.targetCommits.hashCode();
        h += (h << 5) + Objects.hashCode(this.conflict);
        return h;
    }

    public String toString() {
        return "ContentKeyDetails{key=" + String.valueOf(this.key) + ", mergeBehavior=" + String.valueOf((Object)this.mergeBehavior) + ", conflictType=" + String.valueOf((Object)this.conflictType) + ", sourceCommits=" + String.valueOf(this.sourceCommits) + ", targetCommits=" + String.valueOf(this.targetCommits) + ", conflict=" + String.valueOf(this.conflict) + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableContentKeyDetails fromJson(Json json) {
        Builder builder = ImmutableContentKeyDetails.builder();
        if (json.key != null) {
            builder.key(json.key);
        }
        if (json.mergeBehavior != null) {
            builder.mergeBehavior(json.mergeBehavior);
        }
        if (json.conflictType != null) {
            builder.conflictType(json.conflictType);
        }
        if (json.sourceCommits != null) {
            builder.addAllSourceCommits(json.sourceCommits);
        }
        if (json.targetCommits != null) {
            builder.addAllTargetCommits(json.targetCommits);
        }
        if (json.conflict != null) {
            builder.conflict(json.conflict);
        }
        return builder.build();
    }

    public static ImmutableContentKeyDetails copyOf(MergeResponse.ContentKeyDetails instance) {
        if (instance instanceof ImmutableContentKeyDetails) {
            return (ImmutableContentKeyDetails)instance;
        }
        return ImmutableContentKeyDetails.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="MergeResponse.ContentKeyDetails", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_KEY = 1L;
        private static final long INIT_BIT_MERGE_BEHAVIOR = 2L;
        private long initBits = 3L;
        private ContentKey key;
        private MergeBehavior mergeBehavior;
        private MergeResponse.ContentKeyConflict conflictType;
        private List<String> sourceCommits = new ArrayList<String>();
        private List<String> targetCommits = new ArrayList<String>();
        private Conflict conflict;

        private Builder() {
        }

        public final Builder from(MergeResponse.ContentKeyDetails instance) {
            Objects.requireNonNull(instance, "instance");
            this.key(instance.getKey());
            this.mergeBehavior(instance.getMergeBehavior());
            this.conflictType(instance.getConflictType());
            this.addAllSourceCommits(instance.getSourceCommits());
            this.addAllTargetCommits(instance.getTargetCommits());
            Conflict conflictValue = instance.getConflict();
            if (conflictValue != null) {
                this.conflict(conflictValue);
            }
            return this;
        }

        @JsonProperty(value="key")
        public final Builder key(ContentKey key) {
            this.key = Objects.requireNonNull(key, "key");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="mergeBehavior")
        public final Builder mergeBehavior(MergeBehavior mergeBehavior) {
            this.mergeBehavior = Objects.requireNonNull(mergeBehavior, "mergeBehavior");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="conflictType")
        @JsonDeserialize(using=MergeResponse.ContentKeyConflict.Deserializer.class)
        @JsonView(value={Views.V1.class})
        @Deprecated
        public final Builder conflictType(MergeResponse.ContentKeyConflict conflictType) {
            this.conflictType = Objects.requireNonNull(conflictType, "conflictType");
            return this;
        }

        @Deprecated
        public final Builder addSourceCommits(String element) {
            this.sourceCommits.add(Objects.requireNonNull(element, "sourceCommits element"));
            return this;
        }

        @Deprecated
        public final Builder addSourceCommits(String ... elements) {
            for (String element : elements) {
                this.sourceCommits.add(Objects.requireNonNull(element, "sourceCommits element"));
            }
            return this;
        }

        @JsonProperty(value="sourceCommits")
        @JsonView(value={Views.V1.class})
        @Deprecated
        public final Builder sourceCommits(Iterable<String> elements) {
            this.sourceCommits.clear();
            return this.addAllSourceCommits(elements);
        }

        @Deprecated
        public final Builder addAllSourceCommits(Iterable<String> elements) {
            for (String element : elements) {
                this.sourceCommits.add(Objects.requireNonNull(element, "sourceCommits element"));
            }
            return this;
        }

        @Deprecated
        public final Builder addTargetCommits(String element) {
            this.targetCommits.add(Objects.requireNonNull(element, "targetCommits element"));
            return this;
        }

        @Deprecated
        public final Builder addTargetCommits(String ... elements) {
            for (String element : elements) {
                this.targetCommits.add(Objects.requireNonNull(element, "targetCommits element"));
            }
            return this;
        }

        @JsonProperty(value="targetCommits")
        @JsonView(value={Views.V1.class})
        @Deprecated
        public final Builder targetCommits(Iterable<String> elements) {
            this.targetCommits.clear();
            return this.addAllTargetCommits(elements);
        }

        @Deprecated
        public final Builder addAllTargetCommits(Iterable<String> elements) {
            for (String element : elements) {
                this.targetCommits.add(Objects.requireNonNull(element, "targetCommits element"));
            }
            return this;
        }

        @JsonProperty(value="conflict")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonView(value={Views.V2.class})
        public final Builder conflict(@Nullable Conflict conflict) {
            this.conflict = conflict;
            return this;
        }

        public ImmutableContentKeyDetails build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableContentKeyDetails(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("key");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("mergeBehavior");
            }
            return "Cannot build ContentKeyDetails, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="MergeResponse.ContentKeyDetails", generator="Immutables")
    static final class Json
    implements MergeResponse.ContentKeyDetails {
        ContentKey key;
        MergeBehavior mergeBehavior;
        MergeResponse.ContentKeyConflict conflictType;
        List<String> sourceCommits = Collections.emptyList();
        List<String> targetCommits = Collections.emptyList();
        Conflict conflict;

        Json() {
        }

        @JsonProperty(value="key")
        public void setKey(ContentKey key) {
            this.key = key;
        }

        @JsonProperty(value="mergeBehavior")
        public void setMergeBehavior(MergeBehavior mergeBehavior) {
            this.mergeBehavior = mergeBehavior;
        }

        @JsonProperty(value="conflictType")
        @JsonDeserialize(using=MergeResponse.ContentKeyConflict.Deserializer.class)
        @JsonView(value={Views.V1.class})
        public void setConflictType(MergeResponse.ContentKeyConflict conflictType) {
            this.conflictType = conflictType;
        }

        @JsonProperty(value="sourceCommits")
        @JsonView(value={Views.V1.class})
        public void setSourceCommits(List<String> sourceCommits) {
            this.sourceCommits = sourceCommits;
        }

        @JsonProperty(value="targetCommits")
        @JsonView(value={Views.V1.class})
        public void setTargetCommits(List<String> targetCommits) {
            this.targetCommits = targetCommits;
        }

        @JsonProperty(value="conflict")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonView(value={Views.V2.class})
        public void setConflict(@Nullable Conflict conflict) {
            this.conflict = conflict;
        }

        @Override
        public ContentKey getKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public MergeBehavior getMergeBehavior() {
            throw new UnsupportedOperationException();
        }

        @Override
        public MergeResponse.ContentKeyConflict getConflictType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getSourceCommits() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getTargetCommits() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Conflict getConflict() {
            throw new UnsupportedOperationException();
        }
    }
}

