/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.api.v2.params;

import javax.annotation.Nullable;
import org.immutables.value.Value;
import org.projectnessie.api.v2.params.ImmutableParsedReference;
import org.projectnessie.model.Reference;

@Value.Immutable
public interface ParsedReference {
    @Nullable
    @jakarta.annotation.Nullable
    @Value.Parameter(order=1)
    public String name();

    @Nullable
    @jakarta.annotation.Nullable
    @Value.Parameter(order=2)
    public String hashWithRelativeSpec();

    @Nullable
    @jakarta.annotation.Nullable
    @Value.Parameter(order=3)
    public Reference.ReferenceType type();

    @Value.Check
    default public void check() {
        if (this.hashWithRelativeSpec() == null && this.name() == null) {
            throw new IllegalStateException("Either name or commit ID with optional relative commit spec or both must be supplied");
        }
    }

    public static ParsedReference parsedReference(@Nullable @jakarta.annotation.Nullable String name, @Nullable @jakarta.annotation.Nullable String hashWithRelativeSpec, @Nullable @jakarta.annotation.Nullable Reference.ReferenceType type) {
        if (hashWithRelativeSpec != null && name == null) {
            name = "DETACHED";
        }
        return ImmutableParsedReference.of(name, hashWithRelativeSpec, type);
    }
}

