/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentResponse;
import org.projectnessie.model.Documentation;
import org.projectnessie.model.Reference;
import org.projectnessie.model.ser.Views;

@ParametersAreNonnullByDefault
@Generated(from="ContentResponse", generator="Immutables")
@Immutable
public final class ImmutableContentResponse
implements ContentResponse {
    private final Content content;
    private final Reference effectiveReference;
    @Nullable
    private final Documentation documentation;

    private ImmutableContentResponse(Content content, Reference effectiveReference, @Nullable Documentation documentation) {
        this.content = Objects.requireNonNull(content, "content");
        this.effectiveReference = Objects.requireNonNull(effectiveReference, "effectiveReference");
        this.documentation = documentation;
    }

    private ImmutableContentResponse(ImmutableContentResponse original, Content content, Reference effectiveReference, @Nullable Documentation documentation) {
        this.content = content;
        this.effectiveReference = effectiveReference;
        this.documentation = documentation;
    }

    @Override
    @JsonProperty(value="content")
    public Content getContent() {
        return this.content;
    }

    @Override
    @JsonProperty(value="effectiveReference")
    public Reference getEffectiveReference() {
        return this.effectiveReference;
    }

    @Override
    @JsonProperty(value="documentation")
    @JsonView(value={Views.V2.class})
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    public Documentation getDocumentation() {
        return this.documentation;
    }

    public final ImmutableContentResponse withContent(Content value) {
        if (this.content == value) {
            return this;
        }
        Content newValue = Objects.requireNonNull(value, "content");
        return new ImmutableContentResponse(this, newValue, this.effectiveReference, this.documentation);
    }

    public final ImmutableContentResponse withEffectiveReference(Reference value) {
        if (this.effectiveReference == value) {
            return this;
        }
        Reference newValue = Objects.requireNonNull(value, "effectiveReference");
        return new ImmutableContentResponse(this, this.content, newValue, this.documentation);
    }

    public final ImmutableContentResponse withDocumentation(@Nullable Documentation value) {
        if (this.documentation == value) {
            return this;
        }
        return new ImmutableContentResponse(this, this.content, this.effectiveReference, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableContentResponse && this.equalTo(0, (ImmutableContentResponse)another);
    }

    private boolean equalTo(int synthetic, ImmutableContentResponse another) {
        return this.content.equals(another.content) && this.effectiveReference.equals(another.effectiveReference) && Objects.equals(this.documentation, another.documentation);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.content.hashCode();
        h += (h << 5) + this.effectiveReference.hashCode();
        h += (h << 5) + Objects.hashCode(this.documentation);
        return h;
    }

    public String toString() {
        return "ContentResponse{content=" + String.valueOf(this.content) + ", effectiveReference=" + String.valueOf(this.effectiveReference) + ", documentation=" + String.valueOf(this.documentation) + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableContentResponse fromJson(Json json) {
        Builder builder = ImmutableContentResponse.builder();
        if (json.content != null) {
            builder.content(json.content);
        }
        if (json.effectiveReference != null) {
            builder.effectiveReference(json.effectiveReference);
        }
        if (json.documentation != null) {
            builder.documentation(json.documentation);
        }
        return builder.build();
    }

    public static ImmutableContentResponse of(Content content, Reference effectiveReference, @Nullable Documentation documentation) {
        return new ImmutableContentResponse(content, effectiveReference, documentation);
    }

    public static ImmutableContentResponse copyOf(ContentResponse instance) {
        if (instance instanceof ImmutableContentResponse) {
            return (ImmutableContentResponse)instance;
        }
        return ImmutableContentResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ContentResponse", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CONTENT = 1L;
        private static final long INIT_BIT_EFFECTIVE_REFERENCE = 2L;
        private long initBits = 3L;
        private Content content;
        private Reference effectiveReference;
        private Documentation documentation;

        private Builder() {
        }

        public final Builder from(ContentResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.content(instance.getContent());
            this.effectiveReference(instance.getEffectiveReference());
            Documentation documentationValue = instance.getDocumentation();
            if (documentationValue != null) {
                this.documentation(documentationValue);
            }
            return this;
        }

        @JsonProperty(value="content")
        public final Builder content(Content content) {
            this.content = Objects.requireNonNull(content, "content");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="effectiveReference")
        public final Builder effectiveReference(Reference effectiveReference) {
            this.effectiveReference = Objects.requireNonNull(effectiveReference, "effectiveReference");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="documentation")
        @JsonView(value={Views.V2.class})
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public final Builder documentation(@Nullable Documentation documentation) {
            this.documentation = documentation;
            return this;
        }

        public ImmutableContentResponse build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableContentResponse(null, this.content, this.effectiveReference, this.documentation);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("content");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("effectiveReference");
            }
            return "Cannot build ContentResponse, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ContentResponse", generator="Immutables")
    static final class Json
    implements ContentResponse {
        Content content;
        Reference effectiveReference;
        Documentation documentation;

        Json() {
        }

        @JsonProperty(value="content")
        public void setContent(Content content) {
            this.content = content;
        }

        @JsonProperty(value="effectiveReference")
        public void setEffectiveReference(Reference effectiveReference) {
            this.effectiveReference = effectiveReference;
        }

        @JsonProperty(value="documentation")
        @JsonView(value={Views.V2.class})
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public void setDocumentation(@Nullable Documentation documentation) {
            this.documentation = documentation;
        }

        @Override
        public Content getContent() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Reference getEffectiveReference() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Documentation getDocumentation() {
            throw new UnsupportedOperationException();
        }
    }
}

