/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.model.TableReference;

@ParametersAreNonnullByDefault
@Generated(from="TableReference", generator="Immutables")
@Immutable
public final class ImmutableTableReference
extends TableReference {
    private final String name;
    @Nullable
    private final String reference;
    @Nullable
    private final String timestamp;
    @Nullable
    private final String hash;

    private ImmutableTableReference(String name, @Nullable String reference, @Nullable String timestamp, @Nullable String hash) {
        this.name = name;
        this.reference = reference;
        this.timestamp = timestamp;
        this.hash = hash;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public String getReference() {
        return this.reference;
    }

    @Override
    @Nullable
    public String getTimestamp() {
        return this.timestamp;
    }

    @Override
    @Nullable
    public String getHash() {
        return this.hash;
    }

    public final ImmutableTableReference withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableTableReference(newValue, this.reference, this.timestamp, this.hash);
    }

    public final ImmutableTableReference withReference(@Nullable String value) {
        if (Objects.equals(this.reference, value)) {
            return this;
        }
        return new ImmutableTableReference(this.name, value, this.timestamp, this.hash);
    }

    public final ImmutableTableReference withTimestamp(@Nullable String value) {
        if (Objects.equals(this.timestamp, value)) {
            return this;
        }
        return new ImmutableTableReference(this.name, this.reference, value, this.hash);
    }

    public final ImmutableTableReference withHash(@Nullable String value) {
        if (Objects.equals(this.hash, value)) {
            return this;
        }
        return new ImmutableTableReference(this.name, this.reference, this.timestamp, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTableReference && this.equalsByValue((ImmutableTableReference)another);
    }

    private boolean equalsByValue(ImmutableTableReference another) {
        return this.name.equals(another.name) && Objects.equals(this.reference, another.reference) && Objects.equals(this.timestamp, another.timestamp) && Objects.equals(this.hash, another.hash);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + Objects.hashCode(this.reference);
        h += (h << 5) + Objects.hashCode(this.timestamp);
        h += (h << 5) + Objects.hashCode(this.hash);
        return h;
    }

    public static ImmutableTableReference copyOf(TableReference instance) {
        if (instance instanceof ImmutableTableReference) {
            return (ImmutableTableReference)instance;
        }
        return ImmutableTableReference.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TableReference", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private long initBits = 1L;
        private String name;
        private String reference;
        private String timestamp;
        private String hash;

        private Builder() {
        }

        public final Builder from(TableReference instance) {
            String hashValue;
            String timestampValue;
            Objects.requireNonNull(instance, "instance");
            this.name(instance.getName());
            String referenceValue = instance.getReference();
            if (referenceValue != null) {
                this.reference(referenceValue);
            }
            if ((timestampValue = instance.getTimestamp()) != null) {
                this.timestamp(timestampValue);
            }
            if ((hashValue = instance.getHash()) != null) {
                this.hash(hashValue);
            }
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder reference(@Nullable String reference) {
            this.reference = reference;
            return this;
        }

        public final Builder timestamp(@Nullable String timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final Builder hash(@Nullable String hash) {
            this.hash = hash;
            return this;
        }

        public ImmutableTableReference build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTableReference(this.name, this.reference, this.timestamp, this.hash);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build TableReference, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

