/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.api.v2.params;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.api.v2.params.BaseMergeTransplant;
import org.projectnessie.api.v2.params.Merge;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.MergeBehavior;
import org.projectnessie.model.MergeKeyBehavior;

@ParametersAreNonnullByDefault
@Generated(from="Merge", generator="Immutables")
@Immutable
public final class ImmutableMerge
implements Merge {
    private final String fromRefName;
    @Nullable
    private final List<MergeKeyBehavior> keyMergeModes;
    @Nullable
    private final MergeBehavior defaultKeyMergeMode;
    @Nullable
    private final Boolean isDryRun;
    @Nullable
    private final Boolean isFetchAdditionalInfo;
    @Nullable
    private final Boolean isReturnConflictAsResult;
    @Nullable
    private final String message;
    @Nullable
    private final CommitMeta commitMeta;
    @Nullable
    private final String fromHash;

    private ImmutableMerge(String fromRefName, @Nullable List<MergeKeyBehavior> keyMergeModes, @Nullable MergeBehavior defaultKeyMergeMode, @Nullable Boolean isDryRun, @Nullable Boolean isFetchAdditionalInfo, @Nullable Boolean isReturnConflictAsResult, @Nullable String message, @Nullable CommitMeta commitMeta, @Nullable String fromHash) {
        this.fromRefName = fromRefName;
        this.keyMergeModes = keyMergeModes;
        this.defaultKeyMergeMode = defaultKeyMergeMode;
        this.isDryRun = isDryRun;
        this.isFetchAdditionalInfo = isFetchAdditionalInfo;
        this.isReturnConflictAsResult = isReturnConflictAsResult;
        this.message = message;
        this.commitMeta = commitMeta;
        this.fromHash = fromHash;
    }

    @Override
    @JsonProperty(value="fromRefName", required=true)
    public String getFromRefName() {
        return this.fromRefName;
    }

    @Override
    @JsonProperty(value="keyMergeModes")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    public List<MergeKeyBehavior> getKeyMergeModes() {
        return this.keyMergeModes;
    }

    @Override
    @JsonProperty(value="defaultKeyMergeMode")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    public MergeBehavior getDefaultKeyMergeMode() {
        return this.defaultKeyMergeMode;
    }

    @Override
    @JsonProperty(value="isDryRun")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    public Boolean isDryRun() {
        return this.isDryRun;
    }

    @Override
    @JsonProperty(value="isFetchAdditionalInfo")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    public Boolean isFetchAdditionalInfo() {
        return this.isFetchAdditionalInfo;
    }

    @Override
    @JsonProperty(value="isReturnConflictAsResult")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    public Boolean isReturnConflictAsResult() {
        return this.isReturnConflictAsResult;
    }

    @Override
    @JsonProperty(value="message")
    @Deprecated
    @Nullable
    public String getMessage() {
        return this.message;
    }

    @Override
    @JsonProperty(value="commitMeta")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    public CommitMeta getCommitMeta() {
        return this.commitMeta;
    }

    @Override
    @JsonProperty(value="fromHash")
    @Nullable
    public String getFromHash() {
        return this.fromHash;
    }

    public final ImmutableMerge withFromRefName(String value) {
        String newValue = Objects.requireNonNull(value, "fromRefName");
        if (this.fromRefName.equals(newValue)) {
            return this;
        }
        return ImmutableMerge.validate(new ImmutableMerge(newValue, this.keyMergeModes, this.defaultKeyMergeMode, this.isDryRun, this.isFetchAdditionalInfo, this.isReturnConflictAsResult, this.message, this.commitMeta, this.fromHash));
    }

    public final ImmutableMerge withKeyMergeModes(MergeKeyBehavior ... elements) {
        if (elements == null) {
            if (this.keyMergeModes == null) {
                return this;
            }
            return ImmutableMerge.validate(new ImmutableMerge(this.fromRefName, null, this.defaultKeyMergeMode, this.isDryRun, this.isFetchAdditionalInfo, this.isReturnConflictAsResult, this.message, this.commitMeta, this.fromHash));
        }
        List<MergeKeyBehavior> newValue = ImmutableMerge.createUnmodifiableList(false, ImmutableMerge.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableMerge.validate(new ImmutableMerge(this.fromRefName, newValue, this.defaultKeyMergeMode, this.isDryRun, this.isFetchAdditionalInfo, this.isReturnConflictAsResult, this.message, this.commitMeta, this.fromHash));
    }

    public final ImmutableMerge withKeyMergeModes(@Nullable Iterable<? extends MergeKeyBehavior> elements) {
        if (this.keyMergeModes == elements) {
            return this;
        }
        List<MergeKeyBehavior> newValue = elements == null ? null : ImmutableMerge.createUnmodifiableList(false, ImmutableMerge.createSafeList(elements, true, false));
        return ImmutableMerge.validate(new ImmutableMerge(this.fromRefName, newValue, this.defaultKeyMergeMode, this.isDryRun, this.isFetchAdditionalInfo, this.isReturnConflictAsResult, this.message, this.commitMeta, this.fromHash));
    }

    public final ImmutableMerge withDefaultKeyMergeMode(@Nullable MergeBehavior value) {
        if (this.defaultKeyMergeMode == value) {
            return this;
        }
        return ImmutableMerge.validate(new ImmutableMerge(this.fromRefName, this.keyMergeModes, value, this.isDryRun, this.isFetchAdditionalInfo, this.isReturnConflictAsResult, this.message, this.commitMeta, this.fromHash));
    }

    public final ImmutableMerge withIsDryRun(@Nullable Boolean value) {
        if (Objects.equals(this.isDryRun, value)) {
            return this;
        }
        return ImmutableMerge.validate(new ImmutableMerge(this.fromRefName, this.keyMergeModes, this.defaultKeyMergeMode, value, this.isFetchAdditionalInfo, this.isReturnConflictAsResult, this.message, this.commitMeta, this.fromHash));
    }

    public final ImmutableMerge withIsFetchAdditionalInfo(@Nullable Boolean value) {
        if (Objects.equals(this.isFetchAdditionalInfo, value)) {
            return this;
        }
        return ImmutableMerge.validate(new ImmutableMerge(this.fromRefName, this.keyMergeModes, this.defaultKeyMergeMode, this.isDryRun, value, this.isReturnConflictAsResult, this.message, this.commitMeta, this.fromHash));
    }

    public final ImmutableMerge withIsReturnConflictAsResult(@Nullable Boolean value) {
        if (Objects.equals(this.isReturnConflictAsResult, value)) {
            return this;
        }
        return ImmutableMerge.validate(new ImmutableMerge(this.fromRefName, this.keyMergeModes, this.defaultKeyMergeMode, this.isDryRun, this.isFetchAdditionalInfo, value, this.message, this.commitMeta, this.fromHash));
    }

    @Deprecated
    public final ImmutableMerge withMessage(@Nullable String value) {
        if (Objects.equals(this.message, value)) {
            return this;
        }
        return ImmutableMerge.validate(new ImmutableMerge(this.fromRefName, this.keyMergeModes, this.defaultKeyMergeMode, this.isDryRun, this.isFetchAdditionalInfo, this.isReturnConflictAsResult, value, this.commitMeta, this.fromHash));
    }

    public final ImmutableMerge withCommitMeta(@Nullable CommitMeta value) {
        if (this.commitMeta == value) {
            return this;
        }
        return ImmutableMerge.validate(new ImmutableMerge(this.fromRefName, this.keyMergeModes, this.defaultKeyMergeMode, this.isDryRun, this.isFetchAdditionalInfo, this.isReturnConflictAsResult, this.message, value, this.fromHash));
    }

    public final ImmutableMerge withFromHash(@Nullable String value) {
        if (Objects.equals(this.fromHash, value)) {
            return this;
        }
        return ImmutableMerge.validate(new ImmutableMerge(this.fromRefName, this.keyMergeModes, this.defaultKeyMergeMode, this.isDryRun, this.isFetchAdditionalInfo, this.isReturnConflictAsResult, this.message, this.commitMeta, value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMerge && this.equalsByValue((ImmutableMerge)another);
    }

    private boolean equalsByValue(ImmutableMerge another) {
        return this.fromRefName.equals(another.fromRefName) && Objects.equals(this.keyMergeModes, another.keyMergeModes) && Objects.equals((Object)this.defaultKeyMergeMode, (Object)another.defaultKeyMergeMode) && Objects.equals(this.isDryRun, another.isDryRun) && Objects.equals(this.isFetchAdditionalInfo, another.isFetchAdditionalInfo) && Objects.equals(this.isReturnConflictAsResult, another.isReturnConflictAsResult) && Objects.equals(this.message, another.message) && Objects.equals(this.commitMeta, another.commitMeta) && Objects.equals(this.fromHash, another.fromHash);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.fromRefName.hashCode();
        h += (h << 5) + Objects.hashCode(this.keyMergeModes);
        h += (h << 5) + Objects.hashCode((Object)this.defaultKeyMergeMode);
        h += (h << 5) + Objects.hashCode(this.isDryRun);
        h += (h << 5) + Objects.hashCode(this.isFetchAdditionalInfo);
        h += (h << 5) + Objects.hashCode(this.isReturnConflictAsResult);
        h += (h << 5) + Objects.hashCode(this.message);
        h += (h << 5) + Objects.hashCode(this.commitMeta);
        h += (h << 5) + Objects.hashCode(this.fromHash);
        return h;
    }

    public String toString() {
        return "Merge{fromRefName=" + this.fromRefName + ", keyMergeModes=" + String.valueOf(this.keyMergeModes) + ", defaultKeyMergeMode=" + String.valueOf((Object)this.defaultKeyMergeMode) + ", isDryRun=" + this.isDryRun + ", isFetchAdditionalInfo=" + this.isFetchAdditionalInfo + ", isReturnConflictAsResult=" + this.isReturnConflictAsResult + ", message=" + this.message + ", commitMeta=" + String.valueOf(this.commitMeta) + ", fromHash=" + this.fromHash + "}";
    }

    @Deprecated
    @JsonCreator
    static ImmutableMerge fromJson(Json json) {
        Builder builder = ImmutableMerge.builder();
        if (json.fromRefName != null) {
            builder.fromRefName(json.fromRefName);
        }
        if (json.keyMergeModes != null) {
            builder.addAllKeyMergeModes(json.keyMergeModes);
        }
        if (json.defaultKeyMergeMode != null) {
            builder.defaultKeyMergeMode(json.defaultKeyMergeMode);
        }
        if (json.isDryRun != null) {
            builder.isDryRun(json.isDryRun);
        }
        if (json.isFetchAdditionalInfo != null) {
            builder.isFetchAdditionalInfo(json.isFetchAdditionalInfo);
        }
        if (json.isReturnConflictAsResult != null) {
            builder.isReturnConflictAsResult(json.isReturnConflictAsResult);
        }
        if (json.message != null) {
            builder.message(json.message);
        }
        if (json.commitMeta != null) {
            builder.commitMeta(json.commitMeta);
        }
        if (json.fromHash != null) {
            builder.fromHash(json.fromHash);
        }
        return builder.build();
    }

    private static ImmutableMerge validate(ImmutableMerge instance) {
        instance.checkHash();
        return instance;
    }

    public static ImmutableMerge copyOf(Merge instance) {
        if (instance instanceof ImmutableMerge) {
            return (ImmutableMerge)instance;
        }
        return ImmutableMerge.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<? extends T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="Merge", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_FROM_REF_NAME = 1L;
        private long initBits = 1L;
        private String fromRefName;
        private List<MergeKeyBehavior> keyMergeModes = null;
        private MergeBehavior defaultKeyMergeMode;
        private Boolean isDryRun;
        private Boolean isFetchAdditionalInfo;
        private Boolean isReturnConflictAsResult;
        private String message;
        private CommitMeta commitMeta;
        private String fromHash;

        private Builder() {
        }

        public final Builder from(BaseMergeTransplant instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        public final Builder from(Merge instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        private void mergeInternal(Object object) {
            MergeBehavior defaultKeyMergeModeValue;
            BaseMergeTransplant instance;
            long bits = 0L;
            if (object instanceof BaseMergeTransplant) {
                instance = (BaseMergeTransplant)object;
                if ((bits & 1L) == 0L) {
                    defaultKeyMergeModeValue = instance.getDefaultKeyMergeMode();
                    if (defaultKeyMergeModeValue != null) {
                        this.defaultKeyMergeMode(defaultKeyMergeModeValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    Boolean isFetchAdditionalInfoValue = instance.isFetchAdditionalInfo();
                    if (isFetchAdditionalInfoValue != null) {
                        this.isFetchAdditionalInfo(isFetchAdditionalInfoValue);
                    }
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    Boolean isDryRunValue = instance.isDryRun();
                    if (isDryRunValue != null) {
                        this.isDryRun(isDryRunValue);
                    }
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    List<MergeKeyBehavior> keyMergeModesValue = instance.getKeyMergeModes();
                    if (keyMergeModesValue != null) {
                        this.addAllKeyMergeModes(keyMergeModesValue);
                    }
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    Boolean isReturnConflictAsResultValue = instance.isReturnConflictAsResult();
                    if (isReturnConflictAsResultValue != null) {
                        this.isReturnConflictAsResult(isReturnConflictAsResultValue);
                    }
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    String messageValue = instance.getMessage();
                    if (messageValue != null) {
                        this.message(messageValue);
                    }
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    this.fromRefName(instance.getFromRefName());
                    bits |= 0x40L;
                }
            }
            if (object instanceof Merge) {
                String fromHashValue;
                CommitMeta commitMetaValue;
                instance = (Merge)object;
                if ((bits & 1L) == 0L) {
                    defaultKeyMergeModeValue = instance.getDefaultKeyMergeMode();
                    if (defaultKeyMergeModeValue != null) {
                        this.defaultKeyMergeMode(defaultKeyMergeModeValue);
                    }
                    bits |= 1L;
                }
                if ((commitMetaValue = instance.getCommitMeta()) != null) {
                    this.commitMeta(commitMetaValue);
                }
                if ((fromHashValue = instance.getFromHash()) != null) {
                    this.fromHash(fromHashValue);
                }
                if ((bits & 2L) == 0L) {
                    Boolean isFetchAdditionalInfoValue = instance.isFetchAdditionalInfo();
                    if (isFetchAdditionalInfoValue != null) {
                        this.isFetchAdditionalInfo(isFetchAdditionalInfoValue);
                    }
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    Boolean isDryRunValue = instance.isDryRun();
                    if (isDryRunValue != null) {
                        this.isDryRun(isDryRunValue);
                    }
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    List<MergeKeyBehavior> keyMergeModesValue = instance.getKeyMergeModes();
                    if (keyMergeModesValue != null) {
                        this.addAllKeyMergeModes(keyMergeModesValue);
                    }
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    Boolean isReturnConflictAsResultValue = instance.isReturnConflictAsResult();
                    if (isReturnConflictAsResultValue != null) {
                        this.isReturnConflictAsResult(isReturnConflictAsResultValue);
                    }
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    String messageValue = instance.getMessage();
                    if (messageValue != null) {
                        this.message(messageValue);
                    }
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    this.fromRefName(instance.getFromRefName());
                    bits |= 0x40L;
                }
            }
        }

        @JsonProperty(value="fromRefName", required=true)
        public final Builder fromRefName(String fromRefName) {
            this.fromRefName = Objects.requireNonNull(fromRefName, "fromRefName");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addKeyMergeModes(MergeKeyBehavior element) {
            if (this.keyMergeModes == null) {
                this.keyMergeModes = new ArrayList<MergeKeyBehavior>();
            }
            this.keyMergeModes.add(Objects.requireNonNull(element, "keyMergeModes element"));
            return this;
        }

        public final Builder addKeyMergeModes(MergeKeyBehavior ... elements) {
            if (this.keyMergeModes == null) {
                this.keyMergeModes = new ArrayList<MergeKeyBehavior>();
            }
            for (MergeKeyBehavior element : elements) {
                this.keyMergeModes.add(Objects.requireNonNull(element, "keyMergeModes element"));
            }
            return this;
        }

        @JsonProperty(value="keyMergeModes")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public final Builder keyMergeModes(@Nullable Iterable<? extends MergeKeyBehavior> elements) {
            if (elements == null) {
                this.keyMergeModes = null;
                return this;
            }
            this.keyMergeModes = new ArrayList<MergeKeyBehavior>();
            return this.addAllKeyMergeModes(elements);
        }

        public final Builder addAllKeyMergeModes(Iterable<? extends MergeKeyBehavior> elements) {
            Objects.requireNonNull(elements, "keyMergeModes element");
            if (this.keyMergeModes == null) {
                this.keyMergeModes = new ArrayList<MergeKeyBehavior>();
            }
            for (MergeKeyBehavior mergeKeyBehavior : elements) {
                this.keyMergeModes.add(Objects.requireNonNull(mergeKeyBehavior, "keyMergeModes element"));
            }
            return this;
        }

        @JsonProperty(value="defaultKeyMergeMode")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public final Builder defaultKeyMergeMode(@Nullable MergeBehavior defaultKeyMergeMode) {
            this.defaultKeyMergeMode = defaultKeyMergeMode;
            return this;
        }

        @JsonProperty(value="isDryRun")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public final Builder isDryRun(@Nullable Boolean isDryRun) {
            this.isDryRun = isDryRun;
            return this;
        }

        @JsonProperty(value="isFetchAdditionalInfo")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public final Builder isFetchAdditionalInfo(@Nullable Boolean isFetchAdditionalInfo) {
            this.isFetchAdditionalInfo = isFetchAdditionalInfo;
            return this;
        }

        @JsonProperty(value="isReturnConflictAsResult")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public final Builder isReturnConflictAsResult(@Nullable Boolean isReturnConflictAsResult) {
            this.isReturnConflictAsResult = isReturnConflictAsResult;
            return this;
        }

        @JsonProperty(value="message")
        @Deprecated
        public final Builder message(@Nullable String message) {
            this.message = message;
            return this;
        }

        @JsonProperty(value="commitMeta")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public final Builder commitMeta(@Nullable CommitMeta commitMeta) {
            this.commitMeta = commitMeta;
            return this;
        }

        @JsonProperty(value="fromHash")
        public final Builder fromHash(@Nullable String fromHash) {
            this.fromHash = fromHash;
            return this;
        }

        public ImmutableMerge build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableMerge.validate(new ImmutableMerge(this.fromRefName, this.keyMergeModes == null ? null : ImmutableMerge.createUnmodifiableList(true, this.keyMergeModes), this.defaultKeyMergeMode, this.isDryRun, this.isFetchAdditionalInfo, this.isReturnConflictAsResult, this.message, this.commitMeta, this.fromHash));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("fromRefName");
            }
            return "Cannot build Merge, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonDeserialize
    @Generated(from="Merge", generator="Immutables")
    static final class Json
    implements Merge {
        @JsonIgnore
        String fromRefName;
        @JsonIgnore
        List<MergeKeyBehavior> keyMergeModes = null;
        @JsonIgnore
        MergeBehavior defaultKeyMergeMode;
        @JsonIgnore
        Boolean isDryRun;
        @JsonIgnore
        Boolean isFetchAdditionalInfo;
        @JsonIgnore
        Boolean isReturnConflictAsResult;
        @JsonIgnore
        String message;
        @JsonIgnore
        CommitMeta commitMeta;
        @JsonIgnore
        String fromHash;

        Json() {
        }

        @JsonProperty(value="fromRefName", required=true)
        public void setFromRefName(String fromRefName) {
            this.fromRefName = fromRefName;
        }

        @JsonProperty(value="keyMergeModes")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public void setKeyMergeModes(@Nullable List<MergeKeyBehavior> keyMergeModes) {
            this.keyMergeModes = keyMergeModes;
        }

        @JsonProperty(value="defaultKeyMergeMode")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public void setDefaultKeyMergeMode(@Nullable MergeBehavior defaultKeyMergeMode) {
            this.defaultKeyMergeMode = defaultKeyMergeMode;
        }

        @JsonProperty(value="isDryRun")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public void setIsDryRun(@Nullable Boolean isDryRun) {
            this.isDryRun = isDryRun;
        }

        @JsonProperty(value="isFetchAdditionalInfo")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public void setIsFetchAdditionalInfo(@Nullable Boolean isFetchAdditionalInfo) {
            this.isFetchAdditionalInfo = isFetchAdditionalInfo;
        }

        @JsonProperty(value="isReturnConflictAsResult")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public void setIsReturnConflictAsResult(@Nullable Boolean isReturnConflictAsResult) {
            this.isReturnConflictAsResult = isReturnConflictAsResult;
        }

        @JsonProperty(value="message")
        public void setMessage(@Nullable String message) {
            this.message = message;
        }

        @JsonProperty(value="commitMeta")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public void setCommitMeta(@Nullable CommitMeta commitMeta) {
            this.commitMeta = commitMeta;
        }

        @JsonProperty(value="fromHash")
        public void setFromHash(@Nullable String fromHash) {
            this.fromHash = fromHash;
        }

        @Override
        public String getFromRefName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<MergeKeyBehavior> getKeyMergeModes() {
            throw new UnsupportedOperationException();
        }

        @Override
        public MergeBehavior getDefaultKeyMergeMode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean isDryRun() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean isFetchAdditionalInfo() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean isReturnConflictAsResult() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getMessage() {
            throw new UnsupportedOperationException();
        }

        @Override
        public CommitMeta getCommitMeta() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getFromHash() {
            throw new UnsupportedOperationException();
        }
    }
}

