/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Operation;
import org.projectnessie.model.Operations;

@ParametersAreNonnullByDefault
@Generated(from="Operations", generator="Immutables")
@Immutable
public final class ImmutableOperations
implements Operations {
    private final CommitMeta commitMeta;
    private final List<Operation> operations;

    private ImmutableOperations(CommitMeta commitMeta, List<Operation> operations) {
        this.commitMeta = commitMeta;
        this.operations = operations;
    }

    @Override
    @JsonProperty(value="commitMeta", required=true)
    public CommitMeta getCommitMeta() {
        return this.commitMeta;
    }

    @Override
    @JsonProperty(value="operations", required=true)
    public List<Operation> getOperations() {
        return this.operations;
    }

    public final ImmutableOperations withCommitMeta(CommitMeta value) {
        if (this.commitMeta == value) {
            return this;
        }
        CommitMeta newValue = Objects.requireNonNull(value, "commitMeta");
        return new ImmutableOperations(newValue, this.operations);
    }

    public final ImmutableOperations withOperations(Operation ... elements) {
        List<Operation> newValue = ImmutableOperations.createUnmodifiableList(false, ImmutableOperations.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableOperations(this.commitMeta, newValue);
    }

    public final ImmutableOperations withOperations(Iterable<? extends Operation> elements) {
        if (this.operations == elements) {
            return this;
        }
        List<Operation> newValue = ImmutableOperations.createUnmodifiableList(false, ImmutableOperations.createSafeList(elements, true, false));
        return new ImmutableOperations(this.commitMeta, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableOperations && this.equalsByValue((ImmutableOperations)another);
    }

    private boolean equalsByValue(ImmutableOperations another) {
        return this.commitMeta.equals(another.commitMeta) && this.operations.equals(another.operations);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.commitMeta.hashCode();
        h += (h << 5) + this.operations.hashCode();
        return h;
    }

    public String toString() {
        return "Operations{commitMeta=" + String.valueOf(this.commitMeta) + ", operations=" + String.valueOf(this.operations) + "}";
    }

    @Deprecated
    @JsonCreator
    static ImmutableOperations fromJson(Json json) {
        Builder builder = ImmutableOperations.builder();
        if (json.commitMeta != null) {
            builder.commitMeta(json.commitMeta);
        }
        if (json.operations != null) {
            builder.addAllOperations(json.operations);
        }
        return builder.build();
    }

    public static ImmutableOperations copyOf(Operations instance) {
        if (instance instanceof ImmutableOperations) {
            return (ImmutableOperations)instance;
        }
        return ImmutableOperations.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<? extends T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="Operations", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_COMMIT_META = 1L;
        private long initBits = 1L;
        private CommitMeta commitMeta;
        private List<Operation> operations = new ArrayList<Operation>();

        private Builder() {
        }

        public final Builder from(Operations instance) {
            Objects.requireNonNull(instance, "instance");
            this.commitMeta(instance.getCommitMeta());
            this.addAllOperations(instance.getOperations());
            return this;
        }

        @JsonProperty(value="commitMeta", required=true)
        public final Builder commitMeta(CommitMeta commitMeta) {
            this.commitMeta = Objects.requireNonNull(commitMeta, "commitMeta");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addOperations(Operation element) {
            this.operations.add(Objects.requireNonNull(element, "operations element"));
            return this;
        }

        public final Builder addOperations(Operation ... elements) {
            for (Operation element : elements) {
                this.operations.add(Objects.requireNonNull(element, "operations element"));
            }
            return this;
        }

        @JsonProperty(value="operations", required=true)
        public final Builder operations(Iterable<? extends Operation> elements) {
            this.operations.clear();
            return this.addAllOperations(elements);
        }

        public final Builder addAllOperations(Iterable<? extends Operation> elements) {
            for (Operation operation : elements) {
                this.operations.add(Objects.requireNonNull(operation, "operations element"));
            }
            return this;
        }

        public ImmutableOperations build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableOperations(this.commitMeta, ImmutableOperations.createUnmodifiableList(true, this.operations));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("commitMeta");
            }
            return "Cannot build Operations, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonDeserialize
    @Generated(from="Operations", generator="Immutables")
    static final class Json
    implements Operations {
        @JsonIgnore
        CommitMeta commitMeta;
        @JsonIgnore
        List<Operation> operations = Collections.emptyList();

        Json() {
        }

        @JsonProperty(value="commitMeta", required=true)
        public void setCommitMeta(CommitMeta commitMeta) {
            this.commitMeta = commitMeta;
        }

        @JsonProperty(value="operations", required=true)
        public void setOperations(List<Operation> operations) {
            this.operations = operations;
        }

        @Override
        public CommitMeta getCommitMeta() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Operation> getOperations() {
            throw new UnsupportedOperationException();
        }
    }
}

