/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.DiffResponse;

@ParametersAreNonnullByDefault
@Generated(from="DiffResponse.DiffEntry", generator="Immutables")
@Immutable
public final class ImmutableDiffEntry
implements DiffResponse.DiffEntry {
    private final ContentKey key;
    @Nullable
    private final Content from;
    @Nullable
    private final Content to;

    private ImmutableDiffEntry(ContentKey key, @Nullable Content from, @Nullable Content to) {
        this.key = Objects.requireNonNull(key, "key");
        this.from = from;
        this.to = to;
    }

    private ImmutableDiffEntry(ImmutableDiffEntry original, ContentKey key, @Nullable Content from, @Nullable Content to) {
        this.key = key;
        this.from = from;
        this.to = to;
    }

    @Override
    @JsonProperty(value="key", required=true)
    public ContentKey getKey() {
        return this.key;
    }

    @Override
    @JsonProperty(value="from")
    @Nullable
    public Content getFrom() {
        return this.from;
    }

    @Override
    @JsonProperty(value="to")
    @Nullable
    public Content getTo() {
        return this.to;
    }

    public final ImmutableDiffEntry withKey(ContentKey value) {
        if (this.key == value) {
            return this;
        }
        ContentKey newValue = Objects.requireNonNull(value, "key");
        return new ImmutableDiffEntry(this, newValue, this.from, this.to);
    }

    public final ImmutableDiffEntry withFrom(@Nullable Content value) {
        if (this.from == value) {
            return this;
        }
        return new ImmutableDiffEntry(this, this.key, value, this.to);
    }

    public final ImmutableDiffEntry withTo(@Nullable Content value) {
        if (this.to == value) {
            return this;
        }
        return new ImmutableDiffEntry(this, this.key, this.from, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDiffEntry && this.equalsByValue((ImmutableDiffEntry)another);
    }

    private boolean equalsByValue(ImmutableDiffEntry another) {
        return this.key.equals(another.key) && Objects.equals(this.from, another.from) && Objects.equals(this.to, another.to);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.key.hashCode();
        h += (h << 5) + Objects.hashCode(this.from);
        h += (h << 5) + Objects.hashCode(this.to);
        return h;
    }

    public String toString() {
        return "DiffEntry{key=" + String.valueOf(this.key) + ", from=" + String.valueOf(this.from) + ", to=" + String.valueOf(this.to) + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableDiffEntry fromJson(Json json) {
        Builder builder = ImmutableDiffEntry.builder();
        if (json._key != null) {
            builder.key(json._key);
        }
        if (json._from != null) {
            builder.from(json._from);
        }
        if (json._to != null) {
            builder.to(json._to);
        }
        return builder.build();
    }

    public static ImmutableDiffEntry of(ContentKey key, @Nullable Content from, @Nullable Content to) {
        return new ImmutableDiffEntry(key, from, to);
    }

    public static ImmutableDiffEntry copyOf(DiffResponse.DiffEntry instance) {
        if (instance instanceof ImmutableDiffEntry) {
            return (ImmutableDiffEntry)instance;
        }
        return ImmutableDiffEntry.builder().key(instance.getKey()).from(instance.getFrom()).to(instance.getTo()).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DiffResponse.DiffEntry", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_KEY = 1L;
        private long initBits = 1L;
        private ContentKey key;
        private Content from;
        private Content to;

        private Builder() {
        }

        @JsonProperty(value="key", required=true)
        public final Builder key(ContentKey key) {
            this.key = Objects.requireNonNull(key, "key");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="from")
        public final Builder from(@Nullable Content from) {
            this.from = from;
            return this;
        }

        @JsonProperty(value="to")
        public final Builder to(@Nullable Content to) {
            this.to = to;
            return this;
        }

        public ImmutableDiffEntry build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDiffEntry(null, this.key, this.from, this.to);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("key");
            }
            return "Cannot build DiffEntry, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonDeserialize
    @Generated(from="DiffResponse.DiffEntry", generator="Immutables")
    static final class Json
    implements DiffResponse.DiffEntry {
        @JsonIgnore
        ContentKey _key;
        @JsonIgnore
        Content _from;
        @JsonIgnore
        Content _to;

        Json() {
        }

        @JsonProperty(value="key", required=true)
        public void setKey(ContentKey key) {
            this._key = key;
        }

        @JsonProperty(value="from")
        public void setFrom(@Nullable Content from) {
            this._from = from;
        }

        @JsonProperty(value="to")
        public void setTo(@Nullable Content to) {
            this._to = to;
        }

        @Override
        public ContentKey getKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Content getFrom() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Content getTo() {
            throw new UnsupportedOperationException();
        }
    }
}

