/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.List;
import javax.annotation.Nullable;
import org.immutables.value.Value;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.ContentMetadata;
import org.projectnessie.model.Documentation;
import org.projectnessie.model.ImmutableMergeKeyBehavior;
import org.projectnessie.model.MergeBehavior;
import org.projectnessie.model.ser.Views;

@JsonSerialize(as=ImmutableMergeKeyBehavior.class)
@JsonDeserialize(as=ImmutableMergeKeyBehavior.class)
@Value.Immutable
public interface MergeKeyBehavior {
    public ContentKey getKey();

    public MergeBehavior getMergeBehavior();

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonView(value={Views.V2.class})
    @Nullable
    @jakarta.annotation.Nullable
    public Content getExpectedTargetContent();

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonView(value={Views.V2.class})
    @Nullable
    @jakarta.annotation.Nullable
    public Content getResolvedContent();

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonView(value={Views.V2.class})
    @Nullable
    @jakarta.annotation.Nullable
    public Documentation getExpectedTargetDocumentation();

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonView(value={Views.V2.class})
    @Nullable
    @jakarta.annotation.Nullable
    public Documentation getResolvedDocumentation();

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonView(value={Views.V2.class})
    public List<ContentMetadata> getMetadata();

    public static ImmutableMergeKeyBehavior.Builder builder() {
        return ImmutableMergeKeyBehavior.builder();
    }

    public static MergeKeyBehavior of(ContentKey key, MergeBehavior mergeBehavior) {
        return MergeKeyBehavior.builder().key(key).mergeBehavior(mergeBehavior).build();
    }

    public static MergeKeyBehavior of(ContentKey key, MergeBehavior mergeBehavior, Content expectedTargetContent, Content resolvedContent) {
        return MergeKeyBehavior.builder().key(key).mergeBehavior(mergeBehavior).expectedTargetContent(expectedTargetContent).resolvedContent(resolvedContent).build();
    }
}

