/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.List;
import javax.annotation.Nullable;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.immutables.value.Value;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.ImmutableContentKeyDetails;
import org.projectnessie.model.ImmutableMergeResponse;
import org.projectnessie.model.LogResponse;
import org.projectnessie.model.MergeBehavior;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@Schema(type=SchemaType.OBJECT, title="Merge Response")
@JsonSerialize(as=ImmutableMergeResponse.class)
@JsonDeserialize(as=ImmutableMergeResponse.class)
@Value.Immutable
public interface MergeResponse {
    @Value.Default
    default public boolean wasApplied() {
        return false;
    }

    @Value.Default
    default public boolean wasSuccessful() {
        return false;
    }

    @Nullable
    public String getResultantTargetHash();

    @Nullable
    public String getCommonAncestor();

    public String getTargetBranch();

    public String getEffectiveTargetHash();

    @Nullable
    public String getExpectedHash();

    @Deprecated
    @Schema(deprecated=true, hidden=true)
    public List<LogResponse.LogEntry> getSourceCommits();

    @Nullable
    @Deprecated
    @Schema(deprecated=true, hidden=true)
    public List<LogResponse.LogEntry> getTargetCommits();

    public List<ContentKeyDetails> getDetails();

    public static enum ContentKeyConflict {
        NONE,
        UNRESOLVABLE;

    }

    @Schema(type=SchemaType.OBJECT, title="Merge Per-Content-Key details")
    @JsonSerialize(as=ImmutableContentKeyDetails.class)
    @JsonDeserialize(as=ImmutableContentKeyDetails.class)
    @Value.Immutable
    public static interface ContentKeyDetails {
        public ContentKey getKey();

        public MergeBehavior getMergeBehavior();

        @Value.Default
        default public ContentKeyConflict getConflictType() {
            return ContentKeyConflict.NONE;
        }

        @Deprecated
        @Schema(deprecated=true, hidden=true)
        public List<String> getSourceCommits();

        @Deprecated
        @Schema(deprecated=true, hidden=true)
        public List<String> getTargetCommits();
    }
}

