/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model.ser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.ser.CommitMetaSer;

public class CommitMetaDeserializer
extends StdDeserializer<CommitMeta> {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public CommitMetaDeserializer() {
        super(CommitMeta.class);
    }

    private void toArray(ObjectNode node, String singleAttr, String arrayAttr) {
        if (!node.has(arrayAttr)) {
            JsonNode value;
            ArrayNode array = node.withArray(arrayAttr);
            if (node.has(singleAttr) && !(value = node.get(singleAttr)).isNull()) {
                array.add(value);
            }
        }
        node.remove(singleAttr);
    }

    private void toMapOfLists(ObjectNode node, String singleAttr, String arrayAttr) {
        if (!node.has(arrayAttr)) {
            ObjectNode mapOfLists = node.putObject(arrayAttr);
            if (node.has(singleAttr) && node.get(singleAttr).isObject()) {
                ObjectNode map = (ObjectNode)node.get(singleAttr);
                Iterator it = map.fields();
                while (it.hasNext()) {
                    Map.Entry entry = (Map.Entry)it.next();
                    mapOfLists.putArray((String)entry.getKey()).add((JsonNode)entry.getValue());
                }
            }
        }
        node.remove(singleAttr);
    }

    public CommitMeta deserialize(JsonParser p, DeserializationContext ctx) throws IOException {
        ObjectNode node = (ObjectNode)p.readValueAs(ObjectNode.class);
        this.toArray(node, "author", "authors");
        this.toArray(node, "signedOffBy", "allSignedOffBy");
        this.toMapOfLists(node, "properties", "allProperties");
        CommitMetaSer value = (CommitMetaSer)MAPPER.convertValue((Object)node, CommitMetaSer.class);
        return CommitMeta.builder().from(value).build();
    }
}

