/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.api.v2.params;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import jakarta.validation.constraints.Pattern;
import javax.annotation.Nullable;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.media.SchemaProperty;
import org.immutables.value.Value;
import org.projectnessie.api.v2.params.BaseMergeTransplant;
import org.projectnessie.api.v2.params.ImmutableMerge;
import org.projectnessie.model.Validation;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@Schema(title="Merge Operation", properties={@SchemaProperty(name="message", description="Optional commit message for this merge request\n\nIf not set, the server will generate a commit message automatically using metadata from the \nmerged commits."), @SchemaProperty(name="fromHash", pattern="^[0-9a-fA-F]{8,64}$", description="The hash of the last commit to merge.\n\nThis commit must be present in the history on 'fromRefName' before the first common parent with respect to the target branch."), @SchemaProperty(name="fromRefName", description="The name of the reference that contains the 'source' commits for the requested merge or transplant operation.\n"), @SchemaProperty(name="keyMergeModes", description="Specific merge behaviour requests by content key.\n\nThe default is set by the `defaultKeyMergeMode` parameter.\n"), @SchemaProperty(name="defaultKeyMergeMode", description="The default merge mode. If not set, `NORMAL` is assumed.\n\nThis settings applies to key thaWhen set to 'true' instructs the server to validate the request\n        but to avoid committing any changes.t are not explicitly mentioned in the `keyMergeModes` property.\n"), @SchemaProperty(name="dryRun", description="When set to 'true' instructs the server to validate the request but to avoid committing any changes.\n"), @SchemaProperty(name="fetchAdditionalInfo", description="Whether to provide optional response data.\n"), @SchemaProperty(name="returnConflictAsResult", description="When set to 'true' instructs the server to produce normal (non-error) responses in case a conflict is detected and report conflict details in the response payload.")})
@JsonSerialize(as=ImmutableMerge.class)
@JsonDeserialize(as=ImmutableMerge.class)
@Value.Immutable
public interface Merge
extends BaseMergeTransplant {
    @Override
    @Nullable
    @jakarta.annotation.Nullable
    @Size
    @jakarta.validation.constraints.Size(min=1)
    public @Size @jakarta.validation.constraints.Size(min=1) String getMessage();

    @NotBlank
    @jakarta.validation.constraints.NotBlank
    @javax.validation.constraints.Pattern(regexp="^[0-9a-fA-F]{8,64}$", message="Hash must consist of the hex representation of 4-32 bytes")
    @Pattern(regexp="^[0-9a-fA-F]{8,64}$", message="Hash must consist of the hex representation of 4-32 bytes")
    public @NotBlank @jakarta.validation.constraints.NotBlank @javax.validation.constraints.Pattern(regexp="^[0-9a-fA-F]{8,64}$", message="Hash must consist of the hex representation of 4-32 bytes") @Pattern(regexp="^[0-9a-fA-F]{8,64}$", message="Hash must consist of the hex representation of 4-32 bytes") String getFromHash();

    @Value.Check
    default public void checkHash() {
        String hash = this.getFromHash();
        if (hash != null) {
            Validation.validateHash(hash);
        }
    }
}

