/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.api.v2.params;

import jakarta.annotation.Nonnull;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.projectnessie.api.v2.params.ParsedReference;
import org.projectnessie.model.Reference;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class ReferenceResolver {
    public static final String DEFAULT_REF_IN_PATH = "-";
    public static final char REF_HASH_SEPARATOR = '@';

    private ReferenceResolver() {
    }

    public static ParsedReference resolveReferencePathElement(@javax.annotation.Nonnull @Nonnull String value, @Nullable @jakarta.annotation.Nullable Reference.ReferenceType namedRefType) {
        String name = null;
        String hash = null;
        int hashIdx = value.indexOf(64);
        if (hashIdx > 0) {
            name = value.substring(0, hashIdx);
        }
        if (hashIdx < 0) {
            name = value;
        }
        if (hashIdx >= 0 && (hash = value.substring(hashIdx + 1)).isEmpty()) {
            hash = null;
        }
        if (name != null) {
            return ParsedReference.parsedReference(name, hash, namedRefType);
        }
        return ParsedReference.parsedReference(null, hash, null);
    }

    public static ParsedReference resolveReferencePathElementWithDefaultBranch(@javax.annotation.Nonnull @Nonnull String refPathString, @javax.annotation.Nonnull @Nonnull Supplier<String> defaultBranchSupplier) {
        if (!DEFAULT_REF_IN_PATH.equals(refPathString)) {
            return ReferenceResolver.resolveReferencePathElement(refPathString, null);
        }
        return ParsedReference.parsedReference(defaultBranchSupplier.get(), null, Reference.ReferenceType.BRANCH);
    }
}

