/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.model.PaginatedResponse;
import org.projectnessie.model.Reference;
import org.projectnessie.model.ReferencesResponse;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@ParametersAreNonnullByDefault
@Generated(from="ReferencesResponse", generator="Immutables")
@Immutable
public final class ImmutableReferencesResponse
implements ReferencesResponse {
    private final boolean isHasMore;
    @Nullable
    private final String token;
    private final List<Reference> references;

    private ImmutableReferencesResponse(Builder builder) {
        this.token = builder.token;
        this.references = ImmutableReferencesResponse.createUnmodifiableList(true, builder.references);
        this.isHasMore = builder.isHasMoreIsSet() ? builder.isHasMore : ReferencesResponse.super.isHasMore();
    }

    private ImmutableReferencesResponse(boolean isHasMore, @Nullable String token, List<Reference> references) {
        this.isHasMore = isHasMore;
        this.token = token;
        this.references = references;
    }

    @Override
    @JsonProperty(value="hasMore")
    public boolean isHasMore() {
        return this.isHasMore;
    }

    @Override
    @JsonProperty(value="token")
    @Nullable
    public String getToken() {
        return this.token;
    }

    @Override
    @JsonProperty(value="references")
    public List<Reference> getReferences() {
        return this.references;
    }

    public final ImmutableReferencesResponse withIsHasMore(boolean value) {
        if (this.isHasMore == value) {
            return this;
        }
        return new ImmutableReferencesResponse(value, this.token, this.references);
    }

    public final ImmutableReferencesResponse withToken(@Nullable String value) {
        if (Objects.equals(this.token, value)) {
            return this;
        }
        return new ImmutableReferencesResponse(this.isHasMore, value, this.references);
    }

    public final ImmutableReferencesResponse withReferences(Reference ... elements) {
        List<Reference> newValue = ImmutableReferencesResponse.createUnmodifiableList(false, ImmutableReferencesResponse.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableReferencesResponse(this.isHasMore, this.token, newValue);
    }

    public final ImmutableReferencesResponse withReferences(Iterable<? extends Reference> elements) {
        if (this.references == elements) {
            return this;
        }
        List<Reference> newValue = ImmutableReferencesResponse.createUnmodifiableList(false, ImmutableReferencesResponse.createSafeList(elements, true, false));
        return new ImmutableReferencesResponse(this.isHasMore, this.token, newValue);
    }

    public boolean equals(@javax.annotation.Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableReferencesResponse && this.equalTo(0, (ImmutableReferencesResponse)another);
    }

    private boolean equalTo(int synthetic, ImmutableReferencesResponse another) {
        return this.isHasMore == another.isHasMore && Objects.equals(this.token, another.token) && this.references.equals(another.references);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Boolean.hashCode(this.isHasMore);
        h += (h << 5) + Objects.hashCode(this.token);
        h += (h << 5) + this.references.hashCode();
        return h;
    }

    public String toString() {
        return "ReferencesResponse{isHasMore=" + this.isHasMore + ", token=" + this.token + ", references=" + this.references + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableReferencesResponse fromJson(Json json) {
        Builder builder = ImmutableReferencesResponse.builder();
        if (json.isHasMoreIsSet) {
            builder.isHasMore(json.isHasMore);
        }
        if (json.token != null) {
            builder.token(json.token);
        }
        if (json.references != null) {
            builder.addAllReferences(json.references);
        }
        return builder.build();
    }

    public static ImmutableReferencesResponse copyOf(ReferencesResponse instance) {
        if (instance instanceof ImmutableReferencesResponse) {
            return (ImmutableReferencesResponse)instance;
        }
        return ImmutableReferencesResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @Generated(from="ReferencesResponse", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_IS_HAS_MORE = 1L;
        private long optBits;
        private boolean isHasMore;
        @javax.annotation.Nullable
        private String token;
        private List<Reference> references = new ArrayList<Reference>();

        private Builder() {
        }

        public final Builder from(ReferencesResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PaginatedResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            String tokenValue;
            PaginatedResponse instance;
            long bits = 0L;
            if (object instanceof ReferencesResponse) {
                instance = (ReferencesResponse)object;
                this.addAllReferences(instance.getReferences());
                if ((bits & 2L) == 0L) {
                    this.isHasMore(instance.isHasMore());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    tokenValue = instance.getToken();
                    if (tokenValue != null) {
                        this.token(tokenValue);
                    }
                    bits |= 1L;
                }
            }
            if (object instanceof PaginatedResponse) {
                instance = (PaginatedResponse)object;
                if ((bits & 2L) == 0L) {
                    this.isHasMore(instance.isHasMore());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    tokenValue = instance.getToken();
                    if (tokenValue != null) {
                        this.token(tokenValue);
                    }
                    bits |= 1L;
                }
            }
        }

        @JsonProperty(value="hasMore")
        public final Builder isHasMore(boolean isHasMore) {
            this.isHasMore = isHasMore;
            this.optBits |= 1L;
            return this;
        }

        @JsonProperty(value="token")
        public final Builder token(@Nullable String token) {
            this.token = token;
            return this;
        }

        public final Builder addReferences(Reference element) {
            this.references.add(Objects.requireNonNull(element, "references element"));
            return this;
        }

        public final Builder addReferences(Reference ... elements) {
            for (Reference element : elements) {
                this.references.add(Objects.requireNonNull(element, "references element"));
            }
            return this;
        }

        @JsonProperty(value="references")
        public final Builder references(Iterable<? extends Reference> elements) {
            this.references.clear();
            return this.addAllReferences(elements);
        }

        public final Builder addAllReferences(Iterable<? extends Reference> elements) {
            for (Reference reference : elements) {
                this.references.add(Objects.requireNonNull(reference, "references element"));
            }
            return this;
        }

        public ImmutableReferencesResponse build() {
            return new ImmutableReferencesResponse(this);
        }

        private boolean isHasMoreIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ReferencesResponse", generator="Immutables")
    static final class Json
    implements ReferencesResponse {
        boolean isHasMore;
        boolean isHasMoreIsSet;
        @javax.annotation.Nullable
        String token;
        @javax.annotation.Nullable
        List<Reference> references = Collections.emptyList();

        Json() {
        }

        @JsonProperty(value="hasMore")
        public void setIsHasMore(boolean isHasMore) {
            this.isHasMore = isHasMore;
            this.isHasMoreIsSet = true;
        }

        @JsonProperty(value="token")
        public void setToken(@Nullable String token) {
            this.token = token;
        }

        @JsonProperty(value="references")
        public void setReferences(List<Reference> references) {
            this.references = references;
        }

        @Override
        public boolean isHasMore() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getToken() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Reference> getReferences() {
            throw new UnsupportedOperationException();
        }
    }
}

