/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.model.NessieConfiguration;
import org.projectnessie.model.ser.Views;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@ParametersAreNonnullByDefault
@Generated(from="NessieConfiguration", generator="Immutables")
@Immutable
public final class ImmutableNessieConfiguration
extends NessieConfiguration {
    private final String defaultBranch;
    private final int minSupportedApiVersion;
    private final int maxSupportedApiVersion;
    private final String specVersion;

    private ImmutableNessieConfiguration(Builder builder) {
        this.defaultBranch = builder.defaultBranch;
        this.maxSupportedApiVersion = builder.maxSupportedApiVersion;
        this.specVersion = builder.specVersion;
        this.minSupportedApiVersion = builder.minSupportedApiVersionIsSet() ? builder.minSupportedApiVersion : super.getMinSupportedApiVersion();
    }

    private ImmutableNessieConfiguration(String defaultBranch, int minSupportedApiVersion, int maxSupportedApiVersion, String specVersion) {
        this.defaultBranch = defaultBranch;
        this.minSupportedApiVersion = minSupportedApiVersion;
        this.maxSupportedApiVersion = maxSupportedApiVersion;
        this.specVersion = specVersion;
    }

    @Override
    @JsonProperty(value="defaultBranch")
    public String getDefaultBranch() {
        return this.defaultBranch;
    }

    @Override
    @JsonProperty(value="minSupportedApiVersion")
    @JsonView(value={Views.V2.class})
    public int getMinSupportedApiVersion() {
        return this.minSupportedApiVersion;
    }

    @Override
    @JsonProperty(value="maxSupportedApiVersion")
    public int getMaxSupportedApiVersion() {
        return this.maxSupportedApiVersion;
    }

    @Override
    @JsonProperty(value="specVersion")
    @JsonView(value={Views.V2.class})
    public String getSpecVersion() {
        return this.specVersion;
    }

    public final ImmutableNessieConfiguration withDefaultBranch(String value) {
        if (Objects.equals(this.defaultBranch, value)) {
            return this;
        }
        return new ImmutableNessieConfiguration(value, this.minSupportedApiVersion, this.maxSupportedApiVersion, this.specVersion);
    }

    public final ImmutableNessieConfiguration withMinSupportedApiVersion(int value) {
        if (this.minSupportedApiVersion == value) {
            return this;
        }
        return new ImmutableNessieConfiguration(this.defaultBranch, value, this.maxSupportedApiVersion, this.specVersion);
    }

    public final ImmutableNessieConfiguration withMaxSupportedApiVersion(int value) {
        if (this.maxSupportedApiVersion == value) {
            return this;
        }
        return new ImmutableNessieConfiguration(this.defaultBranch, this.minSupportedApiVersion, value, this.specVersion);
    }

    public final ImmutableNessieConfiguration withSpecVersion(String value) {
        if (Objects.equals(this.specVersion, value)) {
            return this;
        }
        return new ImmutableNessieConfiguration(this.defaultBranch, this.minSupportedApiVersion, this.maxSupportedApiVersion, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNessieConfiguration && this.equalTo(0, (ImmutableNessieConfiguration)another);
    }

    private boolean equalTo(int synthetic, ImmutableNessieConfiguration another) {
        return Objects.equals(this.defaultBranch, another.defaultBranch) && this.minSupportedApiVersion == another.minSupportedApiVersion && this.maxSupportedApiVersion == another.maxSupportedApiVersion && Objects.equals(this.specVersion, another.specVersion);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.defaultBranch);
        h += (h << 5) + this.minSupportedApiVersion;
        h += (h << 5) + this.maxSupportedApiVersion;
        h += (h << 5) + Objects.hashCode(this.specVersion);
        return h;
    }

    public String toString() {
        return "NessieConfiguration{defaultBranch=" + this.defaultBranch + ", minSupportedApiVersion=" + this.minSupportedApiVersion + ", maxSupportedApiVersion=" + this.maxSupportedApiVersion + ", specVersion=" + this.specVersion + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableNessieConfiguration fromJson(Json json) {
        Builder builder = ImmutableNessieConfiguration.builder();
        if (json.defaultBranch != null) {
            builder.defaultBranch(json.defaultBranch);
        }
        if (json.minSupportedApiVersionIsSet) {
            builder.minSupportedApiVersion(json.minSupportedApiVersion);
        }
        if (json.maxSupportedApiVersionIsSet) {
            builder.maxSupportedApiVersion(json.maxSupportedApiVersion);
        }
        if (json.specVersion != null) {
            builder.specVersion(json.specVersion);
        }
        return builder.build();
    }

    public static ImmutableNessieConfiguration copyOf(NessieConfiguration instance) {
        if (instance instanceof ImmutableNessieConfiguration) {
            return (ImmutableNessieConfiguration)instance;
        }
        return ImmutableNessieConfiguration.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @Generated(from="NessieConfiguration", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_MAX_SUPPORTED_API_VERSION = 1L;
        private static final long OPT_BIT_MIN_SUPPORTED_API_VERSION = 1L;
        private long initBits = 1L;
        private long optBits;
        @Nullable
        private String defaultBranch;
        private int minSupportedApiVersion;
        private int maxSupportedApiVersion;
        @Nullable
        private String specVersion;

        private Builder() {
        }

        public final Builder from(NessieConfiguration instance) {
            Objects.requireNonNull(instance, "instance");
            String defaultBranchValue = instance.getDefaultBranch();
            if (defaultBranchValue != null) {
                this.defaultBranch(defaultBranchValue);
            }
            this.minSupportedApiVersion(instance.getMinSupportedApiVersion());
            this.maxSupportedApiVersion(instance.getMaxSupportedApiVersion());
            String specVersionValue = instance.getSpecVersion();
            if (specVersionValue != null) {
                this.specVersion(specVersionValue);
            }
            return this;
        }

        @JsonProperty(value="defaultBranch")
        public final Builder defaultBranch(String defaultBranch) {
            this.defaultBranch = defaultBranch;
            return this;
        }

        @JsonProperty(value="minSupportedApiVersion")
        @JsonView(value={Views.V2.class})
        public final Builder minSupportedApiVersion(int minSupportedApiVersion) {
            this.minSupportedApiVersion = minSupportedApiVersion;
            this.optBits |= 1L;
            return this;
        }

        @JsonProperty(value="maxSupportedApiVersion")
        public final Builder maxSupportedApiVersion(int maxSupportedApiVersion) {
            this.maxSupportedApiVersion = maxSupportedApiVersion;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="specVersion")
        @JsonView(value={Views.V2.class})
        public final Builder specVersion(String specVersion) {
            this.specVersion = specVersion;
            return this;
        }

        public ImmutableNessieConfiguration build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableNessieConfiguration(this);
        }

        private boolean minSupportedApiVersionIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("maxSupportedApiVersion");
            }
            return "Cannot build NessieConfiguration, some of required attributes are not set " + attributes;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="NessieConfiguration", generator="Immutables")
    static final class Json
    extends NessieConfiguration {
        @Nullable
        String defaultBranch;
        int minSupportedApiVersion;
        boolean minSupportedApiVersionIsSet;
        int maxSupportedApiVersion;
        boolean maxSupportedApiVersionIsSet;
        @Nullable
        String specVersion;

        Json() {
        }

        @JsonProperty(value="defaultBranch")
        public void setDefaultBranch(String defaultBranch) {
            this.defaultBranch = defaultBranch;
        }

        @JsonProperty(value="minSupportedApiVersion")
        @JsonView(value={Views.V2.class})
        public void setMinSupportedApiVersion(int minSupportedApiVersion) {
            this.minSupportedApiVersion = minSupportedApiVersion;
            this.minSupportedApiVersionIsSet = true;
        }

        @JsonProperty(value="maxSupportedApiVersion")
        public void setMaxSupportedApiVersion(int maxSupportedApiVersion) {
            this.maxSupportedApiVersion = maxSupportedApiVersion;
            this.maxSupportedApiVersionIsSet = true;
        }

        @JsonProperty(value="specVersion")
        @JsonView(value={Views.V2.class})
        public void setSpecVersion(String specVersion) {
            this.specVersion = specVersion;
        }

        @Override
        public String getDefaultBranch() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getMinSupportedApiVersion() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getMaxSupportedApiVersion() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getSpecVersion() {
            throw new UnsupportedOperationException();
        }
    }
}

