/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.error;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.annotation.Nullable;
import org.immutables.value.Value;
import org.projectnessie.error.ErrorCode;
import org.projectnessie.error.ImmutableNessieError;
import org.projectnessie.model.NessieErrorDetails;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@JsonSerialize(as=ImmutableNessieError.class)
@JsonDeserialize(as=ImmutableNessieError.class)
@Value.Immutable
public interface NessieError {
    public int getStatus();

    public String getReason();

    @Value.Default
    default public String getMessage() {
        return this.getReason();
    }

    @Value.Default
    default public ErrorCode getErrorCode() {
        return ErrorCode.UNKNOWN;
    }

    @Nullable
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public NessieErrorDetails getErrorDetails();

    @Nullable
    public String getServerStackTrace();

    @JsonIgnore
    @Nullable
    @Value.Auxiliary
    public Exception getClientProcessingException();

    @JsonIgnore
    default public String getFullMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getReason()).append(" (HTTP/").append(this.getStatus()).append(')');
        sb.append(": ");
        sb.append(this.getMessage());
        if (this.getServerStackTrace() != null) {
            sb.append("\n").append(this.getServerStackTrace());
        }
        if (this.getClientProcessingException() != null) {
            StringWriter sw = new StringWriter();
            this.getClientProcessingException().printStackTrace(new PrintWriter(sw));
            sb.append("\n").append(sw);
        }
        return sb.toString();
    }
}

