/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.api.v1.params;

import jakarta.validation.constraints.Pattern;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nullable;
import javax.ws.rs.QueryParam;
import org.eclipse.microprofile.openapi.annotations.media.ExampleObject;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;
import org.immutables.builder.Builder;
import org.projectnessie.api.v1.params.AbstractParams;
import org.projectnessie.api.v1.params.EntriesParamsBuilder;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class EntriesParams
extends AbstractParams<EntriesParams> {
    @Nullable
    @jakarta.annotation.Nullable
    @javax.validation.constraints.Pattern(regexp="^([0-9a-fA-F]{8,64})?((?:([~*^])([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}[.][0-9]{1,9}Z|([0-9]+)))*)$", message="Hash with optional timestamp with optional parent must consist of a valid commit hash (consist of the hex representation of 4-32 bytes), optionally followed by a numeric timestamp (milliseconds since epoch), optionally followed relative pointers: '~' + a number representing the n-th predecessor of a commit, '^' + a number representing the n-th parent within a commit or '*' + a number representing the created timestamp in milliseconds since epoch of a commit")
    @Pattern(regexp="^([0-9a-fA-F]{8,64})?((?:([~*^])([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}[.][0-9]{1,9}Z|([0-9]+)))*)$", message="Hash with optional timestamp with optional parent must consist of a valid commit hash (consist of the hex representation of 4-32 bytes), optionally followed by a numeric timestamp (milliseconds since epoch), optionally followed relative pointers: '~' + a number representing the n-th predecessor of a commit, '^' + a number representing the n-th parent within a commit or '*' + a number representing the created timestamp in milliseconds since epoch of a commit")
    @Parameter(description="a particular hash on the given ref", examples={@ExampleObject(ref="nullHash"), @ExampleObject(ref="hash")})
    @QueryParam(value="hashOnRef")
    @jakarta.ws.rs.QueryParam(value="hashOnRef")
    private @javax.validation.constraints.Pattern(regexp="^([0-9a-fA-F]{8,64})?((?:([~*^])([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}[.][0-9]{1,9}Z|([0-9]+)))*)$", message="Hash with optional timestamp with optional parent must consist of a valid commit hash (consist of the hex representation of 4-32 bytes), optionally followed by a numeric timestamp (milliseconds since epoch), optionally followed relative pointers: '~' + a number representing the n-th predecessor of a commit, '^' + a number representing the n-th parent within a commit or '*' + a number representing the created timestamp in milliseconds since epoch of a commit") @Pattern(regexp="^([0-9a-fA-F]{8,64})?((?:([~*^])([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}[.][0-9]{1,9}Z|([0-9]+)))*)$", message="Hash with optional timestamp with optional parent must consist of a valid commit hash (consist of the hex representation of 4-32 bytes), optionally followed by a numeric timestamp (milliseconds since epoch), optionally followed relative pointers: '~' + a number representing the n-th predecessor of a commit, '^' + a number representing the n-th parent within a commit or '*' + a number representing the created timestamp in milliseconds since epoch of a commit") String hashOnRef;
    @Nullable
    @jakarta.annotation.Nullable
    @Parameter(description="If set > 0 will filter the results to only return namespaces/tables to the depth of namespaceDepth. If not set or <=0 has no effect\nSetting this parameter > 0 will turn off paging.")
    @QueryParam(value="namespaceDepth")
    @jakarta.ws.rs.QueryParam(value="namespaceDepth")
    private Integer namespaceDepth;
    @Nullable
    @jakarta.annotation.Nullable
    @Parameter(description="A Common Expression Language (CEL) expression. An intro to CEL can be found at https://github.com/google/cel-spec/blob/master/doc/intro.md.\nUsable variables within the expression are 'entry.namespace' (string) & 'entry.contentType' (string)", examples={@ExampleObject(ref="expr_by_namespace"), @ExampleObject(ref="expr_by_contentType"), @ExampleObject(ref="expr_by_namespace_and_contentType")})
    @QueryParam(value="filter")
    @jakarta.ws.rs.QueryParam(value="filter")
    private String filter;

    public EntriesParams() {
    }

    @Builder.Constructor
    EntriesParams(@Nullable @jakarta.annotation.Nullable String hashOnRef, @Nullable @jakarta.annotation.Nullable Integer maxRecords, @Nullable @jakarta.annotation.Nullable String pageToken, @Nullable @jakarta.annotation.Nullable Integer namespaceDepth, @Nullable @jakarta.annotation.Nullable String filter) {
        super(maxRecords, pageToken);
        this.hashOnRef = hashOnRef;
        this.namespaceDepth = namespaceDepth;
        this.filter = filter;
    }

    public static EntriesParamsBuilder builder() {
        return new EntriesParamsBuilder();
    }

    public static EntriesParams empty() {
        return EntriesParams.builder().build();
    }

    @Nullable
    @jakarta.annotation.Nullable
    public String hashOnRef() {
        return this.hashOnRef;
    }

    @Nullable
    @jakarta.annotation.Nullable
    public String filter() {
        return this.filter;
    }

    @Nullable
    @jakarta.annotation.Nullable
    public Integer namespaceDepth() {
        return this.namespaceDepth;
    }

    @Override
    public EntriesParams forNextPage(String pageToken) {
        return new EntriesParams(this.hashOnRef, this.maxRecords(), pageToken, this.namespaceDepth, this.filter);
    }

    public String toString() {
        return new StringJoiner(", ", EntriesParams.class.getSimpleName() + "[", "]").add("hashOnRef='" + this.hashOnRef + "'").add("maxRecords=" + this.maxRecords()).add("pageToken='" + this.pageToken() + "'").add("filter='" + this.filter + "'").add("namespaceDepth='" + this.namespaceDepth + "'").toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EntriesParams)) {
            return false;
        }
        EntriesParams that = (EntriesParams)o;
        return Objects.equals(this.hashOnRef, that.hashOnRef) && Objects.equals(this.maxRecords(), that.maxRecords()) && Objects.equals(this.pageToken(), that.pageToken()) && Objects.equals(this.namespaceDepth, that.namespaceDepth) && Objects.equals(this.filter, that.filter);
    }

    public int hashCode() {
        return Objects.hash(this.hashOnRef, this.maxRecords(), this.pageToken(), this.namespaceDepth, this.filter);
    }
}

